/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.util.ToStringBuilder;
import io.imply.cloud.validators.ImplyBundleExists;
import io.imply.cloud.validators.ImplyVersionFormat;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImplyVersion {
    @JsonProperty
    @ImplyVersionFormat
    private final String version;
    @JsonProperty
    private final String description;
    @JsonProperty
    @ImplyBundleExists
    private final String bundleId;
    @JsonProperty(value="default")
    private final Boolean defaultVersion;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private final List<String> visibilityWhitelist;
    @JsonProperty
    private final ComparableVersion comparableVersion;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private final Boolean hidden;
    @JsonProperty
    private final Boolean current;

    private ImplyVersion(String version) {
        this(version, null, null, false, null, null, false, false);
    }

    public ImplyVersion(String version, RefreshableConstants refreshableConstants) {
        this(version, null, null, false, null, refreshableConstants != null ? refreshableConstants.lookupComparableVersion(version) : null, false, false);
    }

    public ImplyVersion withDefaultsForUnset() {
        return new ImplyVersion(this.version, this.description, (String)ObjectUtils.getIfNull((Object)this.bundleId, () -> this.version == null ? null : String.format("imply-%s", this.version)), BooleanUtils.isNotFalse((Boolean)this.defaultVersion), this.visibilityWhitelist, (ComparableVersion)ObjectUtils.getIfNull((Object)this.comparableVersion, () -> this.version == null ? null : new ComparableVersion(this.version)), (Boolean)ObjectUtils.defaultIfNull((Object)this.hidden, (Object)false), (Boolean)ObjectUtils.defaultIfNull((Object)this.current, (Object)true));
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.version) && !Strings.isNullOrEmpty((String)this.bundleId) && this.comparableVersion != null;
    }

    public void validate(List<ImplyConstraintViolation> results) {
        if (StringUtils.isBlank((CharSequence)this.version)) {
            results.add(ImplyConstraintViolation.error("implyVersionFull.version", "[version] cannot be empty", new Object[0]));
        } else if (!this.version.matches("^(\\d+)\\.(\\d+)(?:[\\.|-](\\d+))?(?:\\.(\\d+))?.*")) {
            results.add(ImplyConstraintViolation.error("implyVersionFull.version", "[version] format is invalid", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.bundleId)) {
            results.add(ImplyConstraintViolation.error("implyVersionFull.bundleId", "[bundleId] cannot be empty", new Object[0]));
        }
        if (this.comparableVersion == null) {
            results.add(ImplyConstraintViolation.error("implyVersionFull.comparableVersion", "[comparableVersion] cannot be empty", new Object[0]));
        }
    }

    public boolean isDefaultVersion() {
        return BooleanUtils.isTrue((Boolean)this.defaultVersion);
    }

    public boolean isHidden() {
        return BooleanUtils.isTrue((Boolean)this.hidden);
    }

    public boolean isCurrent() {
        return BooleanUtils.isTrue((Boolean)this.current);
    }

    public String toString() {
        return new ToStringBuilder(this).append("version", this.version).append("description", (Object)this.description).append("bundleId", (Object)this.bundleId).append("defaultVersion", (Object)this.defaultVersion).append("visibilityWhitelist", this.visibilityWhitelist).append("comparableVersion", (Object)this.comparableVersion).append("hidden", (Object)this.hidden).append("current", (Object)this.current).toString();
    }

    @Generated
    protected ImplyVersion(Builder<?, ?> b) {
        this.version = b.version;
        this.description = b.description;
        this.bundleId = b.bundleId;
        this.defaultVersion = b.defaultVersion;
        this.visibilityWhitelist = b.visibilityWhitelist;
        this.comparableVersion = b.comparableVersion;
        this.hidden = b.hidden;
        this.current = b.current;
    }

    @Generated
    public static Builder<?, ?> builder() {
        return new BuilderImpl();
    }

    @Generated
    public Builder<?, ?> toBuilder() {
        return new BuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public ImplyVersion(String version, String description, String bundleId, Boolean defaultVersion, List<String> visibilityWhitelist, ComparableVersion comparableVersion, Boolean hidden, Boolean current) {
        this.version = version;
        this.description = description;
        this.bundleId = bundleId;
        this.defaultVersion = defaultVersion;
        this.visibilityWhitelist = visibilityWhitelist;
        this.comparableVersion = comparableVersion;
        this.hidden = hidden;
        this.current = current;
    }

    @Generated
    protected ImplyVersion() {
        this.version = null;
        this.description = null;
        this.bundleId = null;
        this.defaultVersion = null;
        this.visibilityWhitelist = null;
        this.comparableVersion = null;
        this.hidden = null;
        this.current = null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplyVersion)) {
            return false;
        }
        ImplyVersion other = (ImplyVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$bundleId = this.getBundleId();
        String other$bundleId = other.getBundleId();
        if (this$bundleId == null ? other$bundleId != null : !this$bundleId.equals(other$bundleId)) {
            return false;
        }
        ComparableVersion this$comparableVersion = this.getComparableVersion();
        ComparableVersion other$comparableVersion = other.getComparableVersion();
        return !(this$comparableVersion == null ? other$comparableVersion != null : !((Object)this$comparableVersion).equals(other$comparableVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImplyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $bundleId = this.getBundleId();
        result = result * 59 + ($bundleId == null ? 43 : $bundleId.hashCode());
        ComparableVersion $comparableVersion = this.getComparableVersion();
        result = result * 59 + ($comparableVersion == null ? 43 : ((Object)$comparableVersion).hashCode());
        return result;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getBundleId() {
        return this.bundleId;
    }

    @Generated
    public List<String> getVisibilityWhitelist() {
        return this.visibilityWhitelist;
    }

    @Generated
    public ComparableVersion getComparableVersion() {
        return this.comparableVersion;
    }

    @Generated
    private Boolean getDefaultVersion() {
        return this.defaultVersion;
    }

    @Generated
    private Boolean getHidden() {
        return this.hidden;
    }

    @Generated
    private Boolean getCurrent() {
        return this.current;
    }

    @Generated
    public static abstract class Builder<C extends ImplyVersion, B extends Builder<C, B>> {
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private String bundleId;
        @Generated
        private Boolean defaultVersion;
        @Generated
        private List<String> visibilityWhitelist;
        @Generated
        private ComparableVersion comparableVersion;
        @Generated
        private Boolean hidden;
        @Generated
        private Boolean current;

        @Generated
        protected B $fillValuesFrom(C instance) {
            Builder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ImplyVersion instance, Builder<?, ?> b) {
            b.version(instance.version);
            b.description(instance.description);
            b.bundleId(instance.bundleId);
            b.defaultVersion(instance.defaultVersion);
            b.visibilityWhitelist(instance.visibilityWhitelist);
            b.comparableVersion(instance.comparableVersion);
            b.hidden(instance.hidden);
            b.current(instance.current);
        }

        @JsonProperty
        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this.self();
        }

        @JsonProperty(value="default")
        @Generated
        public B defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this.self();
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Generated
        public B visibilityWhitelist(List<String> visibilityWhitelist) {
            this.visibilityWhitelist = visibilityWhitelist;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B comparableVersion(ComparableVersion comparableVersion) {
            this.comparableVersion = comparableVersion;
            return this.self();
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Generated
        public B hidden(Boolean hidden) {
            this.hidden = hidden;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B current(Boolean current) {
            this.current = current;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ImplyVersion.Builder(version=" + this.version + ", description=" + this.description + ", bundleId=" + this.bundleId + ", defaultVersion=" + this.defaultVersion + ", visibilityWhitelist=" + String.valueOf(this.visibilityWhitelist) + ", comparableVersion=" + String.valueOf(this.comparableVersion) + ", hidden=" + this.hidden + ", current=" + this.current + ")";
        }
    }

    @Generated
    private static final class BuilderImpl
    extends Builder<ImplyVersion, BuilderImpl> {
        @Generated
        private BuilderImpl() {
        }

        @Override
        @Generated
        protected BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ImplyVersion build() {
            return new ImplyVersion(this);
        }
    }
}

