/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.util.StringUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImplyConstraintViolation {
    private final List<String> fieldNames;
    private final String message;
    private final Severity severity;

    @JsonCreator
    private ImplyConstraintViolation(@JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="message") String message, @JsonProperty(value="severity") Severity severity) {
        this.fieldNames = fieldNames;
        this.message = message;
        this.severity = severity;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return new ToStringBuilder(this).append("fieldNames", this.fieldNames).append("message", (Object)this.message).append("severity", (Object)this.severity).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplyConstraintViolation that = (ImplyConstraintViolation)o;
        return Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.message, that.message) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldNames, this.message, this.severity});
    }

    public static ImplyConstraintViolation warning(String fieldName, String formatText, Object ... arguments) {
        return ImplyConstraintViolation.warning(Collections.singletonList(fieldName), formatText, arguments);
    }

    public static ImplyConstraintViolation warning(List<String> fieldNames, String formatText, Object ... arguments) {
        return new ImplyConstraintViolation(fieldNames, StringUtils.safeFormat(formatText, arguments), Severity.WARNING);
    }

    public static ImplyConstraintViolation error(String fieldName, String formatText, Object ... arguments) {
        return ImplyConstraintViolation.error(Collections.singletonList(fieldName), formatText, arguments);
    }

    public static ImplyConstraintViolation error(List<String> fieldNames, String formatText, Object ... arguments) {
        return new ImplyConstraintViolation(fieldNames, StringUtils.safeFormat(formatText, arguments), Severity.ERROR);
    }

    public static enum Severity {
        WARNING,
        ERROR,
        UNKNOWN;

    }
}

