/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.imply.cloud.model.CloudFormationStatus;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Instance;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.model.RdsUpdateInfo;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.ValueAndUrl;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtendedInfo {
    @NonNull
    private final Info info;
    private final CloudResources cloudResources;
    private final Notifications notifications;
    private final String rootCertificateUrl;
    private final ClusterNodes clusterNodes;
    private final Boolean isLogviewSupported;
    private final Boolean isKubernetesMode;

    @JsonUnwrapped
    public Info getInfo() {
        return this.info;
    }

    @JsonProperty
    public Map<String, Object> getDetails() {
        return this.cloudResources != null ? this.cloudResources.getDetails() : null;
    }

    @JsonProperty
    public CloudFormationStatus getCloudFormationStatus() {
        return this.cloudResources != null ? this.cloudResources.getCloudFormationStatus() : null;
    }

    @JsonProperty
    public Map<ImplyNodeType, List<Instance>> getHosts() {
        return this.cloudResources == null ? null : this.cloudResources.getHosts();
    }

    @JsonProperty
    public Map<String, String> getLoadBalancers() {
        return this.cloudResources != null ? this.cloudResources.getLoadBalancers() : null;
    }

    @JsonProperty
    public Map<String, ValueAndUrl> getUrls() {
        return this.cloudResources != null ? this.cloudResources.getUrls() : null;
    }

    @JsonProperty
    public List<RdsUpdateInfo> getPendingRdsUpdates() {
        return this.cloudResources != null ? this.cloudResources.getPendingRdsUpdates() : null;
    }

    @JsonProperty
    public DateTime getFetchTime() {
        return this.cloudResources != null ? this.cloudResources.getFetchTime() : null;
    }

    @JsonProperty
    public DateTime getServerTime() {
        return DateTime.now();
    }

    @JsonProperty
    public List<Notification> getNotifications() {
        Notifications notifications = this.getNotificationsInternal();
        return notifications == null ? null : notifications.getNotificationList();
    }

    @JsonProperty
    public Status getStatus() {
        Notifications notifications = this.getNotificationsInternal();
        return notifications == null ? null : notifications.getStatusFromNotifications();
    }

    @JsonProperty
    public String getRootCertificateUrl() {
        return this.rootCertificateUrl;
    }

    @JsonProperty
    public Integer getClusterNodesVersion() {
        return this.clusterNodes != null ? this.clusterNodes.getVersion() : null;
    }

    @JsonProperty
    public Boolean isDeleteNotAllowed() {
        if (BooleanUtils.isTrue((Boolean)this.isKubernetesMode)) {
            return false;
        }
        return this.clusterNodes != null && this.clusterNodes.getNodes() != null && this.clusterNodes.getNodes().values().stream().anyMatch(x -> x.isCattle() != null && x.isCattle() != false);
    }

    @JsonProperty
    public Boolean isLogviewSupported() {
        return this.isLogviewSupported;
    }

    public ExtendedInfo stripInternalFields() {
        Object infoBuilder = this.info.cloner().stripInternalFields();
        if (EntityType.CLUSTER.equals((Object)this.info.getEntityType()) && this.info.getState() != null && State.RUNNING.equals((Object)this.info.getState().getExternalState(null)) && this.cloudResources != null && (this.cloudResources.getHosts() == null || this.cloudResources.getHosts().isEmpty())) {
            ((Info.Builder)infoBuilder).withState(State.READY);
        }
        return new ExtendedInfo((Info)((Info.Builder)infoBuilder).build(), this.cloudResources != null ? this.cloudResources.stripInternalFields() : null, this.notifications, this.rootCertificateUrl, this.clusterNodes, this.isLogviewSupported, this.isKubernetesMode);
    }

    public ExtendedInfo useExternalState() {
        Object infoBuilder = this.info.cloner().useExternalState();
        return new ExtendedInfo((Info)((Info.Builder)infoBuilder).build(), this.cloudResources, this.notifications, this.rootCertificateUrl, this.clusterNodes, this.isLogviewSupported, this.isKubernetesMode);
    }

    public static ExtendedInfo of(Info info) {
        return ExtendedInfo.of(info, null, null, null, null, null, null);
    }

    private Notifications getNotificationsInternal() {
        if (this.notifications == null && (this.cloudResources == null || this.cloudResources.getNotifications() == null)) {
            return null;
        }
        Notifications allNotifications = new Notifications();
        allNotifications.addNotifications(this.notifications);
        if (this.cloudResources != null) {
            allNotifications.addNotifications(this.cloudResources.getNotifications());
        }
        return allNotifications.stripInternalFields();
    }

    @Generated
    private ExtendedInfo(@NonNull Info info, CloudResources cloudResources, Notifications notifications, String rootCertificateUrl, ClusterNodes clusterNodes, Boolean isLogviewSupported, Boolean isKubernetesMode) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.info = info;
        this.cloudResources = cloudResources;
        this.notifications = notifications;
        this.rootCertificateUrl = rootCertificateUrl;
        this.clusterNodes = clusterNodes;
        this.isLogviewSupported = isLogviewSupported;
        this.isKubernetesMode = isKubernetesMode;
    }

    @Generated
    public static ExtendedInfo of(@NonNull Info info, CloudResources cloudResources, Notifications notifications, String rootCertificateUrl, ClusterNodes clusterNodes, Boolean isLogviewSupported, Boolean isKubernetesMode) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return new ExtendedInfo(info, cloudResources, notifications, rootCertificateUrl, clusterNodes, isLogviewSupported, isKubernetesMode);
    }
}

