/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.PodResources;
import io.imply.cloud.util.MapUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidInstanceTypeConfigItem {
    private final String serviceType;
    private final String instanceType;
    private final Map<String, String> properties;
    private final List<String> jvmConfig;
    private final PodResources containerResources;
    private final List<String> jvmConfigImmutable;

    @JsonCreator
    public DruidInstanceTypeConfigItem(@JsonProperty(value="serviceType") String serviceType, @JsonProperty(value="instanceType") String instanceType, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="jvmConfig") List<String> jvmConfig, @JsonProperty(value="containerResources") PodResources containerResources, @JsonProperty(value="jvmConfigImmutable") List<String> jvmConfigImmutable) {
        this.serviceType = serviceType;
        this.instanceType = instanceType;
        this.properties = properties;
        this.jvmConfig = jvmConfig;
        this.containerResources = containerResources;
        this.jvmConfigImmutable = jvmConfigImmutable;
    }

    @JsonProperty
    public String getServiceType() {
        return this.serviceType;
    }

    @JsonProperty
    public String getInstanceType() {
        return this.instanceType;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public List<String> getJvmConfig() {
        return this.jvmConfig;
    }

    @JsonProperty
    public PodResources getContainerResources() {
        return this.containerResources;
    }

    @JsonProperty
    public List<String> getJvmConfigImmutable() {
        return this.jvmConfigImmutable;
    }

    public DruidInstanceTypeConfigItem merge(DruidInstanceTypeConfigItem other) {
        if (other == null) {
            return this;
        }
        String serviceType = other.serviceType != null ? other.serviceType : this.serviceType;
        String instanceType = other.instanceType != null ? other.instanceType : this.instanceType;
        Map<String, String> properties = MapUtils.mergePropertyMap(this.properties, other.properties);
        List<String> jvmConfig = other.jvmConfig != null ? other.jvmConfig : this.jvmConfig;
        PodResources resources = other.containerResources != null ? other.containerResources : this.containerResources;
        List<String> jvmConfigImmutable = other.jvmConfig != null ? other.jvmConfigImmutable : this.jvmConfigImmutable;
        return new DruidInstanceTypeConfigItem(serviceType, instanceType, properties, jvmConfig, resources, jvmConfigImmutable);
    }

    public String toString() {
        return new ToStringBuilder(this).append("serviceType", this.serviceType).append("instanceType", (Object)this.instanceType).append("properties", this.properties).append("jvmConfig", this.jvmConfig).append("containerResources", (Object)this.containerResources).append("jvmConfigImmutable", this.jvmConfigImmutable).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidInstanceTypeConfigItem that = (DruidInstanceTypeConfigItem)o;
        return Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.instanceType, that.instanceType) && Objects.equals(this.properties, that.properties) && Objects.equals(this.jvmConfig, that.jvmConfig) && Objects.equals(this.containerResources, that.containerResources) && Objects.equals(this.jvmConfigImmutable, that.jvmConfigImmutable);
    }

    public int hashCode() {
        return Objects.hash(this.serviceType, this.instanceType, this.properties, this.jvmConfig, this.containerResources, this.jvmConfigImmutable);
    }
}

