/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.DruidInstanceTypeConfigItem;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidInstanceTypeConfig {
    private final ComparableVersion minImplyVersion;
    private final List<DruidInstanceTypeConfigItem> configSet;

    @JsonCreator
    public DruidInstanceTypeConfig(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="configSet") List<DruidInstanceTypeConfigItem> configSet) {
        this.minImplyVersion = minImplyVersion;
        this.configSet = configSet;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public List<DruidInstanceTypeConfigItem> getConfigSet() {
        return this.configSet;
    }

    public DruidInstanceTypeConfig merge(DruidInstanceTypeConfig other) {
        List<DruidInstanceTypeConfigItem> configSet;
        ComparableVersion minImplyVersion;
        if (other == null) {
            return this;
        }
        ComparableVersion comparableVersion = minImplyVersion = other.minImplyVersion != null ? other.minImplyVersion : this.minImplyVersion;
        if (this.configSet == null) {
            configSet = other.configSet;
        } else if (other.configSet == null) {
            configSet = this.configSet;
        } else {
            configSet = new ArrayList<DruidInstanceTypeConfigItem>(this.configSet);
            for (DruidInstanceTypeConfigItem newItem : other.configSet) {
                DruidInstanceTypeConfigItem originalItem = configSet.stream().filter(x -> x.getInstanceType().equals(newItem.getInstanceType()) && x.getServiceType().equals(newItem.getServiceType())).findFirst().orElse(null);
                if (originalItem == null) {
                    configSet.add(newItem);
                    continue;
                }
                configSet.remove(originalItem);
                configSet.add(originalItem.merge(newItem));
            }
        }
        return new DruidInstanceTypeConfig(minImplyVersion, configSet);
    }

    public boolean isNotEmpty() {
        return this.minImplyVersion != null && this.configSet != null && !this.configSet.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("configSet", this.configSet).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidInstanceTypeConfig that = (DruidInstanceTypeConfig)o;
        return Objects.equals(this.minImplyVersion, that.minImplyVersion) && Objects.equals(this.configSet, that.configSet);
    }

    public int hashCode() {
        return Objects.hash(this.minImplyVersion, this.configSet);
    }

    public static DruidInstanceTypeConfig getForComparableImplyVersion(ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        if (comparableVersion == null) {
            return null;
        }
        List configSets = refreshableConstants.getDruidInstanceTypeConfigurations().stream().sorted(Comparator.comparing(DruidInstanceTypeConfig::getMinImplyVersion)).collect(Collectors.toList());
        DruidInstanceTypeConfig mergedConfiguration = null;
        for (DruidInstanceTypeConfig configuration : configSets) {
            if (configuration.getMinImplyVersion().compareTo(comparableVersion) > 0) continue;
            mergedConfiguration = mergedConfiguration == null ? configuration : mergedConfiguration.merge(configuration);
        }
        return mergedConfiguration;
    }

    public static DruidInstanceTypeConfigItem getForServiceType(String instanceType, ServiceType serviceType, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        DruidInstanceTypeConfig configSet = DruidInstanceTypeConfig.getForComparableImplyVersion(comparableVersion, refreshableConstants);
        return configSet.getConfigSet().stream().filter(x -> instanceType.equals(x.getInstanceType()) && DruidConfigFile.getCustomDruidPropertiesKey(serviceType) != null && DruidConfigFile.getCustomDruidPropertiesKey(serviceType).toLowerCase().equals(x.getServiceType().toLowerCase())).findFirst().orElse(null);
    }
}

