/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import io.imply.cloud.model.Platform;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;

public class DruidConfigFile {
    private final String filePath;
    private final ServiceType serviceType;
    private final FileType fileType;
    private final Platform platform;
    private byte[] contents;

    public static String getCustomDruidPropertiesKey(ServiceType serviceType) {
        return DruidConfigFile.getCustomDruidPropertiesKey(serviceType, null);
    }

    public static String getCustomDruidPropertiesKey(ServiceType serviceType, ServiceTier serviceTier) {
        if (serviceType == null) {
            return null;
        }
        return serviceTier != null ? String.format("%s%s", serviceType.getCustomDruidPropertiesKey(), serviceTier.getCustomDruidPropertiesKeySuffix()) : serviceType.getCustomDruidPropertiesKey();
    }

    public DruidConfigFile(String filePath, ServiceType serviceType, FileType fileType, Platform platform) {
        this.filePath = filePath;
        this.serviceType = serviceType;
        this.fileType = fileType;
        this.platform = platform;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public static DruidConfigFile of(String filePath, ServiceType serviceType, FileType fileType) {
        return DruidConfigFile.of(filePath, serviceType, fileType, Platform.ANY);
    }

    public static DruidConfigFile of(String filePath, ServiceType serviceType, FileType fileType, Platform platform) {
        return new DruidConfigFile(filePath, serviceType, fileType, platform);
    }

    public static enum FileType {
        RUNTIME_PROPERTIES,
        JETSET_PROPERTIES,
        JVM_CONFIG,
        MAIN_CONFIG,
        PIVOT_CONFIG,
        PIVOT_LICENSE,
        SUPERVISE,
        SCRIPT,
        TRUSTSTORE,
        KEYSTORE,
        METADATA_TLS_CERT,
        METADATA_CLIENT_CERT,
        METADATA_CLIENT_KEY,
        GOOGLE_KEY_JSON,
        LOGGING_CONFIG,
        ROLE_MAPPING,
        PEON_POD_TEMPLATE,
        LOG4J,
        OTHER;

    }
}

