/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.HorizontalDataUnitType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.Scalable;
import io.imply.cloud.model.VerticalDataUnitType;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="scaling")
@JsonSubTypes(value={@JsonSubTypes.Type(name="horizontal", value=HorizontalDataUnitType.class), @JsonSubTypes.Type(name="vertical", value=VerticalDataUnitType.class)})
public abstract class DataUnitType
implements Scalable {
    @JsonProperty
    private ComparableVersion minImplyVersion;
    @JsonProperty
    private Map<Integer, InstanceTier> instanceTiers;

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("instanceTiers", this.instanceTiers).toString();
    }

    public abstract Integer getCpu(InstanceTypeHelper var1);

    public abstract Integer getMemory(InstanceTypeHelper var1);

    public abstract Integer getMaxCPUToDiskGBRatio(InstanceTypeHelper var1);

    public abstract Integer getMinCPUToDiskGBRatio(InstanceTypeHelper var1);

    public abstract Integer getMinCount();

    public abstract Integer getMaxCount();

    public static DataUnitType getForComparableImplyVersion(String unitType, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        if (StringUtils.isBlank((CharSequence)unitType) || comparableVersion == null) {
            return null;
        }
        Map<String, List<DataUnitType>> unitTypeMap = refreshableConstants.getDataUnitTypeMap();
        if (!unitTypeMap.containsKey(unitType)) {
            return null;
        }
        List<DataUnitType> versionedSizeDetails = unitTypeMap.get(unitType);
        return versionedSizeDetails.stream().sorted(Comparator.comparing(DataUnitType::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }

    public Integer getTotalInstanceCount() {
        return this.getInstanceTiers().entrySet().stream().mapToInt(e -> ((InstanceTier)e.getValue()).getInstanceCount()).sum();
    }

    @Generated
    protected DataUnitType(Builder<?, ?> b) {
        this.minImplyVersion = b.minImplyVersion;
        this.instanceTiers = b.instanceTiers;
    }

    @Generated
    public DataUnitType(ComparableVersion minImplyVersion, Map<Integer, InstanceTier> instanceTiers) {
        this.minImplyVersion = minImplyVersion;
        this.instanceTiers = instanceTiers;
    }

    @Generated
    protected DataUnitType() {
    }

    @Generated
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @Generated
    public Map<Integer, InstanceTier> getInstanceTiers() {
        return this.instanceTiers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataUnitType)) {
            return false;
        }
        DataUnitType other = (DataUnitType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComparableVersion this$minImplyVersion = this.getMinImplyVersion();
        ComparableVersion other$minImplyVersion = other.getMinImplyVersion();
        if (this$minImplyVersion == null ? other$minImplyVersion != null : !((Object)this$minImplyVersion).equals(other$minImplyVersion)) {
            return false;
        }
        Map<Integer, InstanceTier> this$instanceTiers = this.getInstanceTiers();
        Map<Integer, InstanceTier> other$instanceTiers = other.getInstanceTiers();
        return !(this$instanceTiers == null ? other$instanceTiers != null : !((Object)this$instanceTiers).equals(other$instanceTiers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataUnitType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComparableVersion $minImplyVersion = this.getMinImplyVersion();
        result = result * 59 + ($minImplyVersion == null ? 43 : ((Object)$minImplyVersion).hashCode());
        Map<Integer, InstanceTier> $instanceTiers = this.getInstanceTiers();
        result = result * 59 + ($instanceTiers == null ? 43 : ((Object)$instanceTiers).hashCode());
        return result;
    }

    @Generated
    public static abstract class Builder<C extends DataUnitType, B extends Builder<C, B>> {
        @Generated
        private ComparableVersion minImplyVersion;
        @Generated
        private Map<Integer, InstanceTier> instanceTiers;

        @JsonProperty
        @Generated
        public B minImplyVersion(ComparableVersion minImplyVersion) {
            this.minImplyVersion = minImplyVersion;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B instanceTiers(Map<Integer, InstanceTier> instanceTiers) {
            this.instanceTiers = instanceTiers;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DataUnitType.Builder(minImplyVersion=" + String.valueOf(this.minImplyVersion) + ", instanceTiers=" + String.valueOf(this.instanceTiers) + ")";
        }
    }
}

