/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ColdTierClusterSize {
    NONE("", 0),
    X_SMALL("x_small", 1),
    SMALL("small", 2),
    MEDIUM("medium", 3),
    LARGE("large", 4),
    X_LARGE("x_large", 5),
    X2_LARGE("2x_large", 6);

    private final String name;
    private final Integer size;

    private ColdTierClusterSize(String name, Integer size) {
        this.name = name;
        this.size = size;
    }

    public static ColdTierClusterSize fromName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return NONE;
        }
        return Arrays.stream(ColdTierClusterSize.values()).filter(size -> size.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("The cold tier cluster size specified, '" + name + "', is not a known size."));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }
}

