/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.Constants;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.exception.ImplyViolationException;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.DruidExtensions;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.Mapbox;
import io.imply.cloud.model.OtelCollector;
import io.imply.cloud.model.Pivot;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.druid.S3DeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.util.DiffUtils;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.PropertiesHelper;
import io.imply.cloud.util.ToStringBuilder;
import io.imply.cloud.util.YAML;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Cluster
implements Diffable<Cluster> {
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    protected static final YAML YAML = new YAML(YAML_MAPPER);
    private final String accountId;
    private final String clusterId;
    private final String name;
    private final String implyVersion;
    private final String masterInstanceType;
    private final String queryInstanceType;
    private final Integer masterInstanceCount;
    private final Integer queryInstanceCount;
    private final Integer version;
    private final Integer logRetentionDays;
    private final MetadataStorage metadataStorage;
    @Deprecated
    private final Map<String, Object> extraDruidProperties;
    private final Map<String, String> customDruidProperties;
    private final Integer clusterNumber;
    private final DateTime created;
    private final DateTime lastModified;
    private final String configServerKey;
    private final String createdBy;
    private final String modifiedBy;
    private final String comments;
    @Deprecated
    private final String implyBundleId;
    private final ImplyVersion implyVersionFull;
    private final Map<String, String> userExtensions;
    private final List<String> extensionLoadList;
    private final SecurityConfiguration securityConfiguration;
    private final List<UserFile> customFiles;
    private final DeepStorage deepStorage;
    private final Boolean encryptDataVolumes;
    private final Map<Integer, InstanceTier> dataInstanceTiers;
    private final List<String> featureFlags;
    private final ZooKeeper zooKeeper;
    private final Map<String, String> userTags;
    private final Map<String, Object> metadata;
    private final Boolean useTls;
    private final Boolean useAuthentication;
    private final Boolean deletionProtection;
    private final Boolean stopProtection;
    private final Pivot pivot;
    private final Mapbox mapbox;
    private final OtelCollector otelCollector;

    @JsonCreator
    public Cluster(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="name") String name, @JsonProperty(value="implyVersion") String implyVersion, @JsonProperty(value="masterInstanceType") String masterInstanceType, @JsonProperty(value="queryInstanceType") String queryInstanceType, @JsonProperty(value="dataInstanceType") String dataInstanceType, @JsonProperty(value="masterInstanceCount") Integer masterInstanceCount, @JsonProperty(value="queryInstanceCount") Integer queryInstanceCount, @JsonProperty(value="dataInstanceCount") Integer dataInstanceCount, @JsonProperty(value="version") Integer version, @JsonProperty(value="logRetentionDays") Integer logRetentionDays, @JsonProperty(value="metadataStorage") MetadataStorage metadataStorage, @JsonProperty(value="extraDruidProperties") Map<String, Object> extraDruidProperties, @JsonProperty(value="customDruidProperties") Map<String, String> customDruidProperties, @JsonProperty(value="clusterNumber") Integer clusterNumber, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="userId") String userId, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="modifiedBy") String modifiedBy, @JsonProperty(value="comments") String comments, @JsonProperty(value="configServerKey") String configServerKey, @JsonProperty(value="implyBundleId") String implyBundleId, @JsonProperty(value="implyVersionFull") ImplyVersion implyVersionFull, @JsonProperty(value="userExtensions") Map<String, String> userExtensions, @JsonProperty(value="extensionLoadList") List<String> extensionLoadList, @JsonProperty(value="security") SecurityConfiguration securityConfiguration, @JsonProperty(value="userFiles") List<String> userFiles, @JsonProperty(value="customFiles") List<UserFile> customFiles, @JsonProperty(value="s3Location") String s3Location, @JsonProperty(value="deepStorage") DeepStorage deepStorage, @JsonProperty(value="encryptDataVolumes") Boolean encryptDataVolumes, @JsonProperty(value="dataInstanceTiers") Map<Integer, InstanceTier> dataInstanceTiers, @JsonProperty(value="featureFlags") List<String> featureFlags, @JsonProperty(value="userTags") Map<String, String> userTags, @JsonProperty(value="zooKeeper") ZooKeeper zooKeeper, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="useTls") Boolean useTls, @JsonProperty(value="useAuthentication") Boolean useAuthentication, @JsonProperty(value="pivot") Pivot pivot, @JsonProperty(value="deletionProtection") Boolean deletionProtection, @JsonProperty(value="stopProtection") Boolean stopProtection, @JsonProperty(value="mapbox") Mapbox mapbox, @JsonProperty(value="otelCollector") OtelCollector otelCollector) {
        this.accountId = accountId;
        this.clusterId = clusterId;
        this.name = name;
        this.implyVersion = implyVersion;
        this.masterInstanceType = masterInstanceType;
        this.queryInstanceType = queryInstanceType;
        this.masterInstanceCount = masterInstanceCount;
        this.queryInstanceCount = queryInstanceCount;
        this.version = version;
        this.logRetentionDays = logRetentionDays;
        this.metadataStorage = metadataStorage;
        this.extraDruidProperties = customDruidProperties != null ? Cluster.convertCustomDruidPropertiesToExtraDruidProperties(customDruidProperties) : extraDruidProperties;
        this.customDruidProperties = customDruidProperties != null ? new HashMap<String, String>(customDruidProperties) : Cluster.convertExtraDruidPropertiesToCustomDruidProperties(extraDruidProperties);
        this.clusterNumber = clusterNumber;
        this.created = created;
        this.lastModified = lastModified;
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy != null ? modifiedBy : userId;
        this.comments = comments;
        this.configServerKey = configServerKey;
        this.implyBundleId = implyBundleId;
        this.implyVersionFull = implyVersionFull;
        this.userExtensions = userExtensions;
        this.extensionLoadList = extensionLoadList != null ? new ArrayList<String>(extensionLoadList) : null;
        this.securityConfiguration = securityConfiguration;
        List<UserFile> list = customFiles != null ? new ArrayList<UserFile>(customFiles) : (this.customFiles = userFiles == null ? null : userFiles.stream().map(UserFile::new).collect(Collectors.toList()));
        this.deepStorage = deepStorage != null ? deepStorage : (s3Location != null ? new S3DeepStorage(s3Location, null, null, null) : null);
        this.encryptDataVolumes = encryptDataVolumes;
        this.dataInstanceTiers = dataInstanceTiers != null ? dataInstanceTiers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((InstanceTier)x.getValue()).withDefaultsForUnset())) : (dataInstanceType != null && dataInstanceCount != null ? ImmutableMap.of((Object)1, (Object)new InstanceTier("_default_tier", dataInstanceType, dataInstanceCount, Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT)) : null);
        this.featureFlags = featureFlags != null ? new ArrayList<String>(featureFlags) : null;
        this.userTags = userTags != null ? new HashMap<String, String>(userTags) : null;
        this.zooKeeper = zooKeeper;
        this.metadata = metadata;
        this.useTls = useTls;
        this.useAuthentication = useAuthentication;
        this.pivot = pivot;
        this.mapbox = mapbox;
        this.deletionProtection = deletionProtection;
        this.stopProtection = stopProtection;
        this.otelCollector = otelCollector;
    }

    public String key() {
        return this.accountId == null || this.clusterId == null ? null : String.format("%s/%s", this.accountId, this.clusterId);
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getImplyVersion() {
        return this.implyVersion;
    }

    @JsonProperty
    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    @JsonProperty
    public String getQueryInstanceType() {
        return this.queryInstanceType;
    }

    @JsonProperty
    public Integer getMasterInstanceCount() {
        return this.masterInstanceCount;
    }

    @JsonProperty
    public Integer getQueryInstanceCount() {
        return this.queryInstanceCount;
    }

    @JsonProperty
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty
    public Integer getLogRetentionDays() {
        return this.logRetentionDays;
    }

    @JsonProperty
    public MetadataStorage getMetadataStorage() {
        return this.metadataStorage;
    }

    public boolean isLogviewSupported() {
        return false;
    }

    @JsonProperty
    public Map<String, String> getCustomDruidProperties() {
        if (this.customDruidProperties != null) {
            return this.customDruidProperties;
        }
        if (this.extraDruidProperties != null) {
            return Cluster.convertExtraDruidPropertiesToCustomDruidProperties(this.extraDruidProperties);
        }
        return null;
    }

    @JsonProperty
    public Integer getClusterNumber() {
        return this.clusterNumber;
    }

    @JsonProperty
    public DateTime getCreated() {
        return this.created;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @Deprecated
    @JsonProperty(value="userId")
    public String getUserIdLegacy() {
        return this.getModifiedBy();
    }

    @JsonProperty
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @JsonProperty
    public String getComments() {
        return this.comments;
    }

    @JsonProperty
    public String getConfigServerKey() {
        return this.configServerKey;
    }

    @Deprecated
    @JsonProperty
    public String getImplyBundleId() {
        return this.implyVersionFull != null ? this.implyVersionFull.getBundleId() : this.implyBundleId;
    }

    @JsonProperty
    public ImplyVersion getImplyVersionFull() {
        return this.implyVersionFull;
    }

    @JsonProperty
    public Map<String, String> getUserExtensions() {
        return this.userExtensions;
    }

    @JsonProperty
    public List<String> getExtensionLoadList() {
        return this.extensionLoadList;
    }

    @JsonProperty(value="security")
    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    @Deprecated
    @JsonProperty
    public List<String> getUserFiles() {
        return this.customFiles == null ? null : this.customFiles.stream().map(UserFile::getPath).collect(Collectors.toList());
    }

    @JsonProperty
    public List<UserFile> getCustomFiles() {
        return this.customFiles;
    }

    @JsonProperty
    public DeepStorage getDeepStorage() {
        return this.deepStorage;
    }

    @JsonProperty
    public Boolean isEncryptDataVolumes() {
        return this.encryptDataVolumes;
    }

    @JsonProperty
    public Map<Integer, InstanceTier> getDataInstanceTiers() {
        return this.dataInstanceTiers;
    }

    @JsonProperty
    public List<String> getFeatureFlags() {
        return this.featureFlags;
    }

    @JsonProperty
    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    @JsonProperty
    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    @JsonProperty
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public Boolean isUseTls() {
        return this.useTls;
    }

    @JsonProperty
    public Boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    @JsonProperty
    public Pivot getPivot() {
        return this.pivot;
    }

    @JsonProperty
    public Mapbox getMapbox() {
        return this.mapbox;
    }

    @JsonProperty
    public Boolean isDeletionProtection() {
        return this.deletionProtection;
    }

    @JsonProperty
    public Boolean isStopProtection() {
        return this.stopProtection;
    }

    public String getLogGroupName() {
        return String.format("imply-cloud-%s", this.clusterId);
    }

    @JsonProperty
    public OtelCollector getOtelCollector() {
        return this.otelCollector;
    }

    public final List<ImplyConstraintViolation> validate(Account account, Toolbox toolbox, boolean skipClusterId) {
        return this.validate(account, toolbox, skipClusterId, true);
    }

    public final List<ImplyConstraintViolation> validate(Account account, Toolbox toolbox, boolean skipClusterId, boolean throwExceptions) {
        ArrayList<ImplyConstraintViolation> results = new ArrayList<ImplyConstraintViolation>();
        this.validateInternal(results, account, toolbox, skipClusterId);
        Set constraintViolations = results.stream().filter(violation -> ImplyConstraintViolation.Severity.ERROR.equals((Object)violation.getSeverity())).collect(Collectors.toSet());
        if (throwExceptions && CollectionUtils.isNotEmpty(constraintViolations)) {
            throw new ImplyViolationException(constraintViolations);
        }
        return results;
    }

    protected void validateInternal(List<ImplyConstraintViolation> results, Account account, Toolbox toolbox, boolean skipClusterId) {
        Map<String, String> map;
        Map<String, String> customDruidProperties;
        List supportedImplyVersions = toolbox.getImplyVersionHelper().getSupportedImplyVersionsIncludingAccountVersions(account != null ? account.getAccountId() : null, toolbox.getClusterDataManager()).stream().map(ImplyVersion::getVersion).collect(Collectors.toList());
        List supportedMasterInstanceTypes = toolbox.getRefreshableConstants().getSupportedMasterInstanceTypes().stream().map(InstanceType::getInstanceType).collect(Collectors.toList());
        List supportedQueryInstanceTypes = toolbox.getRefreshableConstants().getSupportedQueryInstanceTypes().stream().map(InstanceType::getInstanceType).collect(Collectors.toList());
        List supportedDataInstanceTypes = toolbox.getRefreshableConstants().getSupportedDataInstanceTypes().stream().map(InstanceType::getInstanceType).collect(Collectors.toList());
        if (this.accountId == null || this.accountId.isEmpty()) {
            results.add(ImplyConstraintViolation.error("accountId", "[accountId] cannot be empty", new Object[0]));
        }
        if (!skipClusterId && (this.clusterId == null || this.clusterId.isEmpty())) {
            results.add(ImplyConstraintViolation.error("clusterId", "[clusterId] cannot be empty", new Object[0]));
        }
        if (this.name == null || this.name.isEmpty()) {
            results.add(ImplyConstraintViolation.error("name", "[name] cannot be empty", new Object[0]));
        }
        if (this.implyVersionFull == null) {
            results.add(ImplyConstraintViolation.error("implyVersion", "[implyVersion] must be one of %s", supportedImplyVersions));
        } else {
            this.implyVersionFull.validate(results);
        }
        if (toolbox.getApplicationConfig().isAWS() || toolbox.getApplicationConfig().isKubernetesMode()) {
            if (this.getMasterInstanceType() == null || !supportedMasterInstanceTypes.contains(this.getMasterInstanceType())) {
                results.add(ImplyConstraintViolation.error("masterInstanceType", "[masterInstanceType] must be one of %s", supportedMasterInstanceTypes));
            }
            if (this.getQueryInstanceType() == null || !supportedQueryInstanceTypes.contains(this.getQueryInstanceType())) {
                results.add(ImplyConstraintViolation.error("queryInstanceType", "[queryInstanceType] must be one of %s", supportedQueryInstanceTypes));
            }
            if (!(toolbox.getApplicationConfig().isSaaS() || toolbox.getApplicationConfig().isIOW() || this.getMasterInstanceCount() != null && (this.getMasterInstanceCount().equals(1) || this.getMasterInstanceCount().equals(3)))) {
                results.add(ImplyConstraintViolation.error("masterInstanceCount", "[masterInstanceCount] must be either 1 or 3", new Object[0]));
            }
            if (this.getQueryInstanceCount() == null || this.getQueryInstanceCount() < 1 || this.getQueryInstanceCount() > 100) {
                results.add(ImplyConstraintViolation.error("queryInstanceCount", "[queryInstanceCount] must be between 1 and 100", new Object[0]));
            }
            if (this.getDataInstanceTiers() == null || this.getDataInstanceTiers().isEmpty()) {
                results.add(ImplyConstraintViolation.error("dataInstanceTiers", "[dataInstanceTiers] cannot be empty", new Object[0]));
            } else {
                List tierNames = this.getDataInstanceTiers().entrySet().stream().map(x -> ((InstanceTier)x.getValue()).getName()).collect(Collectors.toList());
                if (new HashSet(tierNames).size() != tierNames.size()) {
                    results.add(ImplyConstraintViolation.error("dataInstanceTiers", "Duplicate [name] not allowed in dataInstanceTiers", new Object[0]));
                }
                this.getDataInstanceTiers().forEach((k, v) -> {
                    if (k < 1) {
                        results.add(ImplyConstraintViolation.error("dataInstanceTiers", "[dataInstanceTiers] key must be greater than 0", new Object[0]));
                    }
                    if (v.getInstanceType() == null || !supportedDataInstanceTypes.contains(v.getInstanceType())) {
                        results.add(ImplyConstraintViolation.error(String.format("dataInstanceTiers.%d", k), "[dataInstanceType] must be one of %s", supportedDataInstanceTypes));
                    }
                    if (v.getInstanceCount() == null || v.getInstanceCount() < this.getMinimumDataInstanceCount()) {
                        results.add(ImplyConstraintViolation.error(String.format("dataInstanceTiers.%d", k), String.format("[dataInstanceCount] must be greater than or equal to %s", this.getMinimumDataInstanceCount()), new Object[0]));
                    }
                    if (v.getName() == null || v.getName().isEmpty()) {
                        results.add(ImplyConstraintViolation.error(String.format("dataInstanceTiers.%d", k), "[name] cannot be empty in dataInstanceTiers", new Object[0]));
                    }
                    if (v.getPriority() == null) {
                        results.add(ImplyConstraintViolation.error(String.format("dataInstanceTiers.%d", k), "[priority] cannot be empty in dataInstanceTiers", new Object[0]));
                    }
                });
                if (Collections.max(this.getDataInstanceTiers().keySet(), null).intValue() != this.getDataInstanceTiers().size()) {
                    results.add(ImplyConstraintViolation.error("dataInstanceTiers", "The keys for dataInstanceTiers must be the set of integers between 1 and the total number of keys", new Object[0]));
                }
            }
        }
        if (this.metadataStorage == null) {
            results.add(ImplyConstraintViolation.error("metadataStorage", "[metadataStorage] required", new Object[0]));
        } else {
            this.getMetadataStorage().validate(results, toolbox.getRefreshableConstants());
        }
        if (this.deepStorage == null) {
            results.add(ImplyConstraintViolation.error("deepStorage", "[deepStorage] required", new Object[0]));
        } else if (this.implyVersion != null && !DeepStorage.getForImplyVersion(new ImplyVersion(this.implyVersion, toolbox.getRefreshableConstants()), toolbox.getApplicationConfig(), toolbox.getRefreshableConstants()).containsValue(this.deepStorage.getClass())) {
            results.add(ImplyConstraintViolation.error("deepStorage", "[deepStorage.type] is not supported by version [%s]", this.implyVersion));
        } else {
            this.deepStorage.validate(results);
        }
        if (this.userExtensions != null) {
            for (String string : this.userExtensions.values()) {
                if (string == null || string.isEmpty()) continue;
                String string2 = string.toLowerCase();
                if (this.getSupportedCustomSchemes().stream().noneMatch(string2::startsWith)) {
                    results.add(ImplyConstraintViolation.error("userExtensions", "[userExtensions] must begin with %s", this.getSupportedCustomSchemes()));
                } else if (string2.startsWith("s3://") && !Constants.S3_LOCATION_PATTERN_KEY_REQUIRED.matcher(string2).matches()) {
                    results.add(ImplyConstraintViolation.error("userExtensions", "S3 path must match regex: %s", Constants.S3_LOCATION_PATTERN_KEY_REQUIRED));
                }
                if (!Constants.SUPPORTED_TARBALL_EXTENSIONS.stream().noneMatch(string2::endsWith)) continue;
                results.add(ImplyConstraintViolation.error("userExtensions", "Path must reference a tarball with one of the following extensions: %s", Constants.SUPPORTED_TARBALL_EXTENSIONS));
            }
        }
        if (this.customFiles != null) {
            for (UserFile userFile : this.customFiles) {
                String string = userFile.getPath().toLowerCase();
                if (this.getSupportedCustomSchemes().stream().noneMatch(string::startsWith)) {
                    results.add(ImplyConstraintViolation.error("customFiles", "[customFiles] must begin with %s", this.getSupportedCustomSchemes()));
                    continue;
                }
                if (!string.startsWith("s3://") || Constants.S3_LOCATION_PATTERN_KEY_REQUIRED.matcher(string).matches()) continue;
                results.add(ImplyConstraintViolation.error("customFiles", "S3 path must match regex: %s", Constants.S3_LOCATION_PATTERN_KEY_REQUIRED));
            }
        }
        if ((customDruidProperties = this.getCustomDruidProperties()) != null) {
            for (Map.Entry<String, String> entry : customDruidProperties.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                if (ServiceType.PIVOT.getCustomDruidPropertiesKey().equals(entry.getKey())) {
                    try {
                        YAML_MAPPER.readValue(entry.getValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    }
                    catch (IOException e) {
                        results.add(ImplyConstraintViolation.error("customDruidProperties.pivot", "Failed to parse custom Druid properties for [pivot]: Must be valid YAML.", new Object[0]));
                    }
                    continue;
                }
                for (String line : entry.getValue().split("\\r?\\n")) {
                    if (line.isEmpty() || line.trim().startsWith("#") || line.matches("^[^=].*?=[^=].*$")) continue;
                    results.add(ImplyConstraintViolation.error(String.format("customDruidProperties.%s", entry.getKey()), "Failed to parse custom Druid properties for [%s]: must be in Java properties file format.", entry.getKey()));
                    break;
                }
                try {
                    new Properties().load(new ByteArrayInputStream(entry.getValue().getBytes(StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    results.add(ImplyConstraintViolation.error(String.format("customDruidProperties.%s", entry.getKey()), "Failed to parse custom Druid properties for [%s]: %s", entry.getKey(), e.getMessage()));
                }
            }
        }
        if (this.featureFlags != null) {
            List list = FeatureFlag.getForImplyVersionAndPlatform(this.implyVersionFull, toolbox.getApplicationConfig(), account, toolbox.getRefreshableConstants()).stream().map(FeatureFlag::getId).collect(Collectors.toList());
            this.featureFlags.forEach(x -> {
                if (!supportedFeatureFlagIds.contains(x)) {
                    results.add(ImplyConstraintViolation.error("featureFlags", "Feature flag [%s] is not supported for Imply version [%s] and platform [%s], valid: %s", x, this.implyVersion, toolbox.getApplicationConfig().getPlatform().toString(), supportedFeatureFlagIds));
                }
            });
        }
        if ((map = this.getAllTags(account)) != null) {
            if (map.size() > 10) {
                results.add(ImplyConstraintViolation.error("userTags", "[userTags] can have a maximum of 10 entries", new Object[0]));
            }
            map.keySet().forEach(x -> {
                if (x.length() > 128) {
                    results.add(ImplyConstraintViolation.error("userTags", "Keys in [userTags] cannot be longer than 128 characters", new Object[0]));
                }
                if (x.startsWith("aws:")) {
                    results.add(ImplyConstraintViolation.error("userTags", "Keys in [userTags] cannot start with 'aws:'", new Object[0]));
                }
                if (x.toLowerCase().equals("name")) {
                    results.add(ImplyConstraintViolation.error("userTags", "'Name' is a reserved tag and cannot be specified in [userTags]", new Object[0]));
                }
            });
            map.values().forEach(x -> {
                if (x.length() > 256) {
                    results.add(ImplyConstraintViolation.error("userTags", "Values in [userTags] cannot be longer than 256 characters", new Object[0]));
                }
                if (x.startsWith("aws:")) {
                    results.add(ImplyConstraintViolation.error("userTags", "Values in [userTags] cannot start with 'aws:'", new Object[0]));
                }
            });
        }
        if (this.securityConfiguration != null) {
            this.securityConfiguration.validate(results);
        }
        if (this.zooKeeper != null) {
            this.zooKeeper.validate(results);
        }
        if (this.useTls != null && this.useTls.booleanValue() && toolbox.isAWS() && toolbox.getApplicationConfig().isDevelopmentMode()) {
            results.add(ImplyConstraintViolation.error("useTls", "TLS cannot be used if application.platform=aws and application.dev.mode=true (since dev mode pushes configs to S3 instead of using the config server, and TLS certificates cannot be generated without knowing the IPs and hostnames of the EC2 instances)", new Object[0]));
        }
        if (this.pivot != null) {
            if (this.getImplyVersionFull() != null && !Pivot.getForImplyVersion(this.getImplyVersionFull(), toolbox.getApplicationConfig()).containsValue((Object)this.pivot.getType())) {
                results.add(ImplyConstraintViolation.error("pivot", "[pivot.type] is not supported by version [%s]", this.getImplyVersionFull().getVersion()));
            } else {
                this.pivot.validate(results);
            }
        }
        if (this.otelCollector != null) {
            this.otelCollector.validate(results);
        }
    }

    protected Set<String> getSupportedCustomSchemes() {
        return ImmutableSet.of((Object)"s3://", (Object)"http://", (Object)"https://");
    }

    public void validateClusterInUpdatableState(Toolbox toolbox) {
    }

    protected Integer getMinimumDataInstanceCount() {
        return 0;
    }

    public Set<String> getAllFetchablePaths(ApplicationConfig config, RefreshableConstants refreshableConstants) {
        HashSet<String> fetchablePaths = new HashSet<String>();
        DruidExtensions druidExtensions = DruidExtensions.getForImplyVersion(this.getImplyVersionFull(), refreshableConstants);
        if (druidExtensions != null && druidExtensions.getBaseExtensionPaths() != null) {
            fetchablePaths.addAll(druidExtensions.getBaseExtensionPaths());
        }
        if (this.getUserExtensions() != null) {
            fetchablePaths.addAll(this.getUserExtensions().values().stream().filter(x -> x != null && !x.isEmpty()).collect(Collectors.toList()));
        }
        if (this.getCustomFiles() != null) {
            fetchablePaths.addAll(this.getCustomFiles().stream().map(UserFile::getPath).collect(Collectors.toList()));
        }
        return fetchablePaths;
    }

    public Map<String, String> getAllTags(Account account) {
        if (account == null || account.getFeatureFlags() == null || !account.getFeatureFlags().contains("_implyInternalAutoTag_")) {
            return this.userTags;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("creator", "Imply Cloud");
        tags.put("contact", StringUtils.defaultString((String)this.createdBy, (String)"UNKNOWN"));
        tags.put("team", account.getName());
        tags.put("application", this.name.replaceAll("[^\\w\\.:/=\\+\\-@ ]", "_"));
        if (this.userTags != null) {
            tags.putAll(this.userTags);
        }
        return tags;
    }

    public Info.Builder getInfoBuilder() {
        return Info.builder();
    }

    public String toString() {
        return new ToStringBuilder(this).append("accountId", this.accountId).append("clusterId", (Object)this.clusterId).append("name", (Object)this.name).append("implyVersion", (Object)this.implyVersion).append("masterInstanceType", (Object)this.getMasterInstanceType()).append("queryInstanceType", (Object)this.getQueryInstanceType()).append("masterInstanceCount", (Object)this.getMasterInstanceCount()).append("queryInstanceCount", (Object)this.getQueryInstanceCount()).append("version", (Object)this.version).append("logRetentionDays", (Object)this.logRetentionDays).append("metadataStorage", (Object)this.metadataStorage).append("customDruidProperties", Cluster.maskSensitiveProperties(this.customDruidProperties)).append("clusterNumber", (Object)this.clusterNumber).append("created", (Object)this.created).append("lastModified", (Object)this.lastModified).append("createdBy", (Object)this.createdBy).append("modifiedBy", (Object)this.modifiedBy).append("comments", (Object)this.comments).append("configServerKey", (Object)this.configServerKey).append("implyVersionFull", (Object)this.implyVersionFull).append("userExtensions", this.userExtensions).append("extensionLoadList", this.extensionLoadList).append("securityConfiguration", (Object)this.securityConfiguration).append("customFiles", this.customFiles).append("deepStorage", (Object)this.deepStorage).append("encryptDataVolumes", (Object)this.encryptDataVolumes).append("dataInstanceTiers", this.getDataInstanceTiers()).append("featureFlags", this.featureFlags).append("userTags", this.userTags).append("zooKeeper", (Object)this.zooKeeper).append("metadata", this.metadata).append("useTls", (Object)this.useTls).append("useAuthentication", (Object)this.useAuthentication).append("deletionProtection", (Object)this.deletionProtection).append("stopProtection", (Object)this.stopProtection).toString();
    }

    public Builder cloner() {
        return Cluster.builder().withCluster(this);
    }

    public Cluster mergeDiff(Cluster other, boolean defaultValues) {
        return this.mergeDiff(Cluster.builder(), other, defaultValues).build();
    }

    public Cluster mergeDiff(Cluster other) {
        return this.mergeDiff(other, false);
    }

    public Cluster filterNonNullFields(Cluster filter) {
        return this.filterNonNullFields(Cluster.builder(), filter).build();
    }

    public Cluster simplifiedForBilling() {
        return this.simplifiedForBilling(Cluster.builder()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Builder mergeDiff(Builder builder, Cluster other, boolean defaultValues) {
        if (other == null) {
            return builder.withCluster(this);
        }
        builder.withAccountId(DiffUtils.nullIf(this.accountId, other.accountId, defaultValues));
        builder.withClusterId(DiffUtils.nullIf(this.clusterId, other.clusterId, defaultValues));
        builder.withName(DiffUtils.nullIf(this.name, other.name, defaultValues));
        builder.withImplyVersion(DiffUtils.nullIf(this.implyVersion, other.implyVersion, defaultValues));
        builder.withMasterInstanceType(DiffUtils.nullIf(this.masterInstanceType, other.masterInstanceType, defaultValues));
        builder.withQueryInstanceType(DiffUtils.nullIf(this.queryInstanceType, other.queryInstanceType, defaultValues));
        builder.withMasterInstanceCount(DiffUtils.nullIf(this.masterInstanceCount, other.masterInstanceCount, defaultValues));
        builder.withQueryInstanceCount(DiffUtils.nullIf(this.queryInstanceCount, other.queryInstanceCount, defaultValues));
        builder.withVersion(DiffUtils.nullIf(this.version, other.version, defaultValues));
        builder.withLogRetentionDays(DiffUtils.nullIf(this.logRetentionDays, other.logRetentionDays, defaultValues));
        builder.withClusterNumber(DiffUtils.nullIf(this.clusterNumber, other.clusterNumber, defaultValues));
        builder.withCreated(DiffUtils.nullIf(this.created, other.created, defaultValues));
        builder.withLastModified(DiffUtils.nullIf(this.lastModified, other.lastModified, defaultValues));
        builder.withCreatedBy(DiffUtils.nullIf(this.createdBy, other.createdBy, defaultValues));
        builder.withModifiedBy(DiffUtils.nullIf(this.modifiedBy, other.modifiedBy, defaultValues));
        builder.withComments(DiffUtils.nullIf(this.comments, other.comments, defaultValues));
        builder.withConfigServerKey(DiffUtils.nullIf(this.configServerKey, other.configServerKey, defaultValues));
        builder.withImplyBundleId(DiffUtils.nullIf(this.implyBundleId, other.implyBundleId, defaultValues));
        builder.withImplyVersionFull(DiffUtils.nullIf(this.implyVersionFull, other.implyVersionFull, defaultValues));
        builder.withEncryptDataVolumes(DiffUtils.nullIf(this.encryptDataVolumes, other.encryptDataVolumes, defaultValues));
        builder.withUseTls(DiffUtils.nullIf(this.useTls, other.useTls, defaultValues));
        builder.withUseAuthentication(DiffUtils.nullIf(this.useAuthentication, other.useAuthentication, defaultValues));
        builder.withUserExtensions(DiffUtils.nullIf(this.userExtensions, other.userExtensions, defaultValues));
        builder.withExtensionLoadList(DiffUtils.nullIf(this.extensionLoadList, other.extensionLoadList, defaultValues));
        builder.withDataInstanceTiers(DiffUtils.nullIf(this.dataInstanceTiers, other.dataInstanceTiers, defaultValues));
        builder.withFeatureFlags(DiffUtils.nullIf(this.featureFlags, other.featureFlags, defaultValues));
        builder.withUserTags(DiffUtils.nullIf(this.userTags, other.userTags, defaultValues));
        builder.withMetadata(DiffUtils.nullIf(this.metadata, other.metadata, defaultValues));
        builder.withMetadataStorage(DiffUtils.nullIf(this.metadataStorage, other.metadataStorage, defaultValues));
        builder.withSecurityConfiguration(DiffUtils.nullIf(this.securityConfiguration, other.securityConfiguration, defaultValues));
        builder.withDeepStorage(DiffUtils.nullIf(this.deepStorage, other.deepStorage, defaultValues));
        builder.withZooKeeper(DiffUtils.nullIf(this.zooKeeper, other.zooKeeper, defaultValues));
        builder.withCustomDruidProperties(Cluster.diffCustomDruidProperties(this.getCustomDruidProperties(), other.customDruidProperties, defaultValues));
        List<UserFile> customFiles = this.customFiles;
        if (customFiles != null) {
            if (customFiles.isEmpty() && other.customFiles == null) {
                customFiles = null;
            } else if (other.customFiles != null && customFiles.size() == other.customFiles.size()) {
                boolean equalsExcludingMetadata = true;
                for (int i = 0; i < customFiles.size(); ++i) {
                    if (customFiles.get(i).withDefaultsForUnset().equalsExcludingMetadata(other.customFiles.get(i).withDefaultsForUnset())) continue;
                    equalsExcludingMetadata = false;
                    break;
                }
                if (equalsExcludingMetadata) {
                    customFiles = null;
                }
            }
        } else if (defaultValues && other.customFiles != null) {
            customFiles = Collections.emptyList();
        }
        builder.withCustomFiles(customFiles);
        builder.withPivot(DiffUtils.nullIf(this.pivot, other.pivot, defaultValues));
        builder.withMapbox(DiffUtils.nullIf(this.mapbox, other.mapbox, defaultValues));
        builder.withDeletionProtection(DiffUtils.nullIf(this.deletionProtection, other.deletionProtection, defaultValues));
        builder.withStopProtection(DiffUtils.nullIf(this.stopProtection, other.stopProtection, defaultValues));
        builder.withOtelCollector(DiffUtils.nullIf(this.otelCollector, other.otelCollector, defaultValues));
        return builder;
    }

    protected DiffBuilder<Cluster> diffBuilder(Cluster other) {
        DiffBuilder builder = new DiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).append("accountId", (Object)this.accountId, (Object)other.accountId).append("clusterId", (Object)this.clusterId, (Object)other.clusterId).append("name", (Object)this.name, (Object)other.name).append("implyVersion", (Object)this.implyVersion, (Object)other.implyVersion).append("masterInstanceType", (Object)this.masterInstanceType, (Object)other.masterInstanceType).append("queryInstanceType", (Object)this.queryInstanceType, (Object)other.queryInstanceType).append("masterInstanceCount", (Object)this.masterInstanceCount, (Object)other.masterInstanceCount).append("queryInstanceCount", (Object)this.queryInstanceCount, (Object)other.queryInstanceCount).append("version", (Object)this.version, (Object)other.version).append("logRetentionDays", (Object)this.logRetentionDays, (Object)other.logRetentionDays).append("metadataStorage", (Object)this.metadataStorage, (Object)other.metadataStorage).append("comments", (Object)this.comments, (Object)other.comments).append("implyVersionFull", (Object)this.implyVersionFull, (Object)other.implyVersionFull).append("userExtensions", (Object)MapUtils.emptyIfNull(this.userExtensions), (Object)MapUtils.emptyIfNull(other.userExtensions)).append("extensionLoadList", (Object)CollectionUtils.emptyIfNull(this.extensionLoadList), (Object)CollectionUtils.emptyIfNull(other.extensionLoadList)).append("securityConfiguration", (Object)this.securityConfiguration, (Object)other.securityConfiguration).append("deepStorage", (Object)this.deepStorage, (Object)other.deepStorage).append("encryptDataVolumes", (Object)this.encryptDataVolumes, (Object)other.encryptDataVolumes).append("dataInstanceTiers", this.dataInstanceTiers, other.dataInstanceTiers).append("featureFlags", (Object)CollectionUtils.emptyIfNull(this.featureFlags), (Object)CollectionUtils.emptyIfNull(other.featureFlags)).append("zookeeper", (Object)this.zooKeeper, (Object)other.zooKeeper).append("userTags", (Object)MapUtils.emptyIfNull(this.userTags), (Object)MapUtils.emptyIfNull(other.userTags)).append("metadata", (Object)MapUtils.emptyIfNull(this.metadata), (Object)MapUtils.emptyIfNull(other.metadata)).append("useTls", (Object)this.useTls, (Object)other.useTls).append("useAuthentication", (Object)this.useAuthentication, (Object)other.useAuthentication).append("pivot", (Object)this.pivot, (Object)other.pivot).append("mapbox", (Object)this.mapbox, (Object)other.mapbox).append("deletionProtection", (Object)this.deletionProtection, (Object)other.deletionProtection).append("stopProtection", (Object)this.stopProtection, (Object)other.stopProtection).append("otelCollector", (Object)this.otelCollector, (Object)other.otelCollector);
        builder = Cluster.diffCustomFiles(this.customFiles, other.customFiles, builder);
        return Cluster.diffCustomDruidProperties(this.customDruidProperties, other.customDruidProperties, builder);
    }

    public DiffResult<Cluster> diff(Cluster other) {
        return this.diffBuilder(other).build();
    }

    protected Builder filterNonNullFields(Builder builder, Cluster filter) {
        if (filter == null) {
            return builder;
        }
        if (filter.accountId != null) {
            builder.withAccountId(this.accountId);
        }
        if (filter.clusterId != null) {
            builder.withClusterId(this.clusterId);
        }
        if (filter.name != null) {
            builder.withName(this.name);
        }
        if (filter.implyVersion != null) {
            builder.withImplyVersion(this.implyVersion);
        }
        if (filter.getMasterInstanceType() != null) {
            builder.withMasterInstanceType(this.getMasterInstanceType());
        }
        if (filter.getQueryInstanceType() != null) {
            builder.withQueryInstanceType(this.getQueryInstanceType());
        }
        if (filter.getMasterInstanceCount() != null) {
            builder.withMasterInstanceCount(this.getMasterInstanceCount());
        }
        if (filter.getQueryInstanceCount() != null) {
            builder.withQueryInstanceCount(this.getQueryInstanceCount());
        }
        if (filter.version != null) {
            builder.withVersion(this.version);
        }
        if (filter.logRetentionDays != null) {
            builder.withLogRetentionDays(this.logRetentionDays);
        }
        if (filter.metadataStorage != null && this.metadataStorage != null) {
            builder.withMetadataStorage(this.metadataStorage.filterNonNullFields(filter.metadataStorage));
        }
        if (filter.customDruidProperties != null && this.customDruidProperties != null) {
            builder.withCustomDruidProperties(this.customDruidProperties.entrySet().stream().filter(x -> filter.customDruidProperties.containsKey(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (filter.clusterNumber != null) {
            builder.withClusterNumber(this.clusterNumber);
        }
        if (filter.created != null) {
            builder.withCreated(this.created);
        }
        if (filter.lastModified != null) {
            builder.withLastModified(this.lastModified);
        }
        if (filter.createdBy != null) {
            builder.withCreatedBy(this.createdBy);
        }
        if (filter.modifiedBy != null) {
            builder.withModifiedBy(this.modifiedBy);
        }
        if (filter.comments != null) {
            builder.withComments(this.comments);
        }
        if (filter.configServerKey != null) {
            builder.withConfigServerKey(this.configServerKey);
        }
        if (filter.implyBundleId != null) {
            builder.withImplyBundleId(this.implyBundleId);
        }
        if (filter.implyVersionFull != null) {
            builder.withImplyVersionFull(this.implyVersionFull);
        }
        if (filter.userExtensions != null) {
            builder.withUserExtensions(this.userExtensions);
        }
        if (filter.extensionLoadList != null) {
            builder.withExtensionLoadList(this.extensionLoadList);
        }
        if (filter.securityConfiguration != null && this.securityConfiguration != null) {
            builder.withSecurityConfiguration(this.securityConfiguration.filterNonNullFields(filter.securityConfiguration));
        }
        if (filter.customFiles != null) {
            builder.withCustomFiles(this.customFiles);
        }
        if (filter.deepStorage != null && this.deepStorage != null) {
            builder.withDeepStorage(this.deepStorage.filterNonNullFields(filter.deepStorage));
        }
        if (filter.encryptDataVolumes != null) {
            builder.withEncryptDataVolumes(this.encryptDataVolumes);
        }
        if (filter.getDataInstanceTiers() != null) {
            builder.withDataInstanceTiers(this.getDataInstanceTiers());
        }
        if (filter.featureFlags != null) {
            builder.withFeatureFlags(this.featureFlags);
        }
        if (filter.userTags != null) {
            builder.withUserTags(this.userTags);
        }
        if (filter.zooKeeper != null) {
            builder.withZooKeeper(this.zooKeeper);
        }
        if (filter.metadata != null) {
            builder.withMetadata(this.metadata);
        }
        if (filter.useTls != null) {
            builder.withUseTls(this.useTls);
        }
        if (filter.useAuthentication != null) {
            builder.withUseAuthentication(this.useAuthentication);
        }
        if (filter.pivot != null && this.pivot != null) {
            builder.withPivot(this.pivot.filterNonNullFields(filter.pivot));
        }
        if (filter.mapbox != null && this.mapbox != null) {
            builder.withMapbox(this.mapbox.filterNonNullFields(filter.mapbox));
        }
        if (filter.deletionProtection != null) {
            builder.withDeletionProtection(this.deletionProtection);
        }
        if (filter.stopProtection != null) {
            builder.withStopProtection(this.stopProtection);
        }
        if (filter.otelCollector != null && this.otelCollector != null) {
            builder.withOtelCollector(this.otelCollector.filterNonNullFields(filter.otelCollector));
        }
        return builder;
    }

    public boolean isEmpty() {
        return !(this.accountId != null || this.name != null || this.implyVersion != null || this.getMasterInstanceType() != null || this.getQueryInstanceType() != null || this.getMasterInstanceCount() != null && this.getMasterInstanceCount() != 0 || this.getQueryInstanceCount() != null && this.getQueryInstanceCount() != 0 || this.logRetentionDays != null || this.metadataStorage != null && !this.metadataStorage.isEmpty() || this.extraDruidProperties != null || this.customDruidProperties != null || this.createdBy != null || this.modifiedBy != null || this.comments != null || this.configServerKey != null || this.implyBundleId != null || this.implyVersionFull != null || this.userExtensions != null || this.extensionLoadList != null || this.securityConfiguration != null || this.customFiles != null || this.deepStorage != null && !this.deepStorage.isEmpty() || this.encryptDataVolumes != null || this.getDataInstanceTiers() != null || this.featureFlags != null || this.userTags != null || this.zooKeeper != null || this.metadata != null || this.useTls != null || this.useAuthentication != null || this.pivot != null && !this.pivot.isEmpty() || this.mapbox != null && !this.mapbox.isEmpty() || this.deletionProtection != null || this.stopProtection != null || this.otelCollector != null && !this.otelCollector.isEmpty());
    }

    protected Builder simplifiedForBilling(Builder builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.withAccountId(this.accountId)).withClusterId(this.clusterId)).withName(this.name)).withImplyVersion(this.implyVersion)).withMasterInstanceType(this.getMasterInstanceType())).withQueryInstanceType(this.getQueryInstanceType())).withMasterInstanceCount(this.getMasterInstanceCount())).withQueryInstanceCount(this.getQueryInstanceCount())).withVersion(this.version)).withCreated(this.created)).withLastModified(this.lastModified)).withCreatedBy(this.createdBy)).withModifiedBy(this.modifiedBy)).withDataInstanceTiers(this.getDataInstanceTiers());
        return builder;
    }

    public ComparableVersion lookupComparableImplyVersion(RefreshableConstants refreshableConstants) {
        return this.implyVersionFull != null && this.implyVersionFull.getComparableVersion() != null ? this.implyVersionFull.getComparableVersion() : refreshableConstants.lookupComparableVersion(this.implyVersion);
    }

    @Deprecated
    public static Map<String, Object> convertCustomDruidPropertiesToExtraDruidProperties(Map<String, String> customDruidProperties) {
        if (customDruidProperties == null) {
            return null;
        }
        return customDruidProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> PropertiesHelper.convertPropertiesFileToMap((String)x.getValue())));
    }

    @Deprecated
    public static Map<String, String> convertExtraDruidPropertiesToCustomDruidProperties(Map<String, Object> extraDruidProperties) {
        if (extraDruidProperties == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : extraDruidProperties.entrySet()) {
            Map nodeProperties = (Map)entry.getValue();
            retVal.put(entry.getKey(), PropertiesHelper.convertMapToPropertiesFileFormat(nodeProperties));
        }
        return retVal;
    }

    public static Map<String, Object> clusterToMapWithoutType(ObjectMapper mapper, Cluster cluster) {
        Map modifiedMap = (Map)mapper.convertValue((Object)cluster, (TypeReference)new TypeReference<Map<String, Object>>(){});
        modifiedMap.remove("type");
        return modifiedMap;
    }

    public static <T> DiffBuilder<T> diffCustomDruidProperties(Map<String, String> newProperties, Map<String, String> originalProperties, DiffBuilder<T> builder) {
        Map<String, Map> originalPropsMap;
        newProperties = MapUtils.emptyIfNull(newProperties);
        originalProperties = MapUtils.emptyIfNull(originalProperties);
        Map<String, Map> newPropsMap = newProperties.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Cluster::customDruidPropertiesToMap));
        if (!Objects.equals(newPropsMap, originalPropsMap = originalProperties.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Cluster::customDruidPropertiesToMap)))) {
            builder.append("customDruidProperties", newPropsMap, originalPropsMap);
        }
        return builder;
    }

    public static <T> DiffBuilder<T> diffCustomFiles(List<UserFile> newFiles, List<UserFile> originalFiles, DiffBuilder<T> builder) {
        if (!Objects.equals(newFiles = ListUtils.emptyIfNull(newFiles).stream().map(UserFile::withDefaultsForUnset).collect(Collectors.toList()), originalFiles = ListUtils.emptyIfNull(originalFiles).stream().map(UserFile::withDefaultsForUnset).collect(Collectors.toList()))) {
            builder.append("customFiles", newFiles, originalFiles);
        }
        return builder;
    }

    private static Map<String, Object> customDruidPropertiesToMap(Map.Entry<String, String> entry) {
        if (ServiceType.PIVOT.getCustomDruidPropertiesKey().equals(entry.getKey())) {
            return YAML.fromYaml(entry.getValue());
        }
        return new HashMap<String, Object>(PropertiesHelper.convertPropertiesFileToMap(entry.getValue()));
    }

    public static Map<String, String> diffCustomDruidProperties(Map<String, String> newProperties, Map<String, String> originalProperties, boolean defaultValues) {
        Map<String, String> customProperties;
        if (Objects.equals(newProperties, originalProperties) || newProperties == null && !defaultValues) {
            customProperties = null;
        } else {
            if (newProperties == null) {
                return Collections.emptyMap();
            }
            if (originalProperties == null) {
                customProperties = newProperties.entrySet().stream().filter(x -> x.getValue() != null && !((String)x.getValue()).trim().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            } else {
                customProperties = newProperties.entrySet().stream().filter(x -> x.getValue() != null && (!originalProperties.containsKey(x.getKey()) && !((String)x.getValue()).trim().isEmpty() || originalProperties.containsKey(x.getKey()) && !((String)x.getValue()).equals(originalProperties.get(x.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (defaultValues) {
                    originalProperties.entrySet().stream().filter(x -> StringUtils.isNotBlank((CharSequence)((CharSequence)x.getValue())) && !newProperties.containsKey(x.getKey())).forEach(x -> customProperties.put((String)x.getKey(), ""));
                }
            }
        }
        return customProperties == null || customProperties.isEmpty() ? null : customProperties;
    }

    public static OtelCollector maskSensitiveProperties(OtelCollector otelCollector) {
        if (otelCollector == null) {
            return null;
        }
        return otelCollector.withSensitiveFieldsMasked();
    }

    public static Map<String, String> maskSensitiveProperties(Map<String, String> properties) {
        if (properties == null) {
            return properties;
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                toReturn.put(entry.getKey(), entry.getValue());
                continue;
            }
            toReturn.put(entry.getKey(), entry.getValue().replaceAll("(?mi)^([^=]*(secret|password)[^=]*=)(.*)$", "$1*****************").replaceAll("(?mi)^([^:]*(secret|password)[^:]*:)(.*)$", "$1*****************"));
        }
        return toReturn;
    }

    public boolean isOnOrAfterVersion(ComparableVersion version) {
        return version != null && version.compareTo(this.getImplyVersionFull().getComparableVersion()) <= 0;
    }

    public static class Builder<Subclass extends Builder, TypeToBuild extends Cluster> {
        protected String accountId;
        protected String clusterId;
        protected String name;
        protected String implyVersion;
        protected String masterInstanceType;
        protected String queryInstanceType;
        protected Integer masterInstanceCount;
        protected Integer queryInstanceCount;
        protected Integer version;
        protected Integer logRetentionDays;
        protected MetadataStorage metadataStorage;
        protected Map<String, String> customDruidProperties;
        protected Integer clusterNumber;
        protected DateTime created;
        protected DateTime lastModified;
        protected String createdBy;
        protected String modifiedBy;
        protected String comments;
        protected String configServerKey;
        protected String implyBundleId;
        protected ImplyVersion implyVersionFull;
        protected Map<String, String> userExtensions;
        protected List<String> extensionLoadList;
        protected SecurityConfiguration securityConfiguration;
        protected List<UserFile> customFiles;
        protected DeepStorage deepStorage;
        protected Boolean encryptDataVolumes;
        protected Map<Integer, InstanceTier> dataInstanceTiers;
        protected List<String> featureFlags;
        protected Map<String, String> userTags;
        protected ZooKeeper zooKeeper;
        protected Map<String, Object> metadata;
        protected Boolean useTls;
        protected Boolean useAuthentication;
        protected Pivot pivot;
        protected Mapbox mapbox;
        protected Boolean deletionProtection;
        protected Boolean stopProtection;
        protected OtelCollector otelCollector;

        protected Builder() {
        }

        protected final Subclass getSubclass() {
            return (Subclass)this;
        }

        public TypeToBuild build() {
            return (TypeToBuild)new Cluster(this.accountId, this.clusterId, this.name, this.implyVersion, this.masterInstanceType, this.queryInstanceType, null, this.masterInstanceCount, this.queryInstanceCount, null, this.version, this.logRetentionDays, this.metadataStorage, null, this.customDruidProperties, this.clusterNumber, this.created, this.lastModified, null, this.createdBy, this.modifiedBy, this.comments, this.configServerKey, this.implyBundleId, this.implyVersionFull, this.userExtensions, this.extensionLoadList, this.securityConfiguration, null, this.customFiles, null, this.deepStorage, this.encryptDataVolumes, this.dataInstanceTiers, this.featureFlags, this.userTags, this.zooKeeper, this.metadata, this.useTls, this.useAuthentication, this.pivot, this.deletionProtection, this.stopProtection, this.mapbox, this.otelCollector);
        }

        public Subclass withCluster(Cluster cluster) {
            return this.withCluster(cluster, false);
        }

        public Subclass withCluster(Cluster cluster, boolean merge) {
            if (cluster == null) {
                return this.getSubclass();
            }
            if (cluster.accountId != null) {
                this.accountId = cluster.accountId;
            }
            if (cluster.clusterId != null) {
                this.clusterId = cluster.clusterId;
            }
            if (cluster.name != null) {
                this.name = cluster.name;
            }
            if (cluster.implyVersion != null) {
                this.implyVersion = cluster.implyVersion;
            }
            if (cluster.getMasterInstanceType() != null) {
                this.masterInstanceType = cluster.getMasterInstanceType();
            }
            if (cluster.getQueryInstanceType() != null) {
                this.queryInstanceType = cluster.getQueryInstanceType();
            }
            if (cluster.getMasterInstanceCount() != null) {
                this.masterInstanceCount = cluster.getMasterInstanceCount();
            }
            if (cluster.getQueryInstanceCount() != null) {
                this.queryInstanceCount = cluster.getQueryInstanceCount();
            }
            if (cluster.version != null) {
                this.version = cluster.version;
            }
            if (cluster.logRetentionDays != null) {
                this.logRetentionDays = cluster.logRetentionDays;
            }
            if (merge) {
                if (this.metadataStorage == null) {
                    this.metadataStorage = cluster.metadataStorage;
                } else if (cluster.metadataStorage != null) {
                    this.metadataStorage = this.metadataStorage.merge(cluster.metadataStorage);
                }
            } else if (cluster.metadataStorage != null) {
                this.metadataStorage = cluster.metadataStorage;
            }
            if (merge) {
                if (this.customDruidProperties == null) {
                    this.customDruidProperties = cluster.customDruidProperties;
                } else if (cluster.customDruidProperties != null) {
                    this.customDruidProperties = new HashMap<String, String>(this.customDruidProperties);
                    this.customDruidProperties.putAll(cluster.customDruidProperties);
                }
            } else if (cluster.customDruidProperties != null) {
                this.customDruidProperties = cluster.customDruidProperties;
            }
            if (this.customDruidProperties != null) {
                this.customDruidProperties = new HashMap<String, String>(this.customDruidProperties);
                this.customDruidProperties.values().removeIf(Objects::isNull);
            }
            if (cluster.clusterNumber != null) {
                this.clusterNumber = cluster.clusterNumber;
            }
            if (cluster.created != null) {
                this.created = cluster.created;
            }
            if (cluster.lastModified != null) {
                this.lastModified = cluster.lastModified;
            }
            if (merge) {
                this.modifiedBy = null;
                this.comments = null;
            }
            if (cluster.createdBy != null) {
                this.createdBy = cluster.createdBy;
            }
            if (cluster.modifiedBy != null) {
                this.modifiedBy = cluster.modifiedBy;
            }
            if (cluster.comments != null) {
                this.comments = cluster.comments;
            }
            if (cluster.configServerKey != null) {
                this.configServerKey = cluster.configServerKey;
            }
            if (cluster.implyBundleId != null) {
                this.implyBundleId = cluster.implyBundleId;
            }
            if (cluster.implyVersionFull != null) {
                this.implyVersionFull = cluster.implyVersionFull;
            }
            if (cluster.userExtensions != null) {
                this.userExtensions = new HashMap<String, String>(cluster.userExtensions);
            }
            if (cluster.extensionLoadList != null) {
                this.extensionLoadList = new ArrayList<String>(cluster.extensionLoadList);
            }
            if (merge) {
                this.securityConfiguration = this.securityConfiguration == null ? cluster.securityConfiguration : ((SecurityConfiguration.Builder)this.securityConfiguration.cloner().withSecurityConfiguration(cluster.securityConfiguration, true)).build();
            } else if (cluster.securityConfiguration != null) {
                this.securityConfiguration = cluster.securityConfiguration;
            }
            if (cluster.customFiles != null) {
                this.customFiles = new ArrayList<UserFile>(cluster.customFiles);
            }
            if (merge) {
                if (this.deepStorage == null) {
                    this.deepStorage = cluster.deepStorage;
                } else if (cluster.deepStorage != null) {
                    this.deepStorage = this.deepStorage.merge(cluster.deepStorage);
                }
            } else if (cluster.deepStorage != null) {
                this.deepStorage = cluster.deepStorage;
            }
            if (cluster.encryptDataVolumes != null) {
                this.encryptDataVolumes = cluster.encryptDataVolumes;
            }
            if (cluster.getDataInstanceTiers() != null) {
                this.dataInstanceTiers = new HashMap<Integer, InstanceTier>(cluster.getDataInstanceTiers());
            }
            if (cluster.featureFlags != null) {
                this.featureFlags = new ArrayList<String>(cluster.featureFlags);
            }
            if (cluster.userTags != null) {
                this.userTags = new HashMap<String, String>(cluster.userTags);
            }
            if (cluster.zooKeeper != null) {
                this.zooKeeper = cluster.zooKeeper;
            }
            if (cluster.metadata != null) {
                this.metadata = new HashMap<String, Object>(cluster.metadata);
            }
            if (cluster.useTls != null) {
                this.useTls = cluster.useTls;
            }
            if (cluster.useAuthentication != null) {
                this.useAuthentication = cluster.useAuthentication;
            }
            if (merge && this.pivot != null) {
                this.pivot = this.pivot.merge(cluster.pivot);
            } else if (cluster.pivot != null) {
                this.pivot = cluster.pivot;
            }
            if (merge && this.mapbox != null) {
                this.mapbox = this.mapbox.merge(cluster.mapbox);
            } else if (cluster.mapbox != null) {
                this.mapbox = cluster.mapbox;
            }
            if (cluster.deletionProtection != null) {
                this.deletionProtection = cluster.deletionProtection;
            }
            if (cluster.stopProtection != null) {
                this.stopProtection = cluster.stopProtection;
            }
            if (merge && this.otelCollector != null) {
                this.otelCollector = this.otelCollector.merge(cluster.otelCollector);
            } else if (cluster.otelCollector != null) {
                this.otelCollector = cluster.otelCollector;
            }
            return this.getSubclass();
        }

        public Subclass withAccountId(String accountId) {
            this.accountId = accountId;
            return this.getSubclass();
        }

        public Subclass withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this.getSubclass();
        }

        public Subclass withName(String name) {
            this.name = name;
            return this.getSubclass();
        }

        public Subclass withImplyVersion(String implyVersion) {
            this.implyVersion = implyVersion;
            return this.getSubclass();
        }

        public Subclass withMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this.getSubclass();
        }

        public Subclass withQueryInstanceType(String queryInstanceType) {
            this.queryInstanceType = queryInstanceType;
            return this.getSubclass();
        }

        public Subclass withMasterInstanceCount(Integer masterInstanceCount) {
            this.masterInstanceCount = masterInstanceCount;
            return this.getSubclass();
        }

        public Subclass withQueryInstanceCount(Integer queryInstanceCount) {
            this.queryInstanceCount = queryInstanceCount;
            return this.getSubclass();
        }

        public Subclass withVersion(Integer version) {
            this.version = version;
            return this.getSubclass();
        }

        public Subclass withLogRetentionDays(Integer logRetentionDays) {
            this.logRetentionDays = logRetentionDays;
            return this.getSubclass();
        }

        public Subclass withMetadataStorage(MetadataStorage metadataStorage) {
            this.metadataStorage = metadataStorage;
            return this.getSubclass();
        }

        public Subclass withCustomDruidProperties(Map<String, String> customDruidProperties) {
            this.customDruidProperties = customDruidProperties != null ? new HashMap(customDruidProperties) : customDruidProperties;
            return this.getSubclass();
        }

        public Subclass withCustomDruidProperty(String customDruidPropertyKey, String customDruidProperties) {
            if (this.customDruidProperties == null) {
                this.customDruidProperties = new HashMap<String, String>();
            }
            this.customDruidProperties.put(customDruidPropertyKey, customDruidProperties);
            return this.getSubclass();
        }

        public Subclass withCustomDruidProperty(ServiceType customDruidPropertyKey, String customDruidProperties) {
            return this.withCustomDruidProperty(customDruidPropertyKey.getName(), customDruidProperties);
        }

        public Subclass withClusterNumber(Integer clusterNumber) {
            this.clusterNumber = clusterNumber;
            return this.getSubclass();
        }

        public Subclass withCreated(DateTime created) {
            this.created = created;
            return this.getSubclass();
        }

        public Subclass withLastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this.getSubclass();
        }

        public Subclass withCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this.getSubclass();
        }

        public Subclass withModifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this.getSubclass();
        }

        public Subclass withComments(String comments) {
            this.comments = comments;
            return this.getSubclass();
        }

        public Subclass withConfigServerKey(String configServerKey) {
            this.configServerKey = configServerKey;
            return this.getSubclass();
        }

        public Subclass withImplyBundleId(String implyBundleId) {
            this.implyBundleId = implyBundleId;
            return this.getSubclass();
        }

        public Subclass withImplyVersionFull(ImplyVersion implyVersionFull) {
            this.implyVersionFull = implyVersionFull;
            return this.getSubclass();
        }

        public Subclass withUserExtensions(Map<String, String> userExtensions) {
            this.userExtensions = userExtensions;
            return this.getSubclass();
        }

        public Subclass withExtensionLoadList(List<String> extensionLoadList) {
            this.extensionLoadList = extensionLoadList != null ? new ArrayList(extensionLoadList) : extensionLoadList;
            return this.getSubclass();
        }

        public Subclass withExtension(String extension) {
            if (this.extensionLoadList == null) {
                this.extensionLoadList = new ArrayList<String>();
            }
            this.extensionLoadList.add(extension);
            return this.getSubclass();
        }

        public Subclass withSecurityConfiguration(SecurityConfiguration securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this.getSubclass();
        }

        public Subclass withCustomFiles(List<UserFile> customFiles) {
            this.customFiles = customFiles != null ? new ArrayList(customFiles) : customFiles;
            return this.getSubclass();
        }

        public Subclass withCustomFile(UserFile userFile) {
            if (this.customFiles == null) {
                this.customFiles = new ArrayList<UserFile>();
            }
            this.customFiles.add(userFile);
            return this.getSubclass();
        }

        public Subclass withDeepStorage(DeepStorage deepStorage) {
            this.deepStorage = deepStorage;
            return this.getSubclass();
        }

        public Subclass withEncryptDataVolumes(Boolean encryptDataVolumes) {
            this.encryptDataVolumes = encryptDataVolumes;
            return this.getSubclass();
        }

        public Subclass withDataInstanceTiers(Map<Integer, InstanceTier> dataInstanceTiers) {
            this.dataInstanceTiers = dataInstanceTiers != null ? new HashMap(dataInstanceTiers) : dataInstanceTiers;
            return this.getSubclass();
        }

        public Subclass withDataInstanceTier(Integer tierNumber, InstanceTier instanceTier) {
            if (this.dataInstanceTiers == null) {
                this.dataInstanceTiers = new HashMap<Integer, InstanceTier>();
            }
            this.dataInstanceTiers.put(tierNumber, instanceTier);
            return this.getSubclass();
        }

        public Subclass withFeatureFlags(List<String> featureFlags) {
            this.featureFlags = featureFlags != null ? new ArrayList(featureFlags) : featureFlags;
            return this.getSubclass();
        }

        public Subclass withFeatureFlag(String featureFlag) {
            if (this.featureFlags == null) {
                this.featureFlags = new ArrayList<String>();
            }
            this.featureFlags.add(featureFlag);
            return this.getSubclass();
        }

        public Subclass withUserTags(Map<String, String> userTags) {
            this.userTags = userTags != null ? new HashMap(userTags) : userTags;
            return this.getSubclass();
        }

        public Subclass withUserTag(String name, String value) {
            if (this.userTags == null) {
                this.userTags = new HashMap<String, String>();
            }
            this.userTags.put(name, value);
            return this.getSubclass();
        }

        public Subclass withZooKeeper(ZooKeeper zooKeeper) {
            this.zooKeeper = zooKeeper;
            return this.getSubclass();
        }

        public Subclass withMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this.getSubclass();
        }

        public Subclass withUseTls(Boolean useTls) {
            this.useTls = useTls;
            return this.getSubclass();
        }

        public Subclass withUseAuthentication(Boolean useAuthentication) {
            this.useAuthentication = useAuthentication;
            return this.getSubclass();
        }

        public Subclass withPivot(Pivot pivot) {
            this.pivot = pivot;
            return this.getSubclass();
        }

        public Subclass withMapbox(Mapbox mapbox) {
            this.mapbox = mapbox;
            return this.getSubclass();
        }

        public Subclass withDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this.getSubclass();
        }

        public Subclass withStopProtection(Boolean stopProtection) {
            this.stopProtection = stopProtection;
            return this.getSubclass();
        }

        public Subclass withOtelCollector(OtelCollector otelCollector) {
            this.otelCollector = otelCollector;
            return this.getSubclass();
        }

        public Subclass withoutNonUpdatableFields() {
            this.clusterNumber = null;
            this.created = null;
            this.lastModified = null;
            this.createdBy = null;
            this.modifiedBy = null;
            this.configServerKey = null;
            this.implyBundleId = null;
            this.securityConfiguration = this.securityConfiguration == null ? null : this.securityConfiguration.withoutNonUpdatableFields();
            return this.getSubclass();
        }

        public Subclass withNonUpdatableFields(Cluster cluster) {
            this.withoutNonUpdatableFields();
            this.clusterNumber = cluster.clusterNumber;
            this.created = cluster.created;
            this.createdBy = cluster.createdBy;
            this.configServerKey = cluster.configServerKey;
            this.securityConfiguration = cluster.securityConfiguration;
            return this.getSubclass();
        }

        public Subclass withDefaultsForUnset(ApplicationConfig applicationConfig, boolean setCreationOnlyDefaults, InstanceTypeHelper instanceTypeHelper) {
            this.metadataStorage = this.metadataStorage != null ? this.metadataStorage.withDefaultsForUnset(setCreationOnlyDefaults, instanceTypeHelper) : null;
            this.deepStorage = this.deepStorage != null ? this.deepStorage.withDefaultsForUnset(setCreationOnlyDefaults) : null;
            ZooKeeper zooKeeper = this.zooKeeper = this.zooKeeper != null ? this.zooKeeper.withDefaultsForUnset() : null;
            if (this.pivot != null) {
                this.pivot = this.pivot.withDefaultsForUnset();
            }
            return this.getSubclass();
        }

        public Subclass withSensitiveFieldsMasked() {
            this.metadataStorage = this.metadataStorage != null ? this.metadataStorage.withSensitiveFieldsMasked() : null;
            this.deepStorage = this.deepStorage != null ? this.deepStorage.withSensitiveFieldsMasked() : null;
            this.otelCollector = this.otelCollector != null ? this.otelCollector.withSensitiveFieldsMasked() : null;
            return this.getSubclass();
        }

        public Subclass withSensitiveFieldPlaceholdersRemoved() {
            this.metadataStorage = this.metadataStorage != null ? this.metadataStorage.withSensitiveFieldPlaceholdersRemoved() : null;
            this.deepStorage = this.deepStorage != null ? this.deepStorage.withSensitiveFieldPlaceholdersRemoved() : null;
            this.otelCollector = this.otelCollector != null ? this.otelCollector.withSensitiveFieldPlaceholdersRemoved() : null;
            return this.getSubclass();
        }

        public Subclass withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
            this.metadataStorage = this.metadataStorage != null ? this.metadataStorage.withSensitiveFieldPlaceholdersReplaced(defaultsConfig) : null;
            this.deepStorage = this.deepStorage != null ? this.deepStorage.withSensitiveFieldPlaceholdersReplaced(defaultsConfig) : null;
            return this.getSubclass();
        }

        public Subclass withInfoOnlyFieldsRemoved() {
            this.name = null;
            this.accountId = null;
            this.metadata = null;
            this.comments = null;
            this.deletionProtection = null;
            this.stopProtection = null;
            this.otelCollector = null;
            return this.getSubclass();
        }
    }
}

