/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Constants;
import io.imply.cloud.model.CloudFormationStatus;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Instance;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.model.RdsUpdateInfo;
import io.imply.cloud.model.ValueAndUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CloudResources {
    private final String key;
    private final Notifications notifications;
    private final Map<String, Object> details;
    private final CloudFormationStatus cloudFormationStatus;
    private final Map<ImplyNodeType, List<Instance>> hosts;
    private final Map<String, String> loadBalancers;
    private final DateTime fetchTime;
    private final DateTime lastModified;
    private final Map<String, ValueAndUrl> urls;
    private final List<String> transientErrors;
    private final List<RdsUpdateInfo> pendingRdsUpdates;

    @JsonCreator
    public CloudResources(@JsonProperty(value="key") String key, @JsonProperty(value="notifications") Notifications notifications, @JsonProperty(value="details") Map<String, Object> details, @JsonProperty(value="cloudFormationStatus") CloudFormationStatus cloudFormationStatus, @JsonProperty(value="hosts") Map<ImplyNodeType, List<Instance>> hosts, @JsonProperty(value="loadBalancers") Map<String, String> loadBalancers, @JsonProperty(value="fetchTime") DateTime fetchTime, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="urls") Map<String, ValueAndUrl> urls, @JsonProperty(value="transientErrors") List<String> transientErrors, @JsonProperty(value="pendingRdsUpdates") List<RdsUpdateInfo> pendingRdsUpdates) {
        this.key = key;
        this.notifications = notifications;
        this.details = details;
        this.cloudFormationStatus = cloudFormationStatus;
        this.hosts = hosts != null ? new HashMap<ImplyNodeType, List<Instance>>(hosts) : null;
        this.loadBalancers = loadBalancers != null ? new HashMap<String, String>(loadBalancers) : null;
        this.fetchTime = fetchTime;
        this.lastModified = lastModified;
        this.urls = urls;
        this.transientErrors = transientErrors;
        this.pendingRdsUpdates = pendingRdsUpdates;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public Notifications getNotifications() {
        return this.notifications;
    }

    @JsonProperty
    public Map<String, Object> getDetails() {
        return this.details;
    }

    @JsonProperty
    public CloudFormationStatus getCloudFormationStatus() {
        return this.cloudFormationStatus;
    }

    @JsonProperty
    public Map<ImplyNodeType, List<Instance>> getHosts() {
        return this.hosts;
    }

    public Map<ImplyNodeType, List<Host>> getSimpleHosts() {
        return this.hosts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new ArrayList((Collection)v.getValue())));
    }

    @JsonProperty
    public Map<String, String> getLoadBalancers() {
        return this.loadBalancers;
    }

    @JsonProperty
    public DateTime getFetchTime() {
        return this.fetchTime;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty
    public Map<String, ValueAndUrl> getUrls() {
        return this.urls;
    }

    @JsonProperty
    public List<String> getTransientErrors() {
        return this.transientErrors;
    }

    @JsonProperty
    public List<RdsUpdateInfo> getPendingRdsUpdates() {
        return this.pendingRdsUpdates;
    }

    public CloudResources merge(CloudResources partialRecord) {
        if (partialRecord == null) {
            return this;
        }
        String key = partialRecord.key != null ? partialRecord.key : this.key;
        Notifications notifications = partialRecord.notifications != null ? partialRecord.notifications : this.notifications;
        Map<String, Object> cloudFormationDetails = partialRecord.details != null ? partialRecord.details : this.details;
        CloudFormationStatus cloudFormationStatus = partialRecord.cloudFormationStatus != null ? partialRecord.cloudFormationStatus : this.cloudFormationStatus;
        Map<ImplyNodeType, List<Instance>> hosts = partialRecord.hosts != null ? partialRecord.hosts : this.hosts;
        Map<String, String> loadBalancers = partialRecord.loadBalancers != null ? partialRecord.loadBalancers : this.loadBalancers;
        DateTime fetchTime = partialRecord.fetchTime != null ? partialRecord.fetchTime : this.fetchTime;
        DateTime lastModified = partialRecord.lastModified != null ? partialRecord.lastModified : this.lastModified;
        Map<String, ValueAndUrl> urls = partialRecord.urls != null ? partialRecord.urls : this.urls;
        List<String> transientErrors = partialRecord.transientErrors != null ? partialRecord.transientErrors : this.transientErrors;
        List<RdsUpdateInfo> pendingRdsUpdates = partialRecord.pendingRdsUpdates != null ? partialRecord.pendingRdsUpdates : this.pendingRdsUpdates;
        return new CloudResources(key, notifications, cloudFormationDetails, cloudFormationStatus, hosts, loadBalancers, fetchTime, lastModified, urls, transientErrors, pendingRdsUpdates);
    }

    public CloudResources removeClearedFields() {
        String key = "".equals(this.key) ? null : this.key;
        CloudFormationStatus cloudFormationStatus = CloudFormationStatus.CLEAR_FIELD.equals((Object)this.cloudFormationStatus) ? null : this.cloudFormationStatus;
        DateTime fetchTime = Constants.CLEAR_FIELD_DATETIME.equals((Object)this.fetchTime) ? null : this.fetchTime;
        DateTime lastModified = Constants.CLEAR_FIELD_DATETIME.equals((Object)this.lastModified) ? null : this.lastModified;
        return new CloudResources(key, this.notifications, this.details, cloudFormationStatus, this.hosts, this.loadBalancers, fetchTime, lastModified, this.urls, this.transientErrors, this.pendingRdsUpdates);
    }

    public CloudResources stripInternalFields() {
        return new CloudResources(this.key, this.notifications, this.details, this.cloudFormationStatus, this.hosts, this.loadBalancers, this.fetchTime, this.lastModified, this.urls, this.transientErrors, this.pendingRdsUpdates);
    }

    public Map<String, String> getOutputs(Set<String> requiredKeys) {
        return this.getOutputs(requiredKeys, null);
    }

    public Map<String, String> getOutputs(Set<String> requiredKeys, Set<String> optionalKeys) {
        if (this.details == null || this.details.get("outputs") == null) {
            return null;
        }
        Map outputs = (Map)this.details.get("outputs");
        HashMap<String, String> retVal = new HashMap<String, String>();
        HashSet<String> keys = new HashSet<String>();
        if (requiredKeys != null) {
            keys.addAll(requiredKeys);
        }
        if (optionalKeys != null) {
            keys.addAll(optionalKeys);
        }
        for (String key : keys) {
            String value = (String)outputs.get(key);
            if (value != null) {
                retVal.put(key, value);
                continue;
            }
            if (requiredKeys == null || !requiredKeys.contains(key)) continue;
            return null;
        }
        return retVal;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private Notifications notifications;
        private Map<String, Object> cloudFormationDetails;
        private CloudFormationStatus cloudFormationStatus;
        private Map<ImplyNodeType, List<Instance>> hosts;
        private Map<String, String> loadBalancers;
        private DateTime fetchTime;
        private DateTime lastModified;
        private Map<String, ValueAndUrl> urls;
        private List<String> transientErrors;
        private List<RdsUpdateInfo> pendingRdsUpdates;

        private Builder() {
        }

        public Builder withCloudResources(CloudResources cloudResources) {
            if (cloudResources == null) {
                return this;
            }
            if (cloudResources.key != null) {
                this.key = cloudResources.key;
            }
            if (cloudResources.notifications != null) {
                this.notifications = cloudResources.notifications;
            }
            if (cloudResources.details != null) {
                this.cloudFormationDetails = cloudResources.details;
            }
            if (cloudResources.cloudFormationStatus != null) {
                this.cloudFormationStatus = cloudResources.cloudFormationStatus;
            }
            if (cloudResources.hosts != null) {
                this.hosts = cloudResources.hosts;
            }
            if (cloudResources.loadBalancers != null) {
                this.loadBalancers = cloudResources.loadBalancers;
            }
            if (cloudResources.fetchTime != null) {
                this.fetchTime = cloudResources.fetchTime;
            }
            if (cloudResources.lastModified != null) {
                this.lastModified = cloudResources.lastModified;
            }
            if (cloudResources.urls != null) {
                this.urls = cloudResources.urls;
            }
            if (cloudResources.transientErrors != null) {
                this.transientErrors = cloudResources.transientErrors;
            }
            if (cloudResources.pendingRdsUpdates != null) {
                this.pendingRdsUpdates = cloudResources.pendingRdsUpdates;
            }
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withNotifications(Notifications newNotifications, boolean merge) {
            this.notifications = this.notifications != null && merge ? this.notifications.merge(newNotifications) : newNotifications;
            return this;
        }

        public Builder withNotification(Notification notification) {
            if (this.notifications != null) {
                this.notifications.addNotification(notification);
            } else {
                this.notifications = new Notifications().addNotification(notification);
            }
            return this;
        }

        public Builder withCloudFormationDetails(Map<String, Object> cloudFormationDetails) {
            this.cloudFormationDetails = cloudFormationDetails;
            return this;
        }

        public Builder withCloudFormationStatus(CloudFormationStatus cloudFormationStatus) {
            this.cloudFormationStatus = cloudFormationStatus;
            return this;
        }

        public Builder withHosts(Map<ImplyNodeType, List<Instance>> hosts) {
            this.hosts = hosts != null ? new HashMap(hosts) : hosts;
            return this;
        }

        public Builder withHost(ImplyNodeType nodeType, Instance instance) {
            if (this.hosts == null) {
                this.hosts = new HashMap<ImplyNodeType, List<Instance>>();
            }
            if (!this.hosts.containsKey(nodeType)) {
                this.hosts.put(nodeType, new ArrayList());
            }
            this.hosts.get(nodeType).add(instance);
            return this;
        }

        public Builder withLoadBalancers(Map<String, String> loadBalancers) {
            this.loadBalancers = loadBalancers != null ? new HashMap(loadBalancers) : loadBalancers;
            return this;
        }

        public Builder withLoadBalancer(String access, String url) {
            if (this.loadBalancers == null) {
                this.loadBalancers = new HashMap<String, String>();
            }
            this.loadBalancers.put(access, url);
            return this;
        }

        public Builder withFetchTime(DateTime fetchTime) {
            this.fetchTime = fetchTime;
            return this;
        }

        public Builder withLastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder withUrls(Map<String, ValueAndUrl> urls) {
            this.urls = urls;
            return this;
        }

        public Builder withTransientError(Exception e) {
            if (this.transientErrors == null) {
                this.transientErrors = new ArrayList<String>();
            }
            this.transientErrors.add(e.getMessage());
            return this;
        }

        public Builder withPendingRdsUpdates(List<RdsUpdateInfo> pendingRdsUpdates) {
            this.pendingRdsUpdates = pendingRdsUpdates;
            return this;
        }

        public CloudResources build() {
            return new CloudResources(this.key, this.notifications, this.cloudFormationDetails, this.cloudFormationStatus, this.hosts, this.loadBalancers, this.fetchTime, this.lastModified, this.urls, this.transientErrors, this.pendingRdsUpdates);
        }
    }
}

