/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.imply.cloud.jackson.CIDRSerializer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;

@JsonSerialize(using=CIDRSerializer.class)
public class CIDR
implements Comparable<CIDR> {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private final SubnetUtils.SubnetInfo value;

    public CIDR(String cidrNotation) {
        SubnetUtils subnet = new SubnetUtils(cidrNotation);
        subnet.setInclusiveHostCount(true);
        this.value = subnet.getInfo();
    }

    public CIDR(int firstOctet, int secondOctet, int thirdOctet, int fourthOctet, int subnetMaskAsInteger) {
        this(String.format("%d.%d.%d.%d/%d", firstOctet, secondOctet, thirdOctet, fourthOctet, subnetMaskAsInteger));
    }

    @Override
    public int compareTo(CIDR o) {
        if (o == null) {
            throw new NullPointerException("Cannot compare to null.");
        }
        int[] myOctets = this.getAddressOctets(this.value.getNetworkAddress());
        int[] yourOctets = this.getAddressOctets(o.value.getNetworkAddress());
        for (int i = 0; i < 4; ++i) {
            if (myOctets[i] == yourOctets[i]) continue;
            return myOctets[i] > yourOctets[i] ? 1 : -1;
        }
        if (this.getSubnetMaskAsInteger() == o.getSubnetMaskAsInteger()) {
            return 0;
        }
        return this.getSubnetMaskAsInteger() < o.getSubnetMaskAsInteger() ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIDR cidr = (CIDR)o;
        return this.value != null ? this.value.getCidrSignature().equals(cidr.value.getCidrSignature()) : cidr.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.getCidrSignature().hashCode() : 0;
    }

    public String toString() {
        return this.value.getCidrSignature();
    }

    public CIDR getNextBlock(int suffix) {
        if (suffix < 0 || suffix > 32) {
            throw new IllegalArgumentException("Invalid suffix, must be 0 <= x <= 32.");
        }
        long[] octets = Arrays.stream(this.getAddressOctets(this.value.getHighAddress())).asLongStream().toArray();
        octets[3] = octets[3] + (1L << 32 - suffix);
        octets[2] = octets[2] + octets[3] / 256L;
        octets[3] = octets[3] % 256L;
        octets[1] = octets[1] + octets[2] / 256L;
        octets[2] = octets[2] % 256L;
        octets[0] = octets[0] + octets[1] / 256L;
        octets[1] = octets[1] % 256L;
        if (octets[0] > 255L) {
            throw new IllegalStateException("Maximum address reached (255.255.255.255).");
        }
        return new CIDR(String.format("%s/%d", new CIDR((String)String.format((String)"%d.%d.%d.%d/%s", (Object[])new Object[]{Long.valueOf((long)octets[0]), Long.valueOf((long)octets[1]), Long.valueOf((long)octets[2]), Long.valueOf((long)octets[3]), Integer.valueOf((int)suffix)})).value.getNetworkAddress(), suffix));
    }

    public boolean overlaps(CIDR o) {
        return this.value.isInRange(o.value.getNetworkAddress()) || o.value.isInRange(this.value.getNetworkAddress());
    }

    public int getSubnetMaskAsInteger() {
        return this.value == null ? -1 : this.pop(this.toInteger(this.value.getNetmask()));
    }

    public String getAddress() {
        return this.value.getAddress();
    }

    public String getNetworkAddress() {
        return this.value.getNetworkAddress();
    }

    public int[] getAddressOctets() {
        return this.getAddressOctets(this.value.getAddress());
    }

    public String getDefaultGateway() {
        int[] octets = this.getAddressOctets(this.value.getNetworkAddress());
        return String.format("%d.%d.%d.%d", octets[0], octets[1], octets[2], Math.min(octets[3] + 1, 255));
    }

    private int[] getAddressOctets(String address) {
        String[] fragments = address.split("\\.");
        return new int[]{Integer.parseInt(fragments[0]), Integer.parseInt(fragments[1]), Integer.parseInt(fragments[2]), Integer.parseInt(fragments[3])};
    }

    private int toInteger(String address) {
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + address + "]");
    }

    private int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = this.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    private int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    private int pop(int x) {
        x -= x >>> 1 & 0x55555555;
        x = (x & 0x33333333) + (x >>> 2 & 0x33333333);
        x = x + (x >>> 4) & 0xF0F0F0F;
        x += x >>> 8;
        x += x >>> 16;
        return x & 0x3F;
    }
}

