/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.model.BillingState;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.util.ToStringBuilder;
import org.joda.time.DateTime;

public class BillingEntry {
    private final String principalId;
    private final String accountId;
    private final String requestId;
    private final BillingState state;
    private final Cluster cluster;
    private final DateTime timestamp;

    @JsonCreator
    private BillingEntry(@JsonProperty(value="principalId") String principalId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="requestId") String requestId, @JsonProperty(value="state") BillingState state, @JsonProperty(value="cluster") Cluster cluster, @JsonProperty(value="timestamp") DateTime timestamp) {
        this.principalId = principalId;
        this.accountId = accountId;
        this.requestId = requestId;
        this.state = state;
        this.cluster = cluster;
        this.timestamp = timestamp;
    }

    @JsonProperty
    public String getPrincipalId() {
        return this.principalId;
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty
    public BillingState getState() {
        return this.state;
    }

    @JsonProperty
    public Cluster getCluster() {
        return this.cluster;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public BillingEntry validate() {
        Preconditions.checkArgument((this.principalId != null && !this.principalId.isEmpty() ? 1 : 0) != 0, (Object)"[principalId] cannot be empty");
        Preconditions.checkArgument((this.accountId != null && !this.accountId.isEmpty() ? 1 : 0) != 0, (Object)"[accountId] cannot be empty");
        Preconditions.checkArgument((this.requestId != null && !this.requestId.isEmpty() ? 1 : 0) != 0, (Object)"[requestId] cannot be empty");
        Preconditions.checkArgument((this.state != null ? 1 : 0) != 0, (Object)"[state] cannot be null");
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] cannot be null");
        Preconditions.checkArgument((this.cluster.getClusterId() != null ? 1 : 0) != 0, (Object)"[cluster.clusterId] cannot be null");
        Preconditions.checkArgument((this.cluster.getDataInstanceTiers() != null && !this.cluster.getDataInstanceTiers().isEmpty() ? 1 : 0) != 0, (Object)"[cluster.dataInstanceTiers] cannot be null or empty");
        Preconditions.checkArgument((this.cluster.getMasterInstanceCount() != null ? 1 : 0) != 0, (Object)"[cluster.masterInstanceCount] cannot be null");
        Preconditions.checkArgument((this.cluster.getMasterInstanceType() != null ? 1 : 0) != 0, (Object)"[cluster.masterInstanceType] cannot be null");
        Preconditions.checkArgument((this.cluster.getQueryInstanceCount() != null ? 1 : 0) != 0, (Object)"[cluster.queryInstanceCount] cannot be null");
        Preconditions.checkArgument((this.cluster.getQueryInstanceType() != null ? 1 : 0) != 0, (Object)"[cluster.queryInstanceType] cannot be null");
        Preconditions.checkArgument((this.timestamp != null ? 1 : 0) != 0, (Object)"[timestamp] cannot be null");
        return this;
    }

    public String toString() {
        return new ToStringBuilder(this).append("principalId", this.principalId).append("accountId", (Object)this.accountId).append("requestId", (Object)this.requestId).append("state", (Object)this.state).append("cluster", (Object)this.cluster).append("timestamp", (Object)this.timestamp).toString();
    }

    public static BillingEntry of(String principalId, String accountId, String requestId, BillingState state, Cluster cluster) {
        return BillingEntry.of(principalId, accountId, requestId, state, cluster, DateTime.now());
    }

    public static BillingEntry of(String principalId, String accountId, String requestId, BillingState state, Cluster cluster, DateTime timestamp) {
        return new BillingEntry(principalId, accountId, requestId, state, cluster != null ? cluster.simplifiedForBilling() : null, timestamp);
    }
}

