/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import io.imply.cloud.Constants;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.LicenseEntitlement;
import io.imply.cloud.model.Region;
import io.imply.cloud.util.StringUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Account {
    protected final String accountId;
    protected final String name;
    protected final Integer version;
    protected final Region region;
    protected final Integer icuLimit;
    protected final Integer clusterLimit;
    protected final DateTime created;
    protected final DateTime lastModified;
    protected final String clarityUser;
    protected final String clarityPassword;
    protected final Boolean trial;
    protected final String domain;
    protected final List<String> featureFlags;
    protected final String groveServer;
    protected final String licenseKey;
    protected final List<String> licenseEntitlements;

    public Account() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @JsonCreator
    public Account(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="name") String name, @JsonProperty(value="version") Integer version, @JsonProperty(value="region") Region region, @JsonProperty(value="icuLimit") Integer icuLimit, @JsonProperty(value="clusterLimit") Integer clusterLimit, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="clarityUser") String clarityUser, @JsonProperty(value="clarityPassword") String clarityPassword, @JsonProperty(value="trial") Boolean trial, @JsonProperty(value="domain") String domain, @JsonProperty(value="featureFlags") List<String> featureFlags, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="licenseKey") String licenseKey, @JsonProperty(value="licenseEntitlements") List<String> licenseEntitlements) {
        this.accountId = accountId;
        this.name = name;
        this.version = version;
        this.region = region;
        this.icuLimit = icuLimit;
        this.clusterLimit = clusterLimit;
        this.created = created;
        this.lastModified = lastModified;
        this.clarityUser = clarityUser;
        this.clarityPassword = clarityPassword;
        this.trial = trial;
        this.domain = domain;
        this.featureFlags = featureFlags;
        this.groveServer = groveServer;
        this.licenseKey = licenseKey;
        this.licenseEntitlements = licenseEntitlements;
    }

    public String key() {
        return this.accountId;
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty
    public Region getRegion() {
        return this.region;
    }

    @JsonProperty
    public Integer getIcuLimit() {
        return this.icuLimit;
    }

    @JsonProperty
    public Integer getClusterLimit() {
        return this.clusterLimit;
    }

    @JsonProperty
    public DateTime getCreated() {
        return this.created;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty
    public String getClarityUser() {
        return this.clarityUser;
    }

    @JsonProperty
    public String getClarityPassword() {
        return this.clarityPassword;
    }

    @JsonProperty
    public boolean isTrial() {
        return BooleanUtils.isNotFalse((Boolean)this.trial);
    }

    @JsonProperty
    public String getDomain() {
        return this.domain != null ? this.domain : StringUtils.sanitizeDomainName(this.name);
    }

    @JsonProperty
    public List<String> getFeatureFlags() {
        return this.featureFlags;
    }

    @JsonProperty
    public String getGroveServer() {
        return this.groveServer;
    }

    @JsonProperty
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @JsonProperty
    public List<String> getLicenseEntitlements() {
        return this.licenseEntitlements;
    }

    public boolean isProcessorHoursEnabled() {
        return false;
    }

    public boolean isValueExceedingIcuLimit(int proposedTotalMICU) {
        return !this.isProcessorHoursEnabled() && this.getIcuLimit() != null && proposedTotalMICU > this.getIcuLimit() * 1000;
    }

    public void validate(boolean skipAccountId, boolean allowDuplicateRole, List<Account> otherAccounts, RefreshableConstants refreshableConstants) {
        if (!skipAccountId) {
            Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        }
        Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"[name] cannot be empty");
        Preconditions.checkArgument((this.region != null ? 1 : 0) != 0, (Object)"[region] required");
        Preconditions.checkArgument((this.domain == null || Constants.DOMAIN_PATTERN.matcher(this.domain).matches() ? 1 : 0) != 0, (String)"[domain] must match regex: %s", (Object)Constants.DOMAIN_PATTERN.toString());
        Preconditions.checkArgument((this.featureFlags == null || this.featureFlags.size() == new HashSet<String>(this.featureFlags).size() ? 1 : 0) != 0, (Object)"[featureFlags] cannot contain duplicate entries");
        if (this.licenseEntitlements != null && !this.licenseEntitlements.isEmpty()) {
            Preconditions.checkArgument((LicenseEntitlement.hasInvalidLicenseEntitlements(this.licenseEntitlements, refreshableConstants) == false ? 1 : 0) != 0, (String)"[licenseEntitlements] can only have values %s", LicenseEntitlement.getAllLicenseEntitlements(refreshableConstants));
        }
    }

    public Info.Builder getInfoBuilder() {
        return Info.builder();
    }

    public String toString() {
        return new ToStringBuilder(this).append("accountId", this.accountId).append("name", (Object)this.name).append("version", (Object)this.version).append("region", (Object)this.region).append("icuLimit", (Object)this.icuLimit).append("clusterLimit", (Object)this.clusterLimit).append("created", (Object)this.created).append("lastModified", (Object)this.lastModified).append("clarityUser", (Object)this.clarityUser).append("clarityPassword", (Object)"*****************").append("trial", (Object)this.trial).append("domain", (Object)this.domain).append("featureFlags", this.featureFlags).append("groveServer", (Object)this.groveServer).append("licenseKey", (Object)"*****************").append("licenseEntitlements", this.licenseEntitlements).toString();
    }

    public Builder cloner() {
        return Account.builder().withAccount(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<Subclass extends Builder, TypeToBuild extends Account> {
        protected String accountId;
        protected String name;
        protected Integer version;
        protected Region region;
        protected Integer icuLimit;
        protected Integer clusterLimit;
        protected DateTime created;
        protected DateTime lastModified;
        protected String clarityUser;
        protected String clarityPassword;
        protected Boolean trial;
        protected String domain;
        protected List<String> featureFlags;
        protected String groveServer;
        protected String licenseKey;
        protected List<String> licenseEntitlements;

        protected Builder() {
        }

        protected final Subclass getSubclass() {
            return (Subclass)this;
        }

        public TypeToBuild build() {
            return (TypeToBuild)new Account(this.accountId, this.name, this.version, this.region, this.icuLimit, this.clusterLimit, this.created, this.lastModified, this.clarityUser, this.clarityPassword, this.trial, this.domain, this.featureFlags, this.groveServer, this.licenseKey, this.licenseEntitlements);
        }

        public Subclass withAccount(Account account) {
            return this.withAccount(account, false);
        }

        public Subclass withAccount(Account account, boolean merge) {
            if (account == null) {
                return this.getSubclass();
            }
            if (account.accountId != null) {
                this.accountId = account.accountId;
            }
            if (account.name != null) {
                this.name = account.name;
            }
            if (account.version != null) {
                this.version = account.version;
            }
            if (account.region != null) {
                this.region = account.region;
            }
            if (account.icuLimit != null) {
                this.icuLimit = account.icuLimit;
            }
            if (account.clusterLimit != null) {
                this.clusterLimit = account.clusterLimit;
            }
            if (account.created != null) {
                this.created = account.created;
            }
            if (account.lastModified != null) {
                this.lastModified = account.lastModified;
            }
            if (account.clarityUser != null) {
                this.clarityUser = account.clarityUser;
            }
            if (account.clarityPassword != null) {
                this.clarityPassword = account.clarityPassword;
            }
            if (account.trial != null) {
                this.trial = account.trial;
            }
            if (account.domain != null) {
                this.domain = account.domain;
            }
            if (account.featureFlags != null) {
                this.featureFlags = account.featureFlags;
            }
            if (account.groveServer != null) {
                this.groveServer = account.groveServer;
            }
            if (account.licenseKey != null) {
                this.licenseKey = account.licenseKey;
            }
            if (account.licenseEntitlements != null) {
                this.licenseEntitlements = account.licenseEntitlements;
            }
            return this.getSubclass();
        }

        public Subclass removeClearedFields() {
            if ("".equals(this.name)) {
                this.name = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.icuLimit)) {
                this.icuLimit = null;
            }
            if (Constants.CLEAR_FIELD_INT.equals(this.clusterLimit)) {
                this.clusterLimit = null;
            }
            if ("".equals(this.clarityUser)) {
                this.clarityUser = null;
            }
            if ("".equals(this.clarityPassword)) {
                this.clarityPassword = null;
            }
            if ("".equals(this.domain)) {
                this.domain = null;
            }
            if ("".equals(this.groveServer)) {
                this.groveServer = null;
            }
            if ("".equals(this.licenseKey)) {
                this.licenseKey = null;
            }
            return this.getSubclass();
        }

        public Subclass withAccountId(String accountId) {
            this.accountId = accountId;
            return this.getSubclass();
        }

        public Subclass withName(String name) {
            this.name = name;
            return this.getSubclass();
        }

        public Subclass withVersion(Integer version) {
            this.version = version;
            return this.getSubclass();
        }

        public Subclass withRegion(Region region) {
            this.region = region;
            return this.getSubclass();
        }

        public Subclass withIcuLimit(Integer icuLimit) {
            this.icuLimit = icuLimit;
            return this.getSubclass();
        }

        public Subclass withClusterLimit(Integer clusterLimit) {
            this.clusterLimit = clusterLimit;
            return this.getSubclass();
        }

        public Subclass withCreated(DateTime created) {
            this.created = created;
            return this.getSubclass();
        }

        public Subclass withLastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this.getSubclass();
        }

        public Subclass withClarityUser(String clarityUser) {
            this.clarityUser = clarityUser;
            return this.getSubclass();
        }

        public Subclass withClarityPassword(String clarityPassword) {
            this.clarityPassword = clarityPassword;
            return this.getSubclass();
        }

        public Subclass withTrial(Boolean trial) {
            this.trial = trial;
            return this.getSubclass();
        }

        public Subclass withDomain(String domain) {
            this.domain = domain;
            return this.getSubclass();
        }

        public Subclass withFeatureFlags(List<String> featureFlags) {
            this.featureFlags = featureFlags;
            return this.getSubclass();
        }

        public Subclass withGroveServer(String groveServer) {
            this.groveServer = groveServer;
            return this.getSubclass();
        }

        public Subclass withLicenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
            return this.getSubclass();
        }

        public Subclass withLicenseEntitlements(List<String> licenseEntitlements) {
            this.licenseEntitlements = licenseEntitlements;
            return this.getSubclass();
        }

        public Subclass withoutNonUpdatableFields() {
            this.created = null;
            this.lastModified = null;
            return this.getSubclass();
        }

        public Subclass withDefaultsForUnset() {
            if (this.icuLimit == null) {
                this.icuLimit = 1000;
            }
            if (this.clusterLimit == null) {
                this.clusterLimit = 20;
            }
            if (this.trial == null) {
                this.trial = true;
            }
            if (this.featureFlags == null) {
                this.featureFlags = Constants.DEFAULT_ACCOUNT_FEATURE_FLAGS;
            }
            return this.getSubclass();
        }

        public Subclass withSensitiveFieldsMasked() {
            if (this.clarityPassword != null) {
                this.clarityPassword = "{secret}";
            }
            if (this.licenseKey != null) {
                this.licenseKey = "{secret}";
            }
            return this.getSubclass();
        }

        public Subclass withSensitiveFieldPlaceholdersRemoved() {
            if ("{secret}".equals(this.clarityPassword)) {
                this.clarityPassword = null;
            }
            if ("{secret}".equals(this.licenseKey)) {
                this.licenseKey = null;
            }
            return this.getSubclass();
        }
    }
}

