/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.format.ISODateTimeFormat;

class JodaStuff {
    JodaStuff() {
    }

    static SimpleModule register(SimpleModule module) {
        module.addKeyDeserializer(DateTime.class, (KeyDeserializer)new DateTimeKeyDeserializer());
        module.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        module.addSerializer(DateTime.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(Interval.class, (JsonDeserializer)new IntervalDeserializer());
        module.addSerializer(Interval.class, (JsonSerializer)ToStringSerializer.instance);
        PeriodDeserializer periodDeserializer = new PeriodDeserializer();
        module.addDeserializer(Period.class, (JsonDeserializer)periodDeserializer);
        module.addSerializer(Period.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(Duration.class, (JsonDeserializer)new DurationDeserializer());
        module.addSerializer(Duration.class, (JsonSerializer)ToStringSerializer.instance);
        return module;
    }

    private static class DateTimeKeyDeserializer
    extends KeyDeserializer {
        private DateTimeKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return new DateTime((Object)key);
        }
    }

    private static class DateTimeDeserializer
    extends StdDeserializer<DateTime> {
        private static final long serialVersionUID = 6211345717189809038L;

        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return new DateTime(jp.getLongValue());
            }
            if (t == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(str);
            }
            return (DateTime)ctxt.handleUnexpectedToken(this.handledType(), jp);
        }
    }

    private static class IntervalDeserializer
    extends StdDeserializer<Interval> {
        private static final long serialVersionUID = 8222884425387207125L;

        public IntervalDeserializer() {
            super(Interval.class);
        }

        public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new Interval((Object)jsonParser.getText());
        }
    }
}

