/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.http;

import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.http.MockHttpClientProvider;
import io.imply.cloud.util.ThreadLocalContext;
import org.eclipse.jetty.client.HttpClient;

public class RealHttpClientProvider
implements HttpClientProvider {
    private final ApplicationConfig applicationConfig;
    private final MockHttpClientProvider mockHttpClientProvider;
    private final HttpClient httpClient;

    @Inject
    public RealHttpClientProvider(ApplicationConfig applicationConfig, MockHttpClientProvider mockHttpClientProvider, HttpClient httpClient) {
        this.applicationConfig = applicationConfig;
        this.mockHttpClientProvider = mockHttpClientProvider;
        this.httpClient = httpClient;
    }

    @Override
    public HttpClient get() {
        if (this.useMockHttpClient()) {
            return this.mockHttpClientProvider.get();
        }
        return this.httpClient;
    }

    @Override
    public HttpClient get(boolean forceRealClient) {
        return forceRealClient ? this.httpClient : this.get();
    }

    private boolean useMockHttpClient() {
        boolean useMock = this.applicationConfig.isUseMocks();
        Boolean systemContextMockKey = (Boolean)ThreadLocalContext.getSystemContext("isMock");
        if (systemContextMockKey != null) {
            useMock = systemContextMockKey;
        }
        return useMock;
    }
}

