/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.PolyBind;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.guice.annotations.ManageLifecycleInit;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.util.Logger;
import io.imply.telemetry.ClarityEmitterConfig;
import io.imply.telemetry.Emitter;
import io.imply.telemetry.LoggingEmitter;
import io.imply.telemetry.NoopEmitter;
import io.imply.telemetry.dropwizard.ReporterConfig;
import io.imply.telemetry.dropwizard.TelemetryReporter;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

public class TelemetryModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "imply.telemetry", ClarityEmitterConfig.class);
        JsonConfigProvider.bind(binder, "imply.telemetry.reporter", ReporterConfig.class);
        PolyBind.createChoiceWithDefault(binder, "imply.telemetry.type", Key.get(Emitter.class), "noop");
        PolyBind.optionBinder(binder, Key.get(Emitter.class)).addBinding((Object)"noop").to(NoopEmitter.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(Emitter.class)).addBinding((Object)"clarity").toProvider(ClarityEmitterProvider.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(Emitter.class)).addBinding((Object)"logging").to(LoggingEmitter.class).in(LazySingleton.class);
        LifecycleModule.register(binder, TelemetryLifecycle.class);
    }

    @Provides
    @LazySingleton
    public TelemetryReporter telemetryReporter(Emitter emitter, MetricRegistry registry, ReporterConfig reporterConfig) {
        if (reporterConfig == null || reporterConfig.getMapperConfigs() == null) {
            reporterConfig = ReporterConfig.defaultConfig();
        }
        return TelemetryReporter.builder((Emitter)emitter, (MetricRegistry)registry).reporterConfig(reporterConfig).build();
    }

    @LazySingleton
    private static class ClarityEmitterProvider
    implements Provider<Emitter> {
        private final ClarityEmitterConfig config;
        private final String serviceName;

        @Inject
        public ClarityEmitterProvider(ClarityEmitterConfig config, @Named(value="telemetryServiceName") String serviceName) {
            this.config = config;
            this.serviceName = serviceName;
        }

        public Emitter get() {
            return Emitter.clarityEmitter((ClarityEmitterConfig)this.config, (String)this.serviceName);
        }
    }

    @ManageLifecycleInit
    public static class TelemetryLifecycle {
        @Generated
        private static final Logger log = Logger.from(TelemetryLifecycle.class);
        private final Emitter emitter;
        private final TelemetryReporter reporter;

        @LifecycleStart
        public void start() {
            this.reporter.start(1L, TimeUnit.MINUTES);
        }

        @LifecycleStop
        public void stop() {
            this.reporter.close();
            IOUtils.closeQuietly((Closeable)this.emitter);
            log.info("Telemetry has shutdown");
        }

        @Inject
        @Generated
        public TelemetryLifecycle(Emitter emitter, TelemetryReporter reporter) {
            this.emitter = emitter;
            this.reporter = reporter;
        }
    }
}

