/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import io.imply.cloud.guice.KeyHolder;
import io.imply.cloud.guice.LifecycleScope;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.guice.annotations.ManageLifecycleInit;
import io.imply.cloud.guice.annotations.ManageLifecycleLast;
import io.imply.cloud.lifecycle.Lifecycle;
import java.lang.annotation.Annotation;
import java.util.Set;

public class LifecycleModule
implements Module {
    private final LifecycleScope initScope = new LifecycleScope(Lifecycle.Stage.INIT);
    private final LifecycleScope scope = new LifecycleScope(Lifecycle.Stage.NORMAL);
    private final LifecycleScope lastScope = new LifecycleScope(Lifecycle.Stage.LAST);

    public static void register(Binder binder, Class<?> clazz) {
        LifecycleModule.registerKey(binder, Key.get(clazz));
    }

    public static void register(Binder binder, Class<?> clazz, Annotation annotation) {
        LifecycleModule.registerKey(binder, Key.get(clazz, (Annotation)annotation));
    }

    public static void register(Binder binder, Class<?> clazz, Class<? extends Annotation> annotation) {
        LifecycleModule.registerKey(binder, Key.get(clazz, annotation));
    }

    public static void registerKey(Binder binder, Key<?> key) {
        LifecycleModule.getEagerBinder(binder).addBinding().toInstance(new KeyHolder(key));
    }

    private static Multibinder<KeyHolder> getEagerBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, KeyHolder.class, (Annotation)Names.named((String)"lifecycle"));
    }

    public void configure(Binder binder) {
        LifecycleModule.getEagerBinder(binder);
        binder.bindScope(ManageLifecycleInit.class, (Scope)this.initScope);
        binder.bindScope(ManageLifecycle.class, (Scope)this.scope);
        binder.bindScope(ManageLifecycleLast.class, (Scope)this.lastScope);
    }

    @Provides
    @LazySingleton
    public Lifecycle getLifecycle(final Injector injector) {
        Key keyHolderKey = Key.get((TypeLiteral)new TypeLiteral<Set<KeyHolder>>(){}, (Annotation)Names.named((String)"lifecycle"));
        final Set eagerClasses = (Set)injector.getInstance(keyHolderKey);
        Lifecycle lifecycle = new Lifecycle(){

            @Override
            public void start() throws Exception {
                for (KeyHolder holder : eagerClasses) {
                    injector.getInstance(holder.getKey());
                }
                super.start();
            }
        };
        this.scope.setLifecycle(lifecycle);
        this.lastScope.setLifecycle(lifecycle);
        return lifecycle;
    }
}

