/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceEntry {
    private static final Logger log = new Logger(ServiceEntry.class);
    private static final String RUN_STATE = "run";
    private static final String DOWN_STATE = "down";
    private static final List<String> VALID_STATES = ImmutableList.of((Object)"run", (Object)"down");
    private static final List<String> EXCLUDED_SERVICES = ImmutableList.of((Object)"grove-agent", (Object)"sensu-client", (Object)"grove-server");
    private static final Pattern RUN_STATUS_PATTERN = Pattern.compile("\\(pid ([0-9]*)\\) ([0-9]*)s");
    private static final Pattern DOWN_STATUS_PATTERN = Pattern.compile("([0-9]*)s");
    private final String name;
    private final ServiceState state;
    private final String path;
    private final Integer pid;
    private final Integer timeInSeconds;

    @VisibleForTesting
    public ServiceEntry(String name, ServiceState state, String path, Integer pid, Integer timeInSeconds) {
        this.name = name;
        this.state = state;
        this.path = path;
        this.pid = pid;
        this.timeInSeconds = timeInSeconds;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public ServiceState getState() {
        return this.state;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public Integer getPid() {
        return this.pid;
    }

    @JsonProperty
    public Integer getTimeInSeconds() {
        return this.timeInSeconds;
    }

    public static ServiceEntry from(String value) {
        if (value == null) {
            return null;
        }
        String[] fragments = value.split("[:;,]");
        if (fragments.length < 3 || !VALID_STATES.contains(fragments[0])) {
            return null;
        }
        ServiceState state = ServiceState.valueOf(fragments[0].toUpperCase());
        String path = fragments[1];
        String[] serviceFragments = path.split("/");
        String name = serviceFragments[serviceFragments.length - 1];
        if (EXCLUDED_SERVICES.stream().anyMatch(path::endsWith)) {
            return null;
        }
        if (ServiceState.RUN.equals((Object)state)) {
            Matcher matcher = RUN_STATUS_PATTERN.matcher(fragments[2]);
            if (!matcher.find()) {
                return null;
            }
            Integer pid = null;
            Integer timeInSeconds = null;
            try {
                pid = Integer.parseInt(matcher.group(1));
                timeInSeconds = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                log.error(e, "Exception parsing ints");
            }
            return new ServiceEntry(name, state, path, pid, timeInSeconds);
        }
        if (ServiceState.DOWN.equals((Object)state)) {
            Matcher matcher = DOWN_STATUS_PATTERN.matcher(fragments[2]);
            if (!matcher.find()) {
                return null;
            }
            Integer timeInSeconds = null;
            try {
                timeInSeconds = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                log.error(e, "Exception parsing ints");
            }
            return new ServiceEntry(name, state, path, null, timeInSeconds);
        }
        log.error("Unhandled state [%s]", new Object[]{state});
        return null;
    }

    public static enum ServiceState {
        RUN,
        DOWN;

    }
}

