/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.grove.NodeResources;
import io.imply.cloud.grove.ServiceEntry;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Node {
    private static final Logger log = new Logger(Node.class);
    private final String address;
    private final String hostname;
    private final Boolean online;
    private final DateTime lastHeartbeat;
    private final NodeResources resources;
    private final String deployName;
    private final String deployType;
    private final List<String> deployPackages;
    private final List<ServiceEntry> services;
    private final List<ImplyNodeType> implyNodeTypes;
    private final Map<String, Object> metadata;
    private final String implyBundleId;
    private final String implyVersion;
    private final String activeClusterId;
    private final Integer managerClusterVersion;
    private final String agentVersion;
    private final Boolean available;

    @JsonCreator
    public Node(@JsonProperty(value="address") String address, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="online") Boolean online, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="resources") NodeResources resources, @JsonProperty(value="deployName") String deployName, @JsonProperty(value="deployType") String deployType, @JsonProperty(value="deployPackages") List<String> deployPackages, @JsonProperty(value="services") List<ServiceEntry> services, @JsonProperty(value="implyNodeTypes") List<ImplyNodeType> implyNodeTypes, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="implyBundleId") String implyBundleId, @JsonProperty(value="implyVersion") String implyVersion, @JsonProperty(value="activeClusterId") String activeClusterId, @JsonProperty(value="managerClusterVersion") Integer managerClusterVersion, @JsonProperty(value="available") Boolean available, @JsonProperty(value="agentVersion") String agentVersion) {
        this.address = address;
        this.hostname = hostname;
        this.online = online;
        this.lastHeartbeat = lastHeartbeat;
        this.resources = resources;
        this.deployName = deployName;
        this.deployType = deployType;
        this.deployPackages = deployPackages;
        this.services = services;
        this.implyNodeTypes = implyNodeTypes;
        this.metadata = metadata;
        this.implyBundleId = implyBundleId;
        this.implyVersion = implyVersion;
        this.activeClusterId = activeClusterId;
        this.managerClusterVersion = managerClusterVersion;
        this.available = available;
        this.agentVersion = agentVersion;
    }

    @JsonProperty
    public String getAddress() {
        return this.address;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public boolean isOnline() {
        return BooleanUtils.isTrue((Boolean)this.online);
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    public NodeResources getResources() {
        return this.resources;
    }

    @JsonProperty
    public String getDeployName() {
        return this.deployName;
    }

    @JsonProperty
    public String getDeployType() {
        return this.deployType;
    }

    @JsonProperty
    public List<String> getDeployPackages() {
        return this.deployPackages;
    }

    @JsonProperty
    public List<ServiceEntry> getServices() {
        return this.services;
    }

    @JsonProperty
    public List<ImplyNodeType> getImplyNodeTypes() {
        return this.implyNodeTypes;
    }

    @JsonProperty
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public String getImplyBundleId() {
        return this.implyBundleId;
    }

    @JsonProperty
    public String getImplyVersion() {
        return this.implyVersion;
    }

    @JsonProperty
    public String getActiveClusterId() {
        return this.activeClusterId;
    }

    @JsonProperty
    public Integer getManagerClusterVersion() {
        return this.managerClusterVersion;
    }

    @JsonProperty
    public Boolean isAvailable() {
        return this.available;
    }

    @JsonProperty
    public String getAgentVersion() {
        return this.agentVersion;
    }

    @JsonProperty
    public Boolean isModifiable() {
        return this.getTaggedClusterId() == null || this.getTaggedImplyNodeTypes().isEmpty();
    }

    public boolean isImplyRunning() {
        if (this.services == null || !this.isOnline()) {
            return false;
        }
        ServiceEntry serviceEntry = this.services.stream().filter(x -> "imply".equals(x.getName())).findFirst().orElse(null);
        return serviceEntry != null && ServiceEntry.ServiceState.RUN.equals((Object)serviceEntry.getState());
    }

    public String getTaggedClusterId() {
        if (this.metadata == null || this.metadata.get("clusterId") == null) {
            return null;
        }
        Object metadataObj = this.metadata.get("clusterId");
        if (!(metadataObj instanceof String)) {
            log.warn("Could not read metadata [%s] as String: %s", "clusterId", metadataObj);
            return null;
        }
        return (String)metadataObj;
    }

    public Set<ImplyNodeType> getTaggedImplyNodeTypes() {
        HashSet<ImplyNodeType> nodeTypes = new HashSet<ImplyNodeType>();
        if (this.metadata == null || this.metadata.get("nodeTypes") == null) {
            return nodeTypes;
        }
        Object nodeTypesObj = this.metadata.get("nodeTypes");
        int nodeTier = Optional.ofNullable(this.metadata.get("nodeTier")).map(o -> {
            String tier = (String)o;
            return StringUtils.isNumeric((CharSequence)tier) ? Integer.valueOf(Integer.parseInt(tier)) : null;
        }).orElse(0);
        if (nodeTypesObj instanceof String) {
            ImplyNodeType nodeType = ImplyNodeType.fromServiceTypeAndTier((String)nodeTypesObj, nodeTier);
            if (nodeType != null) {
                nodeTypes.add(ImplyNodeType.DATA.equals(nodeType) ? ImplyNodeType.DATA_TIER_1 : nodeType);
            }
        } else if (nodeTypesObj instanceof Collection) {
            for (Object collectionObj : (Collection)nodeTypesObj) {
                ImplyNodeType nodeType;
                if (!(collectionObj instanceof String) || (nodeType = ImplyNodeType.fromServiceTypeAndTier((String)collectionObj, nodeTier)) == null) continue;
                nodeTypes.add(ImplyNodeType.DATA.equals(nodeType) ? ImplyNodeType.DATA_TIER_1 : nodeType);
            }
        }
        if (nodeTypes.isEmpty()) {
            log.warn("Could not read metadata [%s] as String or Collection: %s", "nodeTypes", nodeTypesObj);
        }
        return nodeTypes;
    }

    public Node withAvailable(Boolean available) {
        return new Node(this.address, this.hostname, this.online, this.lastHeartbeat, this.resources, this.deployName, this.deployType, this.deployPackages, this.services, this.implyNodeTypes, this.metadata, this.implyBundleId, this.implyVersion, this.activeClusterId, this.managerClusterVersion, available, this.agentVersion);
    }
}

