/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Toolbox;
import io.imply.cloud.grove.GroveAgent;
import io.imply.cloud.grove.Node;
import io.imply.cloud.grove.NodeResources;
import io.imply.cloud.grove.ServiceEntry;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.SimpleHost;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class GroveAgentUtil {
    public static List<Node> getNodeListFromGroveAgents(List<GroveAgent> groveAgents) {
        ArrayList<Node> agentResources = new ArrayList<Node>();
        if (groveAgents == null) {
            return agentResources;
        }
        for (GroveAgent agent : groveAgents) {
            if (agent == null) continue;
            String hostname = null;
            String deployName = null;
            String deployType = null;
            Object metadata = ImmutableMap.of();
            List<String> deployPackages = null;
            List<ServiceEntry> services = null;
            List<ImplyNodeType> nodeTypes = null;
            Boolean online = agent.getOnline();
            DateTime lastHeartbeat = agent.getStatusTime();
            NodeResources resources = agent.getResources();
            String implyBundleId = null;
            String implyVersion = null;
            String activeClusterId = null;
            Integer managerClusterVersion = null;
            if (agent.getStatus() != null) {
                hostname = agent.getStatus().getHostname();
                if (agent.getStatus().getDeploy() != null) {
                    deployName = agent.getStatus().getDeploy().getName();
                    deployType = agent.getStatus().getDeploy().getType();
                    if (agent.getStatus().getDeploy().getSpec() != null) {
                        deployPackages = agent.getStatus().getDeploy().getSpec().getDeploy();
                        Map<String, Object> deployMetadata = agent.getStatus().getDeploy().getSpec().getMetadata();
                        if (deployMetadata != null) {
                            implyBundleId = (String)deployMetadata.get("implyBundleId");
                            implyVersion = (String)deployMetadata.get("implyVersion");
                            activeClusterId = (String)deployMetadata.get("clusterId");
                            managerClusterVersion = (Integer)deployMetadata.get("clusterVersion");
                            if (deployMetadata.get("implyNodeTypes") != null) {
                                nodeTypes = ((List)deployMetadata.get("implyNodeTypes")).stream().map(ImplyNodeType::fromString).filter(Objects::nonNull).collect(Collectors.toList());
                            }
                        }
                    }
                }
                if (agent.getStatus().getMetadata() != null) {
                    metadata = agent.getStatus().getMetadata();
                }
                services = agent.getStatus().getServiceInfo();
            }
            if ((nodeTypes == null || nodeTypes.isEmpty()) && deployName != null) {
                nodeTypes = Arrays.stream(deployName.split("/")).map(ImplyNodeType::fromString).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (nodeTypes == null || nodeTypes.isEmpty()) {
                nodeTypes = ImmutableList.of((Object)ImplyNodeType.UNKNOWN);
            }
            agentResources.add(new Node(agent.getHost(), hostname, online, lastHeartbeat, resources, deployName, deployType, deployPackages, services, nodeTypes, (Map<String, Object>)metadata, implyBundleId, implyVersion, activeClusterId, managerClusterVersion, null, agent.getImageVersion()));
        }
        return agentResources;
    }

    public static Map<ImplyNodeType, List<Host>> getHostsByImplyNodeType(List<Node> groveNodes) {
        HashMap<ImplyNodeType, List<Host>> implyNodeTypeMap = new HashMap<ImplyNodeType, List<Host>>();
        if (groveNodes == null) {
            return implyNodeTypeMap;
        }
        for (Node node : groveNodes) {
            if (node.getImplyNodeTypes() == null || node.getAddress() == null) continue;
            for (ImplyNodeType nodeType : node.getImplyNodeTypes()) {
                if (!implyNodeTypeMap.containsKey(nodeType)) {
                    implyNodeTypeMap.put(nodeType, new ArrayList());
                }
                ((List)implyNodeTypeMap.get(nodeType)).add(new SimpleHost(node.getAddress(), node.getHostname()));
            }
        }
        return implyNodeTypeMap;
    }

    public static String getCurlRunStringForConfigFile(String outputPath, String usernameAndPassword, String configServerUrl, Toolbox toolbox) {
        return String.format("curl -sSLf %s %s --create-dirs -o %s --retry 5 -m 15 -XPOST -H'Content-Type:application/json' -d @%s %s://%s", usernameAndPassword != null ? String.format("-u '%s'", usernameAndPassword) : "", toolbox.getApplicationConfig().useTls() ? "${IMPLY_MANAGER_CA_CERT_PATH+--cacert \"$IMPLY_MANAGER_CA_CERT_PATH\"}" : "", outputPath, "/opt/imply/onprem/conf/config-server.json", toolbox.getApplicationConfig().useTls() ? "https" : "http", configServerUrl);
    }

    public static List<Node> augmentNodesWithClusterInfo(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ClusterNodesHelper clusterNodesHelper, List<Node> nodes) {
        if (nodes == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)clusterDataManager);
        Preconditions.checkNotNull((Object)entityStateDataManager);
        HashMap<String, String> usedHosts = new HashMap<String, String>();
        for (Cluster cluster : clusterDataManager.getAll()) {
            Info info = entityStateDataManager.getOrNull(cluster);
            if (info == null || info.getState() == null || info.getState().isStoppedTerminatedOrFailed()) continue;
            usedHosts.putAll(clusterNodesHelper.getSortedHosts(cluster.getClusterId()).stream().collect(Collectors.toMap(k -> k, v -> cluster.getClusterId())));
        }
        return nodes.stream().map(x -> x.withAvailable(!usedHosts.containsKey(x.getAddress()))).collect(Collectors.toList());
    }
}

