/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.grove.ServiceEntry;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GroveAgentStatus {
    private static final Logger log = new Logger(GroveAgentStatus.class);
    private final String hostname;
    private final String hash;
    private final Deploy deploy;
    private final List<String> status;
    private final Map<String, Object> metadata;

    @JsonCreator
    public GroveAgentStatus(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="hash") String hash, @JsonProperty(value="deploy") Deploy deploy, @JsonProperty(value="status") List<String> status, @JsonProperty(value="metadata") Object metadata) {
        this.hostname = hostname;
        this.hash = hash;
        this.deploy = deploy;
        this.status = status;
        if (metadata != null) {
            if (metadata instanceof Map) {
                this.metadata = (Map)metadata;
            } else {
                log.warn("[metadata] from agent [%s] is not a map: %s", hostname, metadata);
                this.metadata = ImmutableMap.of();
            }
        } else {
            this.metadata = ImmutableMap.of();
        }
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public String getHash() {
        return this.hash;
    }

    @JsonProperty
    public Deploy getDeploy() {
        return this.deploy;
    }

    @JsonProperty
    public List<String> getStatus() {
        return this.status;
    }

    @JsonProperty
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public List<ServiceEntry> getServiceInfo() {
        return this.status == null ? null : this.status.stream().map(ServiceEntry::from).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class Deploy {
        private final String name;
        private final DeploySpec spec;
        private final String type;

        @JsonCreator
        public Deploy(@JsonProperty(value="name") String name, @JsonProperty(value="yaml") DeploySpec spec, @JsonProperty(value="type") String type) {
            this.name = name;
            this.spec = spec;
            this.type = type;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public DeploySpec getSpec() {
            return this.spec;
        }

        @JsonProperty
        public String getType() {
            return this.type;
        }
    }

    public static class DeploySpec {
        private final String name;
        private final List<String> deploy;
        private final Map<String, Object> env;
        private final Map<String, Object> services;
        private final List<Object> postDeployCommands;
        private final Map<String, Object> metadata;

        @JsonCreator
        public DeploySpec(@JsonProperty(value="name") String name, @JsonProperty(value="deploy") List<String> deploy, @JsonProperty(value="env") Map<String, Object> env, @JsonProperty(value="services") Map<String, Object> services, @JsonProperty(value="post_deploy_commands") List<Object> postDeployCommands, @JsonProperty(value="metadata") Map<String, Object> metadata) {
            this.name = name;
            this.deploy = deploy;
            this.env = env;
            this.services = services;
            this.postDeployCommands = postDeployCommands;
            this.metadata = metadata;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public List<String> getDeploy() {
            return this.deploy;
        }

        @JsonProperty
        public Map<String, Object> getEnv() {
            return this.env;
        }

        @JsonProperty
        public Map<String, Object> getServices() {
            return this.services;
        }

        @JsonProperty
        public List<Object> getPostDeployCommands() {
            return this.postDeployCommands;
        }

        @JsonProperty
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }
    }
}

