/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator.authenticator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.configurator.authenticator.AuthConfigurator;
import io.imply.cloud.jackson.DefaultObjectMapper;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.security.Authentication;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ClusterAuthConfigurator {
    @Generated
    private static final Logger log = Logger.from(ClusterAuthConfigurator.class);
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private final ImmutableList<AuthConfigurator> authConfigurators;

    @Inject
    public ClusterAuthConfigurator(Set<AuthConfigurator> authConfigurators) {
        this.authConfigurators = ImmutableList.copyOf(authConfigurators);
        this.authConfigurators.stream().forEach(authConfigurator -> log.info("Registered [%s]", authConfigurator));
    }

    public Properties getAuthenticatorProperties(Cluster cluster) throws JsonProcessingException {
        Properties props = new Properties();
        List enabledConfigurators = this.authConfigurators.stream().filter(authConfigurator -> authConfigurator.isEnabled(cluster)).collect(Collectors.toList());
        if (enabledConfigurators.isEmpty()) {
            return props;
        }
        String authenticatorChain = OBJECT_MAPPER.writeValueAsString(enabledConfigurators.stream().map(AuthConfigurator::getAuthenticatorType).collect(Collectors.toList()));
        String authorizerChain = OBJECT_MAPPER.writeValueAsString(enabledConfigurators.stream().map(AuthConfigurator::getAuthorizerType).distinct().collect(Collectors.toList()));
        props.setProperty("druid.auth.authenticatorChain", authenticatorChain);
        props.setProperty("druid.auth.authorizers", authorizerChain);
        for (AuthConfigurator authConfigurator2 : enabledConfigurators) {
            Properties properties = authConfigurator2.getAuthenticatorProperties(cluster);
            if (properties == null) continue;
            props.putAll((Map<?, ?>)authConfigurator2.getAuthenticatorProperties(cluster));
        }
        return props;
    }

    public Properties getEscalatorProperties(Cluster cluster) throws JsonProcessingException {
        for (AuthConfigurator authConfigurator : this.authConfigurators) {
            Optional<Properties> properties;
            if (!authConfigurator.isEnabled(cluster) || !(properties = authConfigurator.getEscalatorProperties(cluster)).isPresent()) continue;
            return properties.get();
        }
        return new Properties();
    }

    public List<String> getExtensions(Cluster cluster) {
        return this.authConfigurators.stream().filter(authConfigurator -> authConfigurator.isEnabled(cluster)).map(authConfigurator -> authConfigurator.getExtension(cluster)).collect(Collectors.toList());
    }

    public Authentication getAuthentication(Cluster cluster) throws JsonProcessingException {
        for (AuthConfigurator authConfigurator : this.authConfigurators) {
            Optional<Authentication> authentication;
            if (!authConfigurator.isEnabled(cluster) || !(authentication = authConfigurator.getAuthentication(cluster)).isPresent()) continue;
            return authentication.get();
        }
        return null;
    }
}

