/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.imply.cloud.Constants;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.configurator.CertificateCache;
import io.imply.cloud.configurator.authenticator.ClusterAuthConfigurator;
import io.imply.cloud.jackson.DefaultObjectMapper;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AdditionalFiles;
import io.imply.cloud.model.Architecture;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.DruidConfiguration;
import io.imply.cloud.model.DruidExtensions;
import io.imply.cloud.model.DruidInstanceTypeConfig;
import io.imply.cloud.model.DruidInstanceTypeConfigItem;
import io.imply.cloud.model.DruidRoleMapping;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.LogviewEntry;
import io.imply.cloud.model.PivotConfiguration;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.Region;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.AzureDeepStorage;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.druid.GCSDeepStorage;
import io.imply.cloud.model.druid.HdfsDeepStorage;
import io.imply.cloud.model.druid.S3DeepStorage;
import io.imply.cloud.model.metadatastorage.MySqlMetadataStorage;
import io.imply.cloud.model.metadatastorage.PostgreSqlMetadataStorage;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.tls.CertAndKeyHolder;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.K8sIngestionUtils;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.MapUtils;
import io.imply.cloud.util.Pair;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ConfiguratorManager {
    protected static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new JodaModule());
    private static final Logger log = new Logger(ConfiguratorManager.class);
    protected final ClusterDataManager clusterDataManager;
    protected final EntityStateDataManager entityStateDataManager;
    protected final ApplicationConfig applicationConfig;
    protected final ConfigServerConfig config;
    private final List<DruidConfigFile> configFiles;
    private final RefreshableConstantsUpdater refreshableConstantsUpdater;
    private final RefreshableConstantsConfig refreshableConstantsConfig;
    private final AccountDataManager accountDataManager;
    private final CertificateCache certificateCache;
    private final SecurityConfig securityConfig;
    private final ClusterAuthConfigurator clusterAuthConfigurator;
    private final RefreshableConstants refreshableConstants;
    private final InstanceTypeHelper instanceTypeHelper;
    private final Object lock = new Object();
    private final ScheduledExecutorService scheduledExec;
    private volatile boolean started = false;
    private static final String JAVA_17_HOME_PATH_FORMAT = "/usr/lib/jvm/zulu17-ca-%s";
    private static final String JAVA_21_HOME_PATH_FORMAT = "/usr/lib/jvm/zulu21-ca-%s";
    private static final String PROFILING_JAR_VERSIONLESS_NAME = "imply-profiling.jar";

    @Inject
    public ConfiguratorManager(RefreshableConstantsUpdater refreshableConstantsUpdater, RefreshableConstantsConfig refreshableConstantsConfig, AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ConfigServerConfig config, CertificateCache certificateCache, SecurityConfig securityConfig, ApplicationConfig applicationConfig, ClusterAuthConfigurator clusterAuthConfigurator, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) throws IOException {
        this.configFiles = this.initializeConfigFiles();
        this.refreshableConstantsUpdater = refreshableConstantsUpdater;
        this.refreshableConstantsConfig = refreshableConstantsConfig;
        this.accountDataManager = accountDataManager;
        this.clusterDataManager = clusterDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.config = config;
        this.certificateCache = certificateCache;
        this.securityConfig = securityConfig;
        this.applicationConfig = applicationConfig;
        this.clusterAuthConfigurator = clusterAuthConfigurator;
        this.refreshableConstants = refreshableConstants;
        this.instanceTypeHelper = instanceTypeHelper;
        this.scheduledExec = Execs.scheduledMultiThreaded(3, "ConfiguratorManager-Scheduled", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.applicationConfig.isManager()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.refreshableConstantsUpdater.seed();
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
            Preconditions.checkState((!this.scheduledExec.isShutdown() ? 1 : 0) != 0, (Object)"already stopped");
            this.scheduledExec.scheduleAtFixedRate(() -> {
                try {
                    this.refreshableConstantsUpdater.refresh(false);
                }
                catch (Exception e) {
                    log.error(e, "Exception thrown in RefreshableConstants scheduler");
                }
            }, this.refreshableConstantsConfig.getPeriod().toStandardDuration().getMillis(), this.refreshableConstantsConfig.getPeriod().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
            log.info("ConfiguratorManager lifecycle start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.scheduledExec.shutdownNow();
            this.started = false;
            log.info("ConfiguratorManager has stopped");
        }
    }

    public StreamingOutput generateDruidConfigBundle(ConfigRequestBody configRequestBody) {
        return this.generateDruidConfigBundle(configRequestBody, this::shouldSkipFile);
    }

    public StreamingOutput generateDruidConfigBundle(ConfigRequestBody configRequestBody, Predicate<DruidConfigFile> filter) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        Account account = this.accountDataManager.getOrNull(cluster.getAccountId());
        return os -> {
            try (ZipOutputStream zos = new ZipOutputStream(os);){
                for (DruidConfigFile configFile : this.getConfigFiles(cluster)) {
                    if (filter.test(configFile)) continue;
                    String fileName = configFile.getFilePath();
                    byte[] contents = this.generateCustomConfigFile(cluster, account, configRequestBody, configFile);
                    if (contents == null || contents.length == 0) continue;
                    zos.putNextEntry(new ZipEntry(fileName));
                    zos.write(contents);
                    zos.closeEntry();
                }
            }
            catch (Exception e) {
                log.error(e, "Exception while generating config bundle");
            }
        };
    }

    protected boolean shouldSkipFile(DruidConfigFile file) {
        return false;
    }

    protected boolean areTlsAndAuthenticationEnabledByDefault() {
        return true;
    }

    public String generateGroveInit(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return this.generateGroveInit(cluster, configRequestBody);
    }

    public String generateGroveInit(Cluster cluster, ConfigRequestBody configRequestBody) {
        if (configRequestBody.getServiceTypes().size() > 1) {
            throw new IAE("Implementation only supports a single service type per instance", new Object[0]);
        }
        String serviceType = configRequestBody.getServiceTypes().get(0).toLowerCase();
        ComparableVersion comparableVersion = cluster.lookupComparableImplyVersion(this.refreshableConstants);
        boolean useSuperviseLegacySvlogd = configRequestBody.getTemplateVersion() != null && (comparableVersion == null || comparableVersion.compareTo(new ComparableVersion("99.99")) <= 0);
        boolean supportsSvlogdFlag = configRequestBody.getTemplateVersion() != null;
        String implyBundleId = cluster.getImplyVersionFull() != null ? cluster.getImplyVersionFull().getBundleId() : cluster.getImplyBundleId();
        boolean isLogviewSupported = cluster.isLogviewSupported();
        Object commonEnvValues = "";
        if (CollectionUtils.containsAny((Collection)CollectionUtils.emptyIfNull(cluster.getFeatureFlags()), (Object[])new String[]{FeatureFlags.USE_JAVA17.toString(), FeatureFlags.USE_JAVA21.toString()})) {
            InstanceType instanceType = this.instanceTypeHelper.lookupInstanceType(ImplyNodeType.fromServiceTypeAndTier(serviceType, configRequestBody.getInstanceTier()), configRequestBody.getInstanceType());
            commonEnvValues = (String)commonEnvValues + String.format("  DRUID_JAVA_HOME: %s%n", String.format(cluster.getFeatureFlags().contains(FeatureFlags.USE_JAVA21.toString()) ? JAVA_21_HOME_PATH_FORMAT : JAVA_17_HOME_PATH_FORMAT, Architecture.ARM64.equals((Object)instanceType.getArchitecture()) ? "arm64" : "amd64"));
        }
        if ("master".equals(serviceType)) {
            String zkHeapSize;
            try {
                InstanceType instanceType = this.instanceTypeHelper.lookupInstanceType(ImplyNodeType.fromServiceTypeAndTier(serviceType, configRequestBody.getInstanceTier()), configRequestBody.getInstanceType());
                zkHeapSize = String.format("%sm", this.instanceTypeHelper.getZookeeperHeapSize(instanceType));
            }
            catch (ISE e) {
                zkHeapSize = "512m";
            }
            return String.format("name: imply-%1$s%ndeploy:%n  - %2$s%n  - zk-3.7.1-fc402757%n%nenv:%n  SERVICE_TYPE: %1$s%n  IMPLY_ZK_JAVAOPTS: '-server -Xms%7$s -Xmx%7$s -XX:+ExitOnOutOfMemoryError -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/mnt/tmp/zk.hprof'%n  IMPLY_ZK_DATADIR: '/zk/data' %n  IMPLY_ZK_CONFDIR: '/zk/conf'%n  IMPLY_ZK_DISTDIR: 'apache-zookeeper-3.7.1-bin'%n  IMPLY_ZK_ENSEMBLE: {TO_BE_REPLACED}%n  IMPLY_ZK_MYID: {TO_BE_REPLACED}%n%6$s%nservices:%n  imply:%n    run: ['--', '%2$s/bin/%3$s', '-c', '/opt/imply/conf/supervise/%1$s.conf', '-d', '/mnt/var', '-t', '40', '%4$s']%n  zk-server:%n    run: ['bin/zk-server']%n%5$s", serviceType, implyBundleId, useSuperviseLegacySvlogd ? "supervise-legacy-svlogd" : "supervise", supportsSvlogdFlag ? "--svlogd" : "", isLogviewSupported ? "  logview:\n    run: ['--', 'logview']" : "", commonEnvValues, zkHeapSize);
        }
        String configFile = String.format("%s.conf", "data".equals(serviceType) && this.useIndexerInsteadOfMiddleManager(cluster) ? "data-indexer" : serviceType);
        return String.format("name: imply-%1$s%ndeploy:%n  - %2$s%n%nenv:%n  SERVICE_TYPE: %1$s%n%7$s%nservices:%n  imply:%n    run: ['--', '%2$s/bin/%3$s', '-c', '/opt/imply/conf/supervise/%5$s', '-d', '/mnt/var', '-t', '40', '%4$s']%n%6$s", serviceType, implyBundleId, useSuperviseLegacySvlogd ? "supervise-legacy-svlogd" : "supervise", supportsSvlogdFlag ? "--svlogd" : "", configFile, isLogviewSupported ? "  logview:\n    run: ['--', 'logview']" : "", commonEnvValues);
    }

    public Set<String> generateExtensionPaths(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return this.generateExtensionPaths(cluster, configRequestBody);
    }

    public Set<String> generateExtensionPaths(Cluster cluster, ConfigRequestBody configRequestBody) {
        HashSet<String> combinedExtensionPaths = new HashSet<String>();
        DruidExtensions druidExtensions = DruidExtensions.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        if (druidExtensions != null) {
            if (druidExtensions.getBaseExtensionPaths() != null) {
                combinedExtensionPaths.addAll(druidExtensions.getBaseExtensionPaths());
            }
            if (cluster.getExtensionLoadList() != null && druidExtensions.getOptionalExtensionPaths() != null) {
                for (String extension : cluster.getExtensionLoadList()) {
                    String maybeExtensionPath = druidExtensions.getOptionalExtensionPaths().get(extension);
                    if (maybeExtensionPath == null) continue;
                    combinedExtensionPaths.add(maybeExtensionPath);
                }
            }
        }
        if (cluster.getUserExtensions() != null) {
            combinedExtensionPaths.addAll(cluster.getUserExtensions().values().stream().filter(x -> x != null && !x.isEmpty()).collect(Collectors.toList()));
        }
        return combinedExtensionPaths;
    }

    @Deprecated
    public String generateUserFilePaths(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return cluster.getUserFiles() == null ? "" : String.join((CharSequence)"\n", cluster.getUserFiles());
    }

    public String generateExtendedUserFilePaths(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        Account account = this.accountDataManager.getOrNull(cluster.getAccountId());
        return this.generateExtendedUserFilePaths(cluster, account, configRequestBody);
    }

    public String generateExtendedUserFilePaths(Cluster cluster, Account account, ConfigRequestBody configRequestBody) {
        ArrayList<UserFile> allFiles = new ArrayList<UserFile>();
        allFiles.addAll(this.generateExtensionPaths(cluster, configRequestBody).stream().map(x -> new UserFile((String)x, false, true, false, false, true, null)).collect(Collectors.toList()));
        allFiles.addAll(this.generateBaseHadoopDependenciesPaths(cluster, configRequestBody).stream().map(x -> new UserFile((String)x, false, true, false, true, false, null)).collect(Collectors.toList()));
        allFiles.addAll(this.maybeGenerateContinuousProfilingAgentJar(cluster, account));
        AdditionalFiles additionalFiles = AdditionalFiles.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        if (additionalFiles != null && additionalFiles.getFiles() != null) {
            allFiles.addAll(additionalFiles.getFiles());
        }
        if (cluster.getCustomFiles() != null) {
            allFiles.addAll(cluster.getCustomFiles());
        }
        StringBuilder userFilePaths = new StringBuilder();
        for (UserFile userFile : this.rewritePaths(cluster, allFiles, cluster.getAccountId(), cluster.isUseTls(), configRequestBody.getInstanceType())) {
            if (userFile.getPath().isEmpty()) continue;
            String flags = String.format("[%s%s%s%s%s]", userFile.isClasspath() != null && userFile.isClasspath() != false ? "C" : "", userFile.isUnpack() != null && userFile.isUnpack() != false ? "A" : "", userFile.isExecutable() != null && userFile.isExecutable() != false ? "X" : "", userFile.isHadoopDependency() != null && userFile.isHadoopDependency() != false ? "H" : "", userFile.isDruidExtension() != null && userFile.isDruidExtension() != false ? "E" : "");
            if (!"[]".equals(flags)) {
                userFilePaths.append(flags);
            }
            userFilePaths.append(userFile.getPath());
            userFilePaths.append("\n");
        }
        return userFilePaths.toString();
    }

    protected List<UserFile> rewritePaths(Cluster cluster, List<UserFile> original, String accountId, Boolean isTLSEnabled, String instanceType) {
        return original;
    }

    public List<String> generateBaseHadoopDependenciesPaths(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return this.generateBaseHadoopDependenciesPaths(cluster, configRequestBody);
    }

    public List<String> generateBaseHadoopDependenciesPaths(Cluster cluster, ConfigRequestBody configRequestBody) {
        DruidExtensions druidExtensions = DruidExtensions.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        return druidExtensions != null && druidExtensions.getBaseHadoopDependenciesPaths() != null ? druidExtensions.getBaseHadoopDependenciesPaths() : ImmutableList.of();
    }

    public String generatePreInitScript(String accountId) {
        StringBuilder retVal = new StringBuilder(String.format("#!/bin/bash%n%nsudo -u imply mkdir -p /home/imply/.ssh%n%ncat <<EOT >> /etc/ssh/sshd_config%nTrustedUserCAKeys /etc/ssh/cas.pub%nAuthorizedPrincipalsFile %%h/.ssh/authorized_principals%nMaxAuthTries 10%nEOT%ncat <<EOT >> /etc/ssh/cas.pub%nssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDDqDuCpli86DgGW0TLxkr1scMoSzFnRHmxd+DRSjN2Fqoqs+IOMMDWb5Y4hzkdOaboYPAD/CxhWBR8aPVJIZFW3/BfOr1/RHLurR+9tiOqgu8g5p0F6vTW2+Yt3ybxsXfqoQAr2MzcRa/HNrCY8Q/poheBXx3JeCvAhOXZNImFl7/ahXxrtQqDMHvQvMM3mz/JMS0t2GiUu+8cs6lpNM7L9n+Ccy0csArcexFfbAqfJSiJPVRMgPplAWu2jGP36cUiY75OHYvoUXUUsHNLv09Uvgq8sqZBHGpa6RDOgj5X+5r16fxW8fOnKGhq+yoUwJVKF1fn7FM6ObgjMPnd0P190tQNrK4neHoNZ4EvdHNlkGxwiZYw5DYO275RTvY9aAZu4zDStwldlyJS7JC3xESq9QjSM49OxGFNVRTyw58Qe55Vn6Wc5D0maI0frsN3SPgBczxspTdCagToj5eiUhdrNrQFHJinfCVcvn76nUAuvnYI3zGhGF29tculc5Xi/aE= Imply SSH CA Key 2018-09-07.1%nssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQC9d4Wg7KiofQGrofcqT7IU2AmjmFRI8KcUpfD3hdDUa47kX8N0S7iExkRs07hzcZd9Hblj/vQHeii4wN98cLitoMgXaYaC4cCi0xDCNjrJggnAhjJDJ/TC7D8Da8F1+95UqY6nvB1jS2CXe1JAxK7BY+xjxICdwZIoSTFVa7zdaPZf63Eid4B0K0Qnu1Sr9XSKjqMTcGxRmHuRVypQk3BiOta+AiumjPWgnZurMC6UbzZSeliNXIAfNQ+D1bsCJdQQqGVl4s8/6ygohm69DHAM5Vb6Pt8SXdK/k3XDL2PcnhNhQGAYOti5u0nshRABGqLzNxO00h2jZ3HKzELbd+SAtX9aPoaAUuU7fMr4atADd8ovTZdpK+n8aarwJgy9V7Dqdw6HA3OtrQ9PqBnkBNNO6Yyx5GkLQuEP42LavGqCgejmE0XZw+CXtmoe7rny9uZBd+zABh1xPEaCe86u1HOTOXYfu4FoC2A4At/dOQGvGZc29fwWYXbpuIbXllJ5Y9U= Imply SSH CA Key 2018-09-07.2%nssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDpUmohhx9oUBElTtm7qjTsTsOpbW94iB00osLEei67z6jvMT4cAeJHmYqA6QrNy4X+0PQPEdsmm3gYWtMFLbtYVTE9U3K8LWMBliEp3pYQXNc2rzYPblSb0KHhx0oIs7cplizJgI4tKWcmjbyYj0kJKznNH4V9U0MNI9W7ElzRMZi/kWHdzy3JiycMCZAJPSyl+3kwmhKuT5kFOBD0NDP7Mv5qfmTA85TMrweB9qKy5Q7Gs4QIFvhrfPNUkf3mw2Eq0JXNLdUaMMBslatAOUXUcrSUfXIRUrJv9mvRKkhGGCq2h3LA7vStyaUxUHi0rbvTUd0/FbqjWylfPXI4Uyt5YHpw1xAilHCb8ryr0Zyh+cuWwTrAWtBbC8geDDitdRTFodp4QHQmlJfNtJjng4uz807Hmp1ZUE9rW5x1rZjP1kzvv3iHnCd0gbNMFJJV2aITGp23ZQWeYlIfwNMeOnJudZqARyD6w2XHJ07xycTSaA6fHRzJQeraWiTkHakai90= Imply SSH CA Key 2018-09-07.3%nssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDaeWTFh1/XoIAkGtsxIla6RUZVCbQ7fkKDElBrZFMYV9Uu4EFF2gt1hpnHsyA3WYkvkglD+V9z2WmFMiuo5cqN6RPFns/lRWAh4RKE2UNZRnlAxvqgZnsri7dc+EQ3fGltS3+gArh87RXpQWaTtnS3fe0bOSK3eiwoy/i1PaRcbeDoKGJzIE1G51tycOR/G53ltae/3zUUjZ1Ghv1qp7Mid/gsfQti/AWs/t1YmkGyN+eIGGmXi407LROWRU9I3lpWMuCcOBUr5VCs9x8OX4Rx4udKghwM2tiqN18cxS30324wJTjo85NV1EABgcUEZo4lrwyuVEOJSKGhbjkYd0z0Yq3ZTBptfzKVSim+OSvwdFJinraJdn7lVPyG8CS0pIAtyiErbPPh/awEk/03/wOoE2xm4jOpUQdILcAceovDdXB7Z8BPLLo3C6uR3kwQmSPKX4BsxT4KLqifMyvW5sUFHoi6I4r9Nrf5uuRsEV3Dv/SePH/so/X3gtFVWMcAwqU= Imply SSH CA Key 2018-09-07.4%nssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDVzLVFWQGxa006cYfY/dMWrM3f0BWsiIlJZkyhAwlD2xjcuGImZm41Fr035OY926zS89JcP9PmZ0RGXTzYgh2S2DXYkAWL0O97//buocwlFT3tnReYSXykld5lqFcYp0qpM0H6MXNiLYpW2krJllszcHb0xhgoMNfjwXjVckKTyWLz9Ecy4dvNRSyJlV+qpUkVMvV7AbadlvMmqlHA4Nos6ZVeT6fXmUXeYVUbDjZYQ0AOadBiDXZ8h8/A17yZc6ciCx9ldkIy3vwN0uKb7dxlDYNhN9ym2y1spkMCYlDTGyXA+S4plKF+fa9Luk22tpdbhrx300htnyBGlkEt76qlMTnQhmeIuP17c130o7Jh+4DZBk1rjtve2N8A+uzd0jaTckKjey9oR3sCgM7KM3U8IFmckO61yVpSUVCbhQSuramErDIwZi3LvSHT8yQQ1pa6ZLSlMDPbTLxRU1hN9sYKQjDnKIjv5FwK/7pUW0Ob7gOPckJGdJTlxuZq5GkcnzU= Imply SSH CA Key 2018-09-07.5%nEOT%n%necho \"%s\" > /home/imply/.ssh/authorized_principals%n%n", accountId));
        if (this.config.getRootAccessAccountIds() != null && this.config.getRootAccessAccountIds().contains(accountId)) {
            retVal.append(String.format("echo \"%s\" > /home/ubuntu/.ssh/authorized_principals%n", accountId));
        }
        retVal.append("service sshd reload || service ssh reload\n");
        retVal.append("systemctl stop apt-daily.service apt-daily.timer apt-daily-upgrade.timer\n");
        retVal.append("systemctl disable apt-daily.service apt-daily.timer apt-daily-upgrade.timer\n");
        return retVal.toString();
    }

    public String generateLogviewConfig(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return this.generateLogviewConfig(cluster, configRequestBody);
    }

    public String generateLogviewConfig(Cluster cluster, ConfigRequestBody configRequestBody) {
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        if (cluster.getSecurityConfiguration() != null && cluster.getSecurityConfiguration().getLogviewSecret() != null) {
            config.put("auth_token", cluster.getSecurityConfiguration().getLogviewSecret());
        }
        config.put("log_expiration_seconds", -1);
        ArrayList<LogviewEntry> targets = new ArrayList<LogviewEntry>();
        targets.add(Constants.LOGVIEW_GROVE_BECOME);
        targets.add(Constants.LOGVIEW_CFN_INIT);
        targets.add(Constants.LOGVIEW_IMPLY);
        targets.add(Constants.LOGVIEW_GROVE);
        if (configRequestBody.getServiceTypes() != null) {
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.MASTER.getServiceType())) {
                targets.add(Constants.LOGVIEW_COORDINATOR);
                targets.add(Constants.LOGVIEW_OVERLORD);
                targets.add(Constants.LOGVIEW_ZK);
            }
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.QUERY.getServiceType())) {
                targets.add(Constants.LOGVIEW_BROKER);
                targets.add(Constants.LOGVIEW_ROUTER);
                targets.add(Constants.LOGVIEW_PIVOT);
            }
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.DATA.getServiceType())) {
                targets.add(Constants.LOGVIEW_HISTORICAL);
                targets.add(Constants.LOGVIEW_MM);
                targets.add(Constants.LOGVIEW_INDEXER);
            }
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.INGEST.getServiceType())) {
                targets.add(Constants.LOGVIEW_MM);
                targets.add(Constants.LOGVIEW_INDEXER);
            }
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.COLD_TIER_QUERY.getServiceType())) {
                targets.add(Constants.LOGVIEW_COLD_BROKER);
            }
            if (configRequestBody.getServiceTypes().contains(ImplyNodeType.COLD_TIER_DATA.getServiceType())) {
                targets.add(Constants.LOGVIEW_COLD_HISTORICAL);
            }
        }
        config.put("targets", targets.stream().collect(ImmutableSortedMap.toImmutableSortedMap((k1, k2) -> k1.compareTo((String)k2), LogviewEntry::getKey, x -> x)));
        try {
            return YAML_MAPPER.writeValueAsString(config);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<DruidConfigFile> initializeConfigFiles() throws IOException {
        List<DruidConfigFile> configFiles = Arrays.asList(DruidConfigFile.of("druid/_common/common.runtime.properties", ServiceType.COMMON, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/_common/jets3t.properties", ServiceType.COMMON, DruidConfigFile.FileType.JETSET_PROPERTIES, Platform.AWS), DruidConfigFile.of("druid/_common/log4j2.xml", ServiceType.COMMON, DruidConfigFile.FileType.LOG4J), DruidConfigFile.of("druid/_common/rds-truststore.jks", ServiceType.COMMON, DruidConfigFile.FileType.TRUSTSTORE, Platform.AWS), DruidConfigFile.of("druid/_common/roles.json", ServiceType.COMMON, DruidConfigFile.FileType.ROLE_MAPPING, Platform.SAAS), DruidConfigFile.of("druid/_common/metadata-truststore.jks", ServiceType.COMMON, DruidConfigFile.FileType.TRUSTSTORE, Platform.ONPREM), DruidConfigFile.of("druid/_common/metadata-keystore.jks", ServiceType.COMMON, DruidConfigFile.FileType.KEYSTORE, Platform.ONPREM), DruidConfigFile.of("druid/_common/metadata-store.pem", ServiceType.COMMON, DruidConfigFile.FileType.METADATA_TLS_CERT, Platform.ONPREM), DruidConfigFile.of("druid/_common/metadata-store-client-cert.pem", ServiceType.COMMON, DruidConfigFile.FileType.METADATA_CLIENT_CERT, Platform.ONPREM), DruidConfigFile.of("druid/_common/metadata-store-client-key.pk8", ServiceType.COMMON, DruidConfigFile.FileType.METADATA_CLIENT_KEY, Platform.ONPREM), DruidConfigFile.of("druid/broker/jvm.config", ServiceType.BROKER, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/broker/main.config", ServiceType.BROKER, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/broker/runtime.properties", ServiceType.BROKER, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/router/jvm.config", ServiceType.ROUTER, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/router/main.config", ServiceType.ROUTER, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/router/runtime.properties", ServiceType.ROUTER, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/coordinator/jvm.config", ServiceType.COORDINATOR, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/coordinator/main.config", ServiceType.COORDINATOR, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/coordinator/runtime.properties", ServiceType.COORDINATOR, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/historical/jvm.config", ServiceType.HISTORICAL, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/historical/main.config", ServiceType.HISTORICAL, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/historical/runtime.properties", ServiceType.HISTORICAL, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/middleManager/jvm.config", ServiceType.MIDDLE_MANAGER, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/middleManager/main.config", ServiceType.MIDDLE_MANAGER, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/middleManager/runtime.properties", ServiceType.MIDDLE_MANAGER, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/indexer/jvm.config", ServiceType.INDEXER, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/indexer/main.config", ServiceType.INDEXER, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/indexer/runtime.properties", ServiceType.INDEXER, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/overlord/jvm.config", ServiceType.OVERLORD, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/overlord/main.config", ServiceType.OVERLORD, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/overlord/runtime.properties", ServiceType.OVERLORD, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/coldBroker/jvm.config", ServiceType.COLD_BROKER, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/coldBroker/main.config", ServiceType.COLD_BROKER, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/coldBroker/runtime.properties", ServiceType.COLD_BROKER, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/coldHistorical/jvm.config", ServiceType.COLD_HISTORICAL, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/coldHistorical/main.config", ServiceType.COLD_HISTORICAL, DruidConfigFile.FileType.MAIN_CONFIG), DruidConfigFile.of("druid/coldHistorical/runtime.properties", ServiceType.COLD_HISTORICAL, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("druid/peon/jvm.config", ServiceType.PEON, DruidConfigFile.FileType.JVM_CONFIG), DruidConfigFile.of("druid/peon/runtime.properties", ServiceType.PEON, DruidConfigFile.FileType.RUNTIME_PROPERTIES), DruidConfigFile.of("pivot/config.yaml", ServiceType.PIVOT, DruidConfigFile.FileType.PIVOT_CONFIG), DruidConfigFile.of("pivot/pivot-license", ServiceType.PIVOT, DruidConfigFile.FileType.PIVOT_LICENSE), DruidConfigFile.of("supervise/data.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/data-indexer.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/master.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/query.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/druid.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/coldtierquery.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("supervise/coldtierdata.conf", ServiceType.NONE, DruidConfigFile.FileType.SUPERVISE), DruidConfigFile.of("bin/fetch-additional-files", ServiceType.NONE, DruidConfigFile.FileType.SCRIPT), DruidConfigFile.of("bin/post-init-actions-onprem", ServiceType.NONE, DruidConfigFile.FileType.SCRIPT, Platform.ONPREM), DruidConfigFile.of("bin/post-init-actions-aws", ServiceType.NONE, DruidConfigFile.FileType.SCRIPT, Platform.AWS), DruidConfigFile.of("google/key.json", ServiceType.NONE, DruidConfigFile.FileType.GOOGLE_KEY_JSON, Platform.ONPREM), DruidConfigFile.of("logging/logging-config", ServiceType.NONE, DruidConfigFile.FileType.LOGGING_CONFIG, Platform.ONPREM), DruidConfigFile.of("druid/overlord/base-peon-config.yaml", ServiceType.OVERLORD, DruidConfigFile.FileType.PEON_POD_TEMPLATE, Platform.SAAS));
        for (DruidConfigFile configFile : configFiles) {
            InputStream stream = ClassLoader.getSystemResourceAsStream(configFile.getFilePath());
            try {
                if (stream == null) {
                    configFile.setContents(new byte[0]);
                    log.debug("Created placeholder for file [%s]", configFile.getFilePath());
                    continue;
                }
                configFile.setContents(IOUtils.toByteArray((InputStream)stream));
                if (DruidConfigFile.FileType.RUNTIME_PROPERTIES.equals((Object)configFile.getFileType())) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(configFile.getContents());){
                        Properties properties = new Properties();
                        properties.load(is);
                    }
                }
                log.debug("Loaded [%s]", configFile.getFilePath());
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return configFiles;
    }

    protected byte[] generateCustomConfigFile(Cluster cluster, Account account, ConfigRequestBody configRequestBody, DruidConfigFile configFile) throws IOException {
        String instanceType = configRequestBody.getInstanceType().toLowerCase();
        switch (configFile.getFileType()) {
            case RUNTIME_PROPERTIES: {
                return this.generateCustomRuntimePropertiesFile(cluster, account, instanceType, configFile, configRequestBody);
            }
            case JETSET_PROPERTIES: {
                return this.generateCustomJetsetPropertiesFile(cluster, account, instanceType, configFile);
            }
            case JVM_CONFIG: {
                return this.generateCustomJvmConfigFile(cluster, account, instanceType, configFile, configRequestBody);
            }
            case PIVOT_LICENSE: {
                return this.maybeGenerateImplyLicense(account, cluster);
            }
            case PIVOT_CONFIG: {
                return this.generateCustomPivotConfigFile(cluster, account, configRequestBody, configFile);
            }
            case SUPERVISE: {
                return this.generateCustomSuperviseFile(cluster, configRequestBody, configFile);
            }
            case TRUSTSTORE: {
                return this.generateTruststore(cluster, configRequestBody, configFile);
            }
            case KEYSTORE: {
                return this.generateKeystore(cluster, configRequestBody, configFile);
            }
            case METADATA_TLS_CERT: {
                return this.generateMetadataStoreTlsCert(cluster);
            }
            case METADATA_CLIENT_CERT: {
                return this.generateMetadataStoreClientCert(cluster);
            }
            case METADATA_CLIENT_KEY: {
                return this.generateMetadataStoreClientKey(cluster);
            }
            case GOOGLE_KEY_JSON: {
                return this.generateGoogleKeyJson(cluster);
            }
            case LOGGING_CONFIG: {
                return this.generateLoggingConfigFile();
            }
            case ROLE_MAPPING: {
                return this.generateRoleMappingConfigFile(cluster);
            }
            case PEON_POD_TEMPLATE: {
                return this.generatePeonPodTemplateFile(cluster, account, K8sIngestionUtils.tierNumberFromPeonPodTemplatePath(configFile.getFilePath()));
            }
            case LOG4J: {
                return this.generateCustomLog4jFile(cluster, account, instanceType, configFile, configRequestBody);
            }
        }
        return configFile.getContents();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private byte[] generateCustomJetsetPropertiesFile(Cluster cluster, Account account, String instanceType, DruidConfigFile configFile) throws IOException {
        if (account == null || account.getRegion() == null) {
            return configFile.getContents();
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(configFile.getContents());){
            byte[] byArray;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                boolean useSignatureV2;
                Properties props = new Properties();
                props.load(is);
                if (account.getRegion().getS3Endpoint() != null) {
                    props.setProperty("s3service.s3-endpoint", account.getRegion().getS3Endpoint());
                }
                props.setProperty("storage-service.request-signature-version", (useSignatureV2 = FeatureFlag.enabledForCluster(cluster, FeatureFlags.S3_SIGNATURE_V2, this.refreshableConstants)) ? "AWS2" : "AWS4-HMAC-SHA256");
                if (cluster == null || cluster.getDeepStorage() == null || cluster.getDeepStorage().isUseEncryption() == null || cluster.getDeepStorage().isUseEncryption().booleanValue()) {
                    props.setProperty("s3service.server-side-encryption", "AES256");
                }
                props.store(os, String.format("Generated config: service [%s] / clusterId [%s] / instanceType [%s]", new Object[]{configFile.getServiceType(), cluster != null ? cluster.getClusterId() : "null", instanceType}));
                byArray = os.toByteArray();
            }
            return byArray;
        }
    }

    private byte[] generateCustomRuntimePropertiesFile(Cluster cluster, Account account, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) throws IOException {
        Properties props = this.generateCustomRuntimeProperties(cluster, account, instanceType, configFile, configRequestBody);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            props.store(os, String.format("Generated config: service [%s] / clusterId [%s] / instanceType [%s]", new Object[]{configFile.getServiceType(), cluster.getClusterId(), instanceType}));
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    protected Properties generateCustomRuntimeProperties(Cluster cluster, Account account, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(configFile.getContents());){
            Integer instanceTier;
            Properties props = new Properties();
            props.load(is);
            DruidConfiguration druidConfiguration = DruidConfiguration.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
            if (druidConfiguration != null) {
                switch (configFile.getServiceType()) {
                    case COMMON: {
                        if (druidConfiguration.getCommonRuntimeProperties() == null) break;
                        druidConfiguration.getCommonRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case BROKER: {
                        if (druidConfiguration.getBrokerRuntimeProperties() == null) break;
                        druidConfiguration.getBrokerRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case COORDINATOR: {
                        if (druidConfiguration.getCoordinatorRuntimeProperties() == null) break;
                        druidConfiguration.getCoordinatorRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case HISTORICAL: {
                        if (druidConfiguration.getHistoricalRuntimeProperties() == null) break;
                        druidConfiguration.getHistoricalRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case MIDDLE_MANAGER: {
                        if (druidConfiguration.getMiddleManagerRuntimeProperties() == null) break;
                        druidConfiguration.getMiddleManagerRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case INDEXER: {
                        if (druidConfiguration.getIndexerRuntimeProperties() == null) break;
                        druidConfiguration.getIndexerRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case OVERLORD: {
                        if (druidConfiguration.getOverlordRuntimeProperties() == null) break;
                        druidConfiguration.getOverlordRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case ROUTER: {
                        if (druidConfiguration.getRouterRuntimeProperties() == null) break;
                        druidConfiguration.getRouterRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case COLD_BROKER: {
                        if (druidConfiguration.getColdBrokerRuntimeProperties() == null) break;
                        druidConfiguration.getColdBrokerRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case COLD_HISTORICAL: {
                        if (druidConfiguration.getColdHistoricalRuntimeProperties() == null) break;
                        druidConfiguration.getColdHistoricalRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                    case PEON: {
                        if (druidConfiguration.getPeonRuntimeProperties() == null) break;
                        druidConfiguration.getPeonRuntimeProperties().forEach(props::setProperty);
                        break;
                    }
                }
            }
            if (ImmutableList.of((Object)((Object)ServiceType.MIDDLE_MANAGER), (Object)((Object)ServiceType.INDEXER)).contains((Object)configFile.getServiceType())) {
                props.setProperty("druid.indexer.task.baseDir", "/mnt/tmp");
            }
            if (configFile.getServiceType().equals((Object)ServiceType.COMMON)) {
                props.setProperty("druid.extensions.hadoopDependenciesDir", "/opt/imply/hadoop-dependencies");
                props.setProperty("druid.extensions.directory", "/opt/imply/extensions");
            }
            if ((instanceTier = configRequestBody.getInstanceTier()) != null && instanceTier > 1) {
                if (configFile.getServiceType().equals((Object)ServiceType.HISTORICAL)) {
                    props.setProperty("druid.service", String.format("druid/historical/tier%d", instanceTier));
                } else if (configFile.getServiceType().equals((Object)ServiceType.MIDDLE_MANAGER)) {
                    props.setProperty("druid.service", String.format("druid/middleManager/tier%d", instanceTier));
                } else if (configFile.getServiceType().equals((Object)ServiceType.INDEXER)) {
                    props.setProperty("druid.service", String.format("druid/indexer/tier%d", instanceTier));
                }
            }
            this.addPlatformSpecificRuntimeProperties(props, cluster, account, instanceType, configFile, configRequestBody);
            this.addClusterDefinedProperties(props, cluster, account, configFile, instanceType, configRequestBody);
            this.addFeatureFlagDefinedProperties(props, cluster, configFile);
            this.addUserDefinedProperties(props, cluster, configFile, configRequestBody);
            this.maybeAddQuerySchedulerNumThreadsConfiguration(props, cluster, configFile);
            this.maybeAddContinuousProfilingRuntimeProperties(props, cluster, account, configFile, configRequestBody);
            this.maybeAddImplyLicense(props, cluster, account, configFile);
            Properties properties = props;
            return properties;
        }
    }

    protected abstract void addPlatformSpecificRuntimeProperties(Properties var1, Cluster var2, Account var3, String var4, DruidConfigFile var5, ConfigRequestBody var6);

    protected Set<String> addEmittersToProperties(Properties props, Cluster cluster, Account account, String instanceType, ConfigRequestBody configRequestBody) throws IOException {
        boolean addedClarity = this.maybeAddClarityConfiguration(props, cluster, account, instanceType, configRequestBody);
        if (addedClarity) {
            props.setProperty("druid.emitter", "clarity");
            return ImmutableSet.of((Object)"clarity");
        }
        return ImmutableSet.of();
    }

    @VisibleForTesting
    protected void addClusterDefinedProperties(Properties props, Cluster cluster, Account account, DruidConfigFile configFile, String instanceType, ConfigRequestBody configRequestBody) throws IOException {
        if (DruidConfigFile.FileType.RUNTIME_PROPERTIES.equals((Object)configFile.getFileType())) {
            if (ServiceType.COMMON.equals((Object)configFile.getServiceType())) {
                boolean clarityEnabled = this.addEmittersToProperties(props, cluster, account, instanceType, configRequestBody).contains("clarity");
                this.addDefaultQueryContextValues(props, account);
                this.addMetadataStorage(props, cluster);
                this.addDeepStorage(props, cluster);
                this.addExtensions(props, cluster, clarityEnabled);
                this.addHadoopDependencies(props, cluster);
                this.maybeAddTlsConfiguration(props, cluster);
                this.maybeAddAuthenticationConfiguration(props, cluster);
            }
            if (ImmutableList.of((Object)((Object)ServiceType.COMMON), (Object)((Object)ServiceType.HISTORICAL), (Object)((Object)ServiceType.BROKER), (Object)((Object)ServiceType.COLD_BROKER), (Object)((Object)ServiceType.COLD_HISTORICAL), (Object)((Object)ServiceType.OVERLORD)).contains((Object)configFile.getServiceType())) {
                props.setProperty("druid.monitoring.monitors", OBJECT_MAPPER.writeValueAsString(this.getMonitorsProperty(cluster, configFile.getServiceType(), configRequestBody)));
            }
            if (ImmutableList.of((Object)((Object)ServiceType.BROKER), (Object)((Object)ServiceType.COLD_BROKER)).contains((Object)configFile.getServiceType())) {
                props.setProperty("druid.request.logging.type", "slf4j");
                props.setProperty("druid.request.logging.setMDC", "true");
                props.setProperty("druid.request.logging.setContextMDC", "true");
            }
            if (ServiceType.HISTORICAL.equals((Object)configFile.getServiceType())) {
                InstanceTier instanceTier;
                int dataTier = configRequestBody.getInstanceTier() != null && configRequestBody.getInstanceTier() > 0 ? configRequestBody.getInstanceTier() : 1;
                props.setProperty("druid.server.tier", dataTier == 1 ? "_default_tier" : String.format("_tier%s", dataTier));
                InstanceTier instanceTier2 = instanceTier = cluster.getDataInstanceTiers() == null ? null : cluster.getDataInstanceTiers().get(dataTier);
                if (instanceTier != null) {
                    props.setProperty("druid.server.tier", instanceTier.getName());
                    props.setProperty("druid.server.priority", Integer.toString(instanceTier.getPriority()));
                }
            }
            if (ServiceType.OVERLORD.equals((Object)configFile.getServiceType()) || ServiceType.MIDDLE_MANAGER.equals((Object)configFile.getServiceType()) || ServiceType.PEON.equals((Object)configFile.getServiceType()) || ServiceType.BROKER.equals((Object)configFile.getServiceType())) {
                props.putAll((Map<?, ?>)cluster.getDeepStorage().getMSQEDurableStorageLocationProperties(cluster.getImplyVersionFull()));
            }
        }
    }

    protected void addDefaultQueryContextValues(Properties props, Account account) {
    }

    protected List<String> getMonitorsProperty(Cluster cluster, ServiceType serviceType, ConfigRequestBody configRequestBody) {
        String serverMetricsPackage;
        String utilMetricsPackage = this.useApachePackaging(cluster) ? "org.apache.druid.java.util.metrics" : (this.useDruidPackageForMonitorClassName(cluster) ? "io.druid.java.util.metrics" : "com.metamx.metrics");
        ArrayList<String> monitors = new ArrayList<String>();
        monitors.add(String.format("%s.JvmMonitor", utilMetricsPackage));
        if (cluster.getImplyVersionFull().getComparableVersion().compareTo(Constants.MIN_IMPLY_VERSION_OSHI_MONITOR) >= 0) {
            monitors.add(String.format("%s.OshiSysMonitor", utilMetricsPackage));
        } else {
            this.maybeAddSysMonitor(monitors, String.format("%s.SysMonitor", utilMetricsPackage), cluster, configRequestBody);
        }
        String string = serverMetricsPackage = this.useApachePackaging(cluster) ? "org.apache.druid.server.metrics" : "io.druid.server.metrics";
        if (cluster.getImplyVersionFull().getComparableVersion().compareTo(Constants.MIN_IMPLY_VERSION_SERVICE_STATUS_MONITOR_NON_POLARIS) >= 0) {
            monitors.add("org.apache.druid.server.metrics.ServiceStatusMonitor");
        }
        if (ImmutableList.of((Object)((Object)ServiceType.HISTORICAL), (Object)((Object)ServiceType.COLD_HISTORICAL)).contains((Object)serviceType)) {
            monitors.add(String.format("%s.HistoricalMetricsMonitor", serverMetricsPackage));
        }
        if (ImmutableList.of((Object)((Object)ServiceType.BROKER), (Object)((Object)ServiceType.COLD_BROKER), (Object)((Object)ServiceType.HISTORICAL), (Object)((Object)ServiceType.COLD_HISTORICAL), (Object)((Object)ServiceType.PEON)).contains((Object)serviceType)) {
            monitors.add(String.format("%s.QueryCountStatsMonitor", serverMetricsPackage));
        }
        if (cluster.getImplyVersionFull().getComparableVersion().compareTo(Constants.MIN_IMPLY_VERSION_CACHE_MONITORING) >= 0 && ImmutableList.of((Object)((Object)ServiceType.HISTORICAL), (Object)((Object)ServiceType.COLD_HISTORICAL), (Object)((Object)ServiceType.BROKER), (Object)((Object)ServiceType.COLD_BROKER)).contains((Object)serviceType)) {
            monitors.add("org.apache.druid.client.cache.CacheMonitor");
        }
        if (ServiceType.OVERLORD.equals((Object)serviceType) && cluster.getImplyVersionFull().getComparableVersion().compareTo(Constants.MIN_IMPLY_VERSION_TASK_SLOT_COUNT_STATS_MONITOR) >= 0) {
            monitors.add("org.apache.druid.server.metrics.TaskSlotCountStatsMonitor");
        }
        return monitors;
    }

    protected void maybeAddSysMonitor(List<String> monitors, String sysMonitor, Cluster cluster, ConfigRequestBody configRequestBody) {
        monitors.add(sysMonitor);
    }

    protected boolean useDruidPackageForMonitorClassName(Cluster cluster) {
        ImplyVersion myImplyVersion = cluster.getImplyVersionFull();
        return myImplyVersion.getComparableVersion() != null && myImplyVersion.getComparableVersion().compareTo(Constants.EARLIEST_VERSION_MONITORS_IN_DRUID_PACKAGE) >= 0;
    }

    private void addMetadataStorage(Properties props, Cluster cluster) {
        if (cluster == null || cluster.getMetadataStorage() == null || cluster.getMetadataStorage().getMetadataType() == null) {
            return;
        }
        props.setProperty("druid.metadata.storage.type", cluster.getMetadataStorage().getMetadataType());
    }

    private boolean useApachePackaging(Cluster cluster) {
        ImplyVersion myImplyVersion = cluster.getImplyVersionFull();
        return myImplyVersion.getComparableVersion() != null && myImplyVersion.getComparableVersion().compareTo(Constants.EARLIEST_VERSION_APACHE_PACKAGING) >= 0;
    }

    private void addDeepStorage(Properties props, Cluster cluster) {
        if (cluster == null || cluster.getDeepStorage() == null) {
            return;
        }
        props.putAll((Map<?, ?>)cluster.getDeepStorage().getSegmentLocationProperties());
        props.putAll((Map<?, ?>)cluster.getDeepStorage().getIndexingLogLocationProperties());
    }

    protected void addExtensions(Properties props, Cluster cluster, boolean loadClarityEmitter) throws IOException {
        this.addExtensions(props, cluster, loadClarityEmitter, new HashSet<String>());
    }

    protected void addExtensions(Properties props, Cluster cluster, boolean loadClarityEmitter, Set<String> extensionLoadList) throws IOException {
        DruidExtensions druidExtensions = DruidExtensions.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        if (druidExtensions != null && druidExtensions.getBaseLoadList() != null) {
            extensionLoadList.addAll(druidExtensions.getBaseLoadList());
            if (cluster.isUseTls() == null && !this.areTlsAndAuthenticationEnabledByDefault() || cluster.isUseTls() != null && !cluster.isUseTls().booleanValue()) {
                extensionLoadList.remove("simple-client-sslcontext");
            }
            if (cluster.isUseAuthentication() == null && !this.areTlsAndAuthenticationEnabledByDefault() || cluster.isUseAuthentication() != null && !cluster.isUseAuthentication().booleanValue()) {
                extensionLoadList.remove("druid-basic-security");
                extensionLoadList.remove("imply-druid-security");
            } else {
                extensionLoadList.addAll(this.clusterAuthConfigurator.getExtensions(cluster));
            }
        }
        if (loadClarityEmitter) {
            extensionLoadList.add("clarity-emitter");
        } else {
            extensionLoadList.remove("clarity-emitter");
        }
        if (cluster.getDeepStorage() instanceof HdfsDeepStorage) {
            extensionLoadList.add("druid-hdfs-storage");
        } else if (cluster.getDeepStorage() instanceof S3DeepStorage) {
            extensionLoadList.add("druid-s3-extensions");
        } else if (cluster.getDeepStorage() instanceof GCSDeepStorage) {
            extensionLoadList.add("druid-google-extensions");
        } else if (cluster.getDeepStorage() instanceof AzureDeepStorage) {
            extensionLoadList.add("druid-azure-extensions");
        }
        if (cluster.getMetadataStorage() instanceof MySqlMetadataStorage) {
            extensionLoadList.add("mysql-metadata-storage");
        } else if (cluster.getMetadataStorage() instanceof PostgreSqlMetadataStorage) {
            extensionLoadList.add("postgresql-metadata-storage");
            extensionLoadList.remove("mysql-metadata-storage");
        }
        if (cluster.getExtensionLoadList() != null) {
            extensionLoadList.addAll(cluster.getExtensionLoadList());
        }
        if (cluster.getUserExtensions() != null) {
            extensionLoadList.addAll(cluster.getUserExtensions().keySet());
        }
        FeatureFlag.getForCluster(cluster, this.refreshableConstants).forEach(x -> extensionLoadList.addAll(CollectionUtils.emptyIfNull(x.getUserExtensions())));
        props.setProperty("druid.extensions.loadList", OBJECT_MAPPER.writeValueAsString(extensionLoadList));
    }

    private void addHadoopDependencies(Properties props, Cluster cluster) throws IOException {
        HashSet<String> defaultHadoopCoordinates = new HashSet<String>();
        DruidExtensions druidExtensions = DruidExtensions.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        if (druidExtensions != null && druidExtensions.getDefaultHadoopCoordinates() != null) {
            defaultHadoopCoordinates.addAll(druidExtensions.getDefaultHadoopCoordinates());
        }
        props.setProperty("druid.indexer.task.defaultHadoopCoordinates", OBJECT_MAPPER.writeValueAsString(defaultHadoopCoordinates));
    }

    protected boolean maybeAddClarityConfiguration(Properties props, Cluster cluster, Account account, String instanceType, ConfigRequestBody configRequestBody) throws IOException {
        Optional<Pair<String, String>> clarityBasicAuthCredentials = this.getClarityBasicAuthCredentials(account);
        if (!clarityBasicAuthCredentials.isPresent()) {
            return false;
        }
        props.setProperty("druid.emitter.clarity.recipientBaseUrl", String.format("%s/%s", this.config.getClarityCollectorBaseUrl(), clarityBasicAuthCredentials.get().lhs));
        props.setProperty("druid.emitter.clarity.basicAuthentication", String.format("%s:%s", clarityBasicAuthCredentials.get().lhs, clarityBasicAuthCredentials.get().rhs));
        props.setProperty("druid.emitter.clarity.clusterName", cluster.getClusterId());
        ImmutableMap context = ImmutableMap.of((Object)"implyInstanceType", (Object)instanceType, (Object)"implyAccountId", (Object)account.getAccountId(), (Object)"implyAccountName", (Object)account.getName(), (Object)"implyClusterName", (Object)cluster.getName(), (Object)"implyRegion", (Object)(account.getRegion() == null ? Region.NONE.getName() : account.getRegion().getName()));
        props.setProperty("druid.emitter.clarity.context", OBJECT_MAPPER.writeValueAsString((Object)context));
        return true;
    }

    private Optional<Pair<String, String>> getClarityBasicAuthCredentials(Account account) {
        String clarityPassword;
        String clarityUser;
        if (!Strings.isNullOrEmpty((String)account.getClarityUser()) && !Strings.isNullOrEmpty((String)account.getClarityPassword())) {
            clarityUser = account.getClarityUser();
            clarityPassword = account.getClarityPassword();
        } else if (!Strings.isNullOrEmpty((String)this.config.getClarityDefaultUser()) && !Strings.isNullOrEmpty((String)this.config.getClarityDefaultPassword())) {
            clarityUser = this.config.getClarityDefaultUser();
            clarityPassword = this.config.getClarityDefaultPassword();
        } else {
            return Optional.empty();
        }
        return Optional.of(Pair.of(clarityUser, clarityPassword));
    }

    public String maybeAppendContinuousProfilingJvmConfigs(Cluster cluster, Account account) {
        if (!FeatureFlag.enabledForCluster(cluster, FeatureFlags.CONTINUOUS_PROFILING, this.refreshableConstants)) {
            return "";
        }
        Optional<Pair<String, String>> clarityBasicAuthCredentials = this.getClarityBasicAuthCredentials(account);
        if (!clarityBasicAuthCredentials.isPresent()) {
            return "";
        }
        ArrayList<String> agentJvmConfigs = new ArrayList<String>();
        agentJvmConfigs.add(String.format("-DclarityProfiling.credentials=%s:%s", clarityBasicAuthCredentials.get().lhs, clarityBasicAuthCredentials.get().rhs));
        this.appendContinuousProfilingJvmConfigs(cluster, agentJvmConfigs);
        return String.join((CharSequence)"\n", agentJvmConfigs).concat("\n");
    }

    public void maybeAddContinuousProfilingRuntimeProperties(Properties props, Cluster cluster, Account account, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        if (!configFile.getServiceType().equals((Object)ServiceType.MIDDLE_MANAGER) || !FeatureFlag.enabledForCluster(cluster, FeatureFlags.CONTINUOUS_PROFILING, this.refreshableConstants)) {
            return;
        }
        Optional<Pair<String, String>> clarityBasicAuthCredentials = this.getClarityBasicAuthCredentials(account);
        if (!clarityBasicAuthCredentials.isPresent()) {
            return;
        }
        props.setProperty("druid.indexer.fork.property.clarityProfiling.credentials", String.format("%s:%s", clarityBasicAuthCredentials.get().lhs, clarityBasicAuthCredentials.get().rhs));
        String indexerJavaOptsConfig = props.getProperty("druid.indexer.runner.javaOptsArray", "[]");
        try {
            List indexerJavaOpts = (List)OBJECT_MAPPER.readerForListOf(String.class).readValue(indexerJavaOptsConfig);
            this.appendContinuousProfilingJvmConfigs(cluster, indexerJavaOpts);
            String updatedIndexerJavaOptsConfig = OBJECT_MAPPER.writeValueAsString((Object)indexerJavaOpts);
            props.setProperty("druid.indexer.runner.javaOptsArray", updatedIndexerJavaOptsConfig);
        }
        catch (JsonProcessingException e) {
            log.warn("Unable to read 'druid.indexer.runner.javaOptsArray' into an array, skipping profiler for peons");
            return;
        }
    }

    private void appendContinuousProfilingJvmConfigs(Cluster cluster, List<String> javaOpts) {
        if (cluster.isOnOrAfterVersion(Constants.MIN_IMPLY_VERSION_VERSIONLESS_CONTINUOUS_PROFILING)) {
            javaOpts.add(String.format("-javaagent:/opt/imply/extensions/imply-profiling/%s", PROFILING_JAR_VERSIONLESS_NAME));
        } else if (cluster.isOnOrAfterVersion(Constants.MIN_IMPLY_VERSION_BUNDLED_CONTINUOUS_PROFILING)) {
            javaOpts.add(String.format("-javaagent:/opt/imply/extensions/imply-profiling/%s", this.config.getContinuousProfilingAgentName()));
        } else {
            javaOpts.add(String.format("-javaagent:/opt/imply/user/%s", this.config.getContinuousProfilingAgentName()));
        }
    }

    public List<UserFile> maybeGenerateContinuousProfilingAgentJar(Cluster cluster, Account account) {
        ArrayList<UserFile> profilingAgent = new ArrayList<UserFile>();
        if (cluster.isOnOrAfterVersion(Constants.MIN_IMPLY_VERSION_BUNDLED_CONTINUOUS_PROFILING)) {
            return profilingAgent;
        }
        if (FeatureFlag.enabledForCluster(cluster, FeatureFlags.CONTINUOUS_PROFILING, this.refreshableConstants) && this.getClarityBasicAuthCredentials(account).isPresent()) {
            profilingAgent.add(new UserFile(String.format("%s/%s", this.config.getContinuousProfilingAgentRepo(), this.config.getContinuousProfilingAgentName())));
        }
        return profilingAgent;
    }

    private void maybeAddTlsConfiguration(Properties props, Cluster cluster) {
        if (cluster == null || cluster.getSecurityConfiguration() == null || cluster.getSecurityConfiguration().getKeyStorePassword() == null) {
            return;
        }
        if (cluster.isUseTls() == null && !this.areTlsAndAuthenticationEnabledByDefault() || cluster.isUseTls() != null && !cluster.isUseTls().booleanValue()) {
            return;
        }
        props.setProperty("druid.enablePlaintextPort", "false");
        props.setProperty("druid.enableTlsPort", "true");
        props.setProperty("druid.server.https.keyStorePath", "/opt/imply/conf/druid/_common/keystore.jks");
        props.setProperty("druid.server.https.keyStoreType", "jks");
        props.setProperty("druid.server.https.certAlias", "druid");
        props.setProperty("druid.client.https.protocol", "TLSv1.2");
        props.setProperty("druid.client.https.trustStoreType", "jks");
        props.setProperty("druid.client.https.trustStorePath", "/opt/imply/conf/druid/_common/truststore.jks");
        props.setProperty("druid.client.https.trustStoreAlgorithm", "PKIX");
        SecurityConfiguration securityConfiguration = cluster.getSecurityConfiguration();
        props.setProperty("druid.client.https.trustStorePassword", securityConfiguration.getKeyStorePassword());
        props.setProperty("druid.server.https.keyManagerPassword", securityConfiguration.getKeyStorePassword());
        props.setProperty("druid.server.https.keyStorePassword", securityConfiguration.getKeyStorePassword());
    }

    public void maybeAddAuthenticationConfiguration(Properties props, Cluster cluster) throws IOException {
        if (cluster == null || cluster.getSecurityConfiguration() == null) {
            return;
        }
        if (cluster.isUseAuthentication() == null && !this.areTlsAndAuthenticationEnabledByDefault() || cluster.isUseAuthentication() != null && !cluster.isUseAuthentication().booleanValue()) {
            return;
        }
        props.putAll((Map<?, ?>)this.clusterAuthConfigurator.getAuthenticatorProperties(cluster));
        props.putAll((Map<?, ?>)this.clusterAuthConfigurator.getEscalatorProperties(cluster));
    }

    private void maybeAddQuerySchedulerNumThreadsConfiguration(Properties properties, Cluster cluster, DruidConfigFile configFile) {
        if (!ImmutableList.of((Object)((Object)ServiceType.BROKER), (Object)((Object)ServiceType.COLD_BROKER)).contains((Object)configFile.getServiceType())) {
            return;
        }
        String querySchedulerNumThreadsProperty = properties.getProperty("druid.query.scheduler.numThreads");
        if (querySchedulerNumThreadsProperty != null) {
            return;
        }
        String servNumThreadsPropKey = "druid.server.http.numThreads";
        String serverNumThreadsProperty = properties.getProperty(servNumThreadsPropKey);
        if (serverNumThreadsProperty == null) {
            return;
        }
        boolean enableRequestLimit = Optional.ofNullable(properties.getProperty("druid.server.http.enableRequestLimit")).map(p -> Boolean.parseBoolean(p)).orElse(false);
        List<FeatureFlag> featureFlags = FeatureFlag.getForCluster(cluster, this.refreshableConstants);
        FeatureFlag reserveThreadsForNonQueryRequests = featureFlags.stream().filter(f -> f.getId().equals("reserveThreadsForNonQueryRequests")).findFirst().orElse(null);
        if (reserveThreadsForNonQueryRequests != null) {
            Integer serverNumThreads = Ints.tryParse((String)serverNumThreadsProperty);
            Integer threadBuffer = enableRequestLimit ? 1 : 0;
            if (serverNumThreads != null && serverNumThreads > 1) {
                Integer newServerNumThreads = serverNumThreads + 5;
                properties.setProperty(servNumThreadsPropKey, String.valueOf(newServerNumThreads));
                properties.setProperty("druid.query.scheduler.numThreads", String.format("%d", serverNumThreads - threadBuffer));
            }
        }
    }

    protected abstract void maybeAddImplyLicense(Properties var1, Cluster var2, Account var3, DruidConfigFile var4);

    private void addFeatureFlagDefinedProperties(Properties props, Cluster cluster, DruidConfigFile configFile) {
        for (FeatureFlag featureFlag : FeatureFlag.getForCluster(cluster, this.refreshableConstants)) {
            for (Map.Entry<String, Object> property : this.getFeatureFlagPropertiesForServiceType(featureFlag, configFile.getServiceType()).entrySet()) {
                if (property.getKey().startsWith("jvm.config") || property.getKey().startsWith("container.resources") || property.getValue() == null) continue;
                String newValue = property.getValue().toString();
                Object previousValue = props.setProperty(property.getKey(), newValue);
                log.debug("Overriding [%s->%s] with [%s->%s] for file [%s] in clusterId [%s] for feature flag [%s]", property.getKey(), previousValue, property.getKey(), newValue, configFile.getFilePath(), cluster.getClusterId(), featureFlag.getId());
            }
        }
    }

    private Map<String, Object> getFeatureFlagPropertiesForServiceType(FeatureFlag featureFlag, ServiceType serviceType) {
        HashMap<String, Object> serviceTypeProperties = new HashMap<String, Object>();
        if (featureFlag.getDruidProperties() == null) {
            return serviceTypeProperties;
        }
        String serviceTypeKey = DruidConfigFile.getCustomDruidPropertiesKey(serviceType);
        if (serviceTypeKey == null || featureFlag.getDruidProperties().get(serviceTypeKey) == null) {
            return serviceTypeProperties;
        }
        return (Map)featureFlag.getDruidProperties().get(serviceTypeKey);
    }

    protected void addUserDefinedProperties(Properties props, Cluster cluster, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        if (ServiceType.COMMON.equals((Object)configFile.getServiceType())) {
            return;
        }
        Map<String, Object> userProps = this.getUserDefinedPropertiesForService(cluster, configFile, configRequestBody);
        for (Map.Entry<String, Object> extraProperty : userProps.entrySet()) {
            if (extraProperty.getKey().startsWith("jvm.config") || extraProperty.getKey().startsWith("container.resources") || extraProperty.getValue() == null) continue;
            String newValue = extraProperty.getValue().toString();
            Object previousValue = props.setProperty(extraProperty.getKey(), newValue);
            log.debug("Overriding [%s->%s] with [%s->%s] for file [%s] in clusterId [%s]", extraProperty.getKey(), previousValue, extraProperty.getKey(), newValue, configFile.getFilePath(), cluster.getClusterId());
        }
    }

    private Map<String, Object> getUserDefinedPropertiesForService(Cluster cluster, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        Map tierProperties;
        ServiceType effectiveServiceType;
        String extraDruidPropertiesKey;
        Map<String, Object> allExtraDruidProperties = null;
        try {
            allExtraDruidProperties = Cluster.convertCustomDruidPropertiesToExtraDruidProperties(cluster.getCustomDruidProperties());
        }
        catch (Exception e) {
            log.warn(e, "Exception while parsing user-provided custom Druid configurations, continuing without config: %s", cluster.getCustomDruidProperties());
        }
        HashMap<String, Object> extraProps = new HashMap<String, Object>();
        if (allExtraDruidProperties == null) {
            return extraProps;
        }
        String commonDruidPropertiesKey = DruidConfigFile.getCustomDruidPropertiesKey(ServiceType.COMMON);
        if (allExtraDruidProperties.get(commonDruidPropertiesKey) != null) {
            extraProps.putAll((Map)allExtraDruidProperties.get(commonDruidPropertiesKey));
        }
        if ((extraDruidPropertiesKey = DruidConfigFile.getCustomDruidPropertiesKey(effectiveServiceType = ServiceType.INDEXER.equals((Object)configFile.getServiceType()) ? ServiceType.MIDDLE_MANAGER : configFile.getServiceType())) == null) {
            return extraProps;
        }
        if (allExtraDruidProperties.get(extraDruidPropertiesKey) != null) {
            extraProps.putAll((Map)allExtraDruidProperties.get(extraDruidPropertiesKey));
        }
        if (configRequestBody.getInstanceTier() != null && configRequestBody.getInstanceTier() > 0 && (tierProperties = (Map)allExtraDruidProperties.get(DruidConfigFile.getCustomDruidPropertiesKey(effectiveServiceType, ServiceTier.fromInteger(configRequestBody.getInstanceTier())))) != null) {
            extraProps.putAll(tierProperties);
        }
        return extraProps;
    }

    private byte[] generateCustomJvmConfigFile(Cluster cluster, Account account, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        String fileContents = new String(configFile.getContents(), StandardCharsets.UTF_8);
        DruidConfiguration druidConfiguration = DruidConfiguration.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        if (druidConfiguration != null) {
            List<String> jvmConfigList = null;
            switch (configFile.getServiceType()) {
                case BROKER: {
                    jvmConfigList = druidConfiguration.getBrokerJvmConfig();
                    break;
                }
                case COORDINATOR: {
                    jvmConfigList = druidConfiguration.getCoordinatorJvmConfig();
                    break;
                }
                case HISTORICAL: {
                    jvmConfigList = druidConfiguration.getHistoricalJvmConfig();
                    break;
                }
                case MIDDLE_MANAGER: {
                    jvmConfigList = druidConfiguration.getMiddleManagerJvmConfig();
                    break;
                }
                case INDEXER: {
                    jvmConfigList = druidConfiguration.getIndexerJvmConfig();
                    break;
                }
                case OVERLORD: {
                    jvmConfigList = druidConfiguration.getOverlordJvmConfig();
                    break;
                }
                case ROUTER: {
                    jvmConfigList = druidConfiguration.getRouterJvmConfig();
                    break;
                }
                case COLD_BROKER: {
                    jvmConfigList = druidConfiguration.getColdBrokerJvmConfig();
                    break;
                }
                case COLD_HISTORICAL: {
                    jvmConfigList = druidConfiguration.getColdHistoricalJvmConfig();
                    break;
                }
                case PEON: {
                    jvmConfigList = druidConfiguration.getPeonJvmConfig();
                    break;
                }
            }
            if (jvmConfigList != null) {
                fileContents = fileContents.concat(String.join((CharSequence)"\n", jvmConfigList)).concat("\n");
            }
        }
        fileContents = fileContents.concat(this.appendPlatformSpecificJvmConfig(cluster, instanceType, configFile, configRequestBody));
        fileContents = fileContents.concat(this.appendFeatureFlagDefinedJvmConfig(cluster, configFile));
        fileContents = fileContents.concat(this.maybeAppendContinuousProfilingJvmConfigs(cluster, account));
        fileContents = fileContents.concat(this.appendUserDefinedJvmConfig(cluster, configFile, configRequestBody));
        return fileContents.getBytes(StandardCharsets.UTF_8);
    }

    protected String appendInstanceSpecificJvmConfig(Cluster cluster, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        DruidInstanceTypeConfig configSet = DruidInstanceTypeConfig.getForComparableImplyVersion(cluster.getImplyVersionFull().getComparableVersion(), this.refreshableConstants);
        DruidInstanceTypeConfigItem typeSpecificConfigs = configSet.getConfigSet().stream().filter(x -> instanceType.equals(x.getInstanceType().toLowerCase()) && DruidConfigFile.getCustomDruidPropertiesKey(configFile.getServiceType()) != null && DruidConfigFile.getCustomDruidPropertiesKey(configFile.getServiceType()).toLowerCase().equals(x.getServiceType().toLowerCase())).findFirst().orElse(null);
        return this.getJvmConfigFromInstanceType(cluster, typeSpecificConfigs);
    }

    protected String getJvmConfigFromInstanceType(Cluster cluster, DruidInstanceTypeConfigItem typeSpecificConfigs) {
        return typeSpecificConfigs != null && typeSpecificConfigs.getJvmConfig() != null ? String.join((CharSequence)"\n", typeSpecificConfigs.getJvmConfig()).concat("\n") : "";
    }

    protected abstract String appendPlatformSpecificJvmConfig(Cluster var1, String var2, DruidConfigFile var3, ConfigRequestBody var4);

    private String appendFeatureFlagDefinedJvmConfig(Cluster cluster, DruidConfigFile configFile) {
        ArrayList<String> additionalParams = new ArrayList<String>();
        for (FeatureFlag featureFlag : FeatureFlag.getForCluster(cluster, this.refreshableConstants)) {
            for (Map.Entry<String, Object> property : this.getFeatureFlagPropertiesForServiceType(featureFlag, configFile.getServiceType()).entrySet()) {
                if (!property.getKey().startsWith("jvm.config")) continue;
                additionalParams.add(String.valueOf(property.getValue()));
                log.debug("Appending [%s] to file [%s] in clusterId [%s] for feature flag [%s]", property.getValue(), configFile.getFilePath(), cluster.getClusterId(), featureFlag.getId());
            }
        }
        return additionalParams.isEmpty() ? "" : String.join((CharSequence)"\n", additionalParams).concat("\n");
    }

    protected String appendUserDefinedJvmConfig(Cluster cluster, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        ArrayList<String> additionalParams = new ArrayList<String>();
        Map<String, Object> userProps = this.getUserDefinedPropertiesForService(cluster, configFile, configRequestBody);
        for (Map.Entry<String, Object> extraProperty : userProps.entrySet()) {
            if (!extraProperty.getKey().startsWith("jvm.config")) continue;
            additionalParams.add(String.valueOf(extraProperty.getValue()));
            log.debug("Appending [%s] to file [%s] in clusterId [%s]", extraProperty.getValue(), configFile.getFilePath(), cluster.getClusterId());
        }
        return additionalParams.isEmpty() ? "" : String.join((CharSequence)"\n", additionalParams).concat("\n");
    }

    protected byte[] maybeGenerateImplyLicense(Account account, Cluster cluster) {
        return account.getLicenseKey() != null ? account.getLicenseKey().getBytes(StandardCharsets.UTF_8) : null;
    }

    protected void addDefaultDbAuthTokenToFixedConnection(Cluster cluster, Map<String, Object> fixedConnection) {
        if (cluster.getSecurityConfiguration() != null && cluster.getSecurityConfiguration().getInitialDruidAdminPassword() != null) {
            HashMap<String, String> defaultDbAuthToken = new HashMap<String, String>();
            defaultDbAuthToken.put("type", "basic-auth");
            defaultDbAuthToken.put("username", "admin");
            defaultDbAuthToken.put("password", cluster.getSecurityConfiguration().getInitialDruidAdminPassword());
            fixedConnection.put("defaultDbAuthToken", defaultDbAuthToken);
        }
    }

    protected void addHmacSecret(Cluster cluster, Map<String, Object> config) {
        if (cluster.getSecurityConfiguration() != null && cluster.getSecurityConfiguration().getHmacSecret() != null) {
            config.put("implyTokenSecret", cluster.getSecurityConfiguration().getHmacSecret());
        }
    }

    public byte[] generateCustomPivotConfigFile(Cluster cluster, Account account, ConfigRequestBody configRequestBody, DruidConfigFile configFile) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(configFile.getContents());){
            byte[] byArray;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                Map initialSettings;
                Map configMap = (Map)YAML_MAPPER.readValue((InputStream)is, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Map settingsLocation = (Map)configMap.get("settingsLocation");
                if (settingsLocation != null && (initialSettings = (Map)settingsLocation.get("initialSettings")) != null) {
                    initialSettings.put("druidHost", "localhost:8082");
                }
                boolean useTls = (cluster.isUseTls() == null && this.areTlsAndAuthenticationEnabledByDefault() || cluster.isUseTls() != null && cluster.isUseTls() != false) && cluster.getSecurityConfiguration() != null;
                HashMap<String, Object> fixedConnection = new HashMap<String, Object>();
                fixedConnection.put("name", "druid");
                fixedConnection.put("type", "druid");
                String localRouterHost = String.format("%s:%s", configRequestBody.getMyPrivateIpAddress(), useTls ? "9088" : "8888");
                fixedConnection.put("host", localRouterHost);
                if (useTls) {
                    SecurityConfiguration securityConfiguration = cluster.getSecurityConfiguration();
                    String pemEncodedRootCertificate = new String(TLSUtils.writePemBytes("CERTIFICATE", securityConfiguration.getRootCertificate()));
                    CertAndKeyHolder certAndKeyHolder = this.certificateCache.getServerCertificateAndKeys(configRequestBody);
                    if (certAndKeyHolder != null) {
                        ArrayList<String> certificateChain = new ArrayList<String>();
                        certificateChain.add(new String(TLSUtils.writePemBytes("CERTIFICATE", certAndKeyHolder.getCertificate())));
                        certificateChain.add(new String(TLSUtils.writePemBytes("CERTIFICATE", securityConfiguration.getIntermediateCertificate())));
                        if (securityConfiguration.getParentIntermediateCertificates() != null) {
                            for (byte[] intermediateCert : securityConfiguration.getParentIntermediateCertificates()) {
                                certificateChain.add(new String(TLSUtils.writePemBytes("CERTIFICATE", intermediateCert)));
                            }
                        }
                        String pemEncodedServerPrivateKey = new String(TLSUtils.writePemBytes("PRIVATE KEY", certAndKeyHolder.getPrivateKey()));
                        configMap.put("serverHttpsOptions", ImmutableMap.of((Object)"cert", (Object)Joiner.on((String)"").join(certificateChain), (Object)"ca", (Object)pemEncodedRootCertificate, (Object)"key", (Object)pemEncodedServerPrivateKey));
                    }
                    fixedConnection.put("protocol", "tls");
                    ArrayList<String> rootCAs = new ArrayList<String>();
                    rootCAs.add(pemEncodedRootCertificate);
                    if (this.securityConfig.getAlternateRootCertificates() != null) {
                        for (byte[] cert : this.securityConfig.getAlternateRootCertificates()) {
                            rootCAs.add(new String(TLSUtils.writePemBytes("CERTIFICATE", cert)));
                        }
                    }
                    fixedConnection.put("ca", rootCAs);
                }
                this.addDefaultDbAuthTokenToFixedConnection(cluster, fixedConnection);
                configMap.put("fixedConnections", ImmutableList.of(fixedConnection));
                this.addHmacSecret(cluster, configMap);
                configMap.put("additionalServiceHealthChecks", useTls ? ImmutableList.of((Object)"https://localhost:9088/status/health", (Object)"https://localhost:8282/status/health") : ImmutableList.of((Object)"http://localhost:8888/status/health", (Object)"http://localhost:8082/status/health"));
                PivotConfiguration pivotConfiguration = PivotConfiguration.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
                if (pivotConfiguration != null && pivotConfiguration.getConfig() != null) {
                    MapUtils.deepMerge(configMap, pivotConfiguration.getConfig());
                }
                if (cluster.getPivot() != null) {
                    MapUtils.deepMerge(configMap, cluster.getPivot().getConfig());
                }
                if (cluster.getMapbox() != null) {
                    MapUtils.deepMerge(configMap, cluster.getMapbox().getConfig());
                }
                this.addPlatformSpecificPivotConfiguration(configMap, cluster, account);
                try {
                    if (cluster.getCustomDruidProperties() != null && StringUtils.isNotBlank((CharSequence)cluster.getCustomDruidProperties().get(ServiceType.PIVOT.getCustomDruidPropertiesKey()))) {
                        Map userPivotConfigs = (Map)YAML_MAPPER.readValue(cluster.getCustomDruidProperties().get(ServiceType.PIVOT.getCustomDruidPropertiesKey()), (TypeReference)new TypeReference<Map<String, Object>>(){});
                        MapUtils.deepMerge(configMap, userPivotConfigs);
                    }
                }
                catch (Exception e) {
                    log.warn(e, "Exception while parsing user-provided Pivot configuration as YAML, continuing without config: %s", cluster.getCustomDruidProperties().get(ServiceType.PIVOT.getCustomDruidPropertiesKey()));
                }
                YAML_MAPPER.writeValue((OutputStream)os, (Object)configMap);
                byArray = os.toByteArray();
            }
            return byArray;
        }
    }

    protected void addPlatformSpecificPivotConfiguration(Map<String, Object> configMap, Cluster cluster, Account account) {
    }

    protected void addPlatformSpecificServiceToSupervise(StringBuilder contents, ImplyNodeType nodeType, Cluster cluster) {
    }

    private byte[] generateCustomSuperviseFile(Cluster cluster, ConfigRequestBody configRequestBody, DruidConfigFile configFile) {
        if (!configFile.getFilePath().endsWith("druid.conf") || configRequestBody.getServiceTypes() == null) {
            return configFile.getContents();
        }
        StringBuilder contents = new StringBuilder();
        contents.append(":verify bin/verify-java\n");
        for (String serviceTypeStr : configRequestBody.getServiceTypes()) {
            ImplyNodeType nodeType = ImplyNodeType.fromString(serviceTypeStr);
            if (nodeType == null) continue;
            switch (nodeType.getNodeServiceType()) {
                case MASTER: {
                    this.appendDruidServiceToSupervise(contents, "coordinator");
                    this.appendDruidServiceToSupervise(contents, "overlord");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                    break;
                }
                case DATA: {
                    this.appendDruidServiceToSupervise(contents, "historical");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                    break;
                }
                case QUERY: {
                    this.appendDruidServiceToSupervise(contents, "router");
                    this.appendDruidServiceToSupervise(contents, "broker");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                    break;
                }
                case INGEST: {
                    this.appendDruidServiceToSupervise(contents, this.useIndexerInsteadOfMiddleManager(cluster) ? "indexer" : "middleManager");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                    break;
                }
                case COLD_TIER_DATA: {
                    this.appendDruidServiceToSupervise(contents, "coldHistorical");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                    break;
                }
                case COLD_TIER_QUERY: {
                    this.appendDruidServiceToSupervise(contents, "coldBroker");
                    this.addPlatformSpecificServiceToSupervise(contents, nodeType, cluster);
                }
            }
        }
        return contents.toString().getBytes();
    }

    protected void appendDruidServiceToSupervise(StringBuilder contents, String serviceName) {
        contents.append(String.format("%1$s %2$s %1$s %3$s\n", serviceName, "bin/run-druid", "/opt/imply/conf"));
    }

    protected boolean useIndexerInsteadOfMiddleManager(Cluster cluster) {
        return FeatureFlag.enabledForCluster(cluster, FeatureFlags.USE_INDEXERS, this.refreshableConstants);
    }

    protected abstract byte[] generateTruststore(Cluster var1, ConfigRequestBody var2, DruidConfigFile var3);

    protected abstract byte[] generateKeystore(Cluster var1, ConfigRequestBody var2, DruidConfigFile var3);

    private byte[] generateMetadataStoreTlsCert(Cluster cluster) {
        if (cluster.getMetadataStorage() == null || cluster.getMetadataStorage().getTlsCert() == null || cluster.getMetadataStorage().getTlsCert().isEmpty()) {
            return null;
        }
        return cluster.getMetadataStorage().getTlsCert().getBytes(StandardCharsets.UTF_8);
    }

    protected abstract byte[] generateMetadataStoreClientCert(Cluster var1);

    protected abstract byte[] generateMetadataStoreClientKey(Cluster var1);

    private byte[] generateGoogleKeyJson(Cluster cluster) {
        DeepStorage storage = cluster.getDeepStorage();
        if (storage == null || !(storage instanceof GCSDeepStorage)) {
            return null;
        }
        GCSDeepStorage gcsStorage = (GCSDeepStorage)storage;
        if (Strings.isNullOrEmpty((String)gcsStorage.getJsonKey())) {
            return null;
        }
        return gcsStorage.getJsonKey().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] generateLoggingConfigFile() {
        return "u127.0.0.1\ns100000000\nn10\nN5\n".getBytes(StandardCharsets.UTF_8);
    }

    private byte[] generateRoleMappingConfigFile(Cluster cluster) throws IOException {
        DruidRoleMapping roleMapping = DruidRoleMapping.getForImplyVersion(cluster.getImplyVersionFull(), this.refreshableConstants);
        return roleMapping != null ? OBJECT_MAPPER.writeValueAsString(roleMapping.getRoles()).getBytes(StandardCharsets.UTF_8) : null;
    }

    protected byte[] generatePeonPodTemplateFile(Cluster cluster, Account account, Integer tierNumber) {
        return new byte[0];
    }

    protected byte[] generateCustomLog4jFile(Cluster cluster, Account account, String instanceType, DruidConfigFile druidConfigFile, ConfigRequestBody configRequestBody) throws IOException {
        return druidConfigFile.getContents();
    }

    public List<DruidConfigFile> getConfigFiles(Cluster cluster) {
        return this.configFiles;
    }

    public String generateClusterHelmValueOverrides(Cluster cluster, Account account) {
        throw new UnsupportedOperationException();
    }

    protected RefreshableConstants getRefreshableConstants() {
        return this.refreshableConstants;
    }

    protected InstanceTypeHelper getInstanceTypeHelper() {
        return this.instanceTypeHelper;
    }

    @Generated
    protected ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }
}

