/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator;

import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.configurator.CertificateCache;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.tls.CertAndKeyHolder;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;

public class AuthenticationManager {
    private static final Logger log = new Logger(AuthenticationManager.class);
    private final ClusterDataManager clusterDataManager;
    private final EntityStateDataManager entityStateDataManager;
    private final CertificateCache certificateCache;
    private final SecurityConfig securityConfig;

    @Inject
    public AuthenticationManager(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, CertificateCache certificateCache, SecurityConfig securityConfig) {
        this.clusterDataManager = clusterDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.certificateCache = certificateCache;
        this.securityConfig = securityConfig;
    }

    public byte[] getPemEncodedRootCertificate(String clusterId) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(ConfigRequestBody.builder().clusterId(clusterId).build(), this.entityStateDataManager);
        if (cluster == null || cluster.getSecurityConfiguration() == null || cluster.getSecurityConfiguration().getRootCertificate() == null) {
            log.warn("Root certificate lookup for non-existent cluster [%s]", clusterId);
            return null;
        }
        try {
            return TLSUtils.writePemBytes("CERTIFICATE", cluster.getSecurityConfiguration().getRootCertificate());
        }
        catch (Exception e) {
            log.warn(e, "Exception generating PEM encoded certificate for cluster [%s]", clusterId);
            return null;
        }
    }

    public byte[] getServerKeyStore(ConfigRequestBody body) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(body, this.entityStateDataManager);
        if (cluster == null || cluster.getSecurityConfiguration() == null) {
            log.warn("Security configuration not found for cluster [%s]", body.getClusterId());
            return null;
        }
        CertAndKeyHolder certAndKeyHolder = this.certificateCache.getServerCertificateAndKeys(body);
        if (certAndKeyHolder == null) {
            return null;
        }
        try {
            ArrayList<byte[]> intermediateCertificates = new ArrayList<byte[]>();
            intermediateCertificates.add(cluster.getSecurityConfiguration().getIntermediateCertificate());
            if (cluster.getSecurityConfiguration().getParentIntermediateCertificates() != null) {
                intermediateCertificates.addAll(cluster.getSecurityConfiguration().getParentIntermediateCertificates());
            }
            return TLSUtils.generateServerKeystore(certAndKeyHolder.getCertificate(), certAndKeyHolder.getPrivateKey(), intermediateCertificates, cluster.getSecurityConfiguration().getKeyStorePassword(), cluster.getSecurityConfiguration().getKeyStorePassword());
        }
        catch (Exception e) {
            log.warn(e, "Exception generating server key store for cluster [%s] instance [%s]", body.getClusterId(), body.getInstanceId());
            return null;
        }
    }

    public byte[] getClientTrustStore(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        if (cluster == null || cluster.getSecurityConfiguration() == null) {
            log.warn("Security configuration not found for cluster [%s]", configRequestBody.getClusterId());
            return null;
        }
        SecurityConfiguration securityConfiguration = cluster.getSecurityConfiguration();
        if (securityConfiguration.getKeyStorePassword() == null) {
            log.warn("KeyStore password not found for cluster [%s]", cluster.getClusterId());
            return null;
        }
        try {
            HashMap<String, byte[]> certificates = new HashMap<String, byte[]>();
            certificates.put("root", securityConfiguration.getRootCertificate());
            if (this.securityConfig.getAlternateRootCertificates() != null) {
                for (int i = 0; i < this.securityConfig.getAlternateRootCertificates().size(); ++i) {
                    certificates.put(String.format("alt%d", i), this.securityConfig.getAlternateRootCertificates().get(i));
                }
            }
            return TLSUtils.generateClientTruststore(certificates, securityConfiguration.getKeyStorePassword());
        }
        catch (Exception e) {
            log.warn(e, "Exception generating client trust store for cluster [%s]", cluster.getClusterId());
            return null;
        }
    }

    public String getDataVolumeEncryptionKey(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        if (cluster == null || cluster.getSecurityConfiguration() == null || cluster.getSecurityConfiguration().getDataVolumeEncryptionKey() == null) {
            throw new IAE("Data volume encryption key not found for cluster [%s]", configRequestBody.getClusterId());
        }
        return cluster.getSecurityConfiguration().getDataVolumeEncryptionKey();
    }
}

