/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.config;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Constants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.persistence.PasswordProvider;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;

public class RefreshableConstantsConfig {
    private final ApplicationConfig applicationConfig;
    @JsonProperty
    private String s3Region = "us-east-1";
    @JsonProperty
    private String s3Bucket = "imply-cloud";
    @JsonProperty
    private String basePath;
    @JsonProperty
    private String httpRepositoryHost;
    @JsonProperty
    private Integer httpTimeout = Constants.HTTP_CLIENT_TIMEOUT_IN_SECONDS;
    @JsonProperty
    private Map<String, String> httpQueryParams = ImmutableMap.of((Object)"refresh", (Object)"true", (Object)"timeout", (Object)String.valueOf(Constants.GROVE_REPO_DEFAULT_TIMEOUT_IN_SECONDS));
    @JsonProperty
    private boolean skipRefresh = false;
    @JsonProperty
    private Period period;
    @JsonProperty
    private String prefix;
    @JsonProperty
    private String implyVersionsKey;
    @JsonProperty
    private String amiForRegionKey;
    @JsonProperty
    private String masterInstanceTypesKey;
    @JsonProperty
    private String queryInstanceTypesKey;
    @JsonProperty
    private String dataInstanceTypesKey;
    @JsonProperty
    private String dbInstanceTypesKey;
    @JsonProperty
    private String ingestInstanceTypesKey;
    @JsonProperty
    private String druidInstanceTypeConfigurationsKey;
    @JsonProperty
    private String druidExtensionsKey;
    @JsonProperty
    private String pivotConfigurationsKey;
    @JsonProperty
    private String clusterHealthCheckExclusionsKey;
    @JsonProperty
    private String featureFlagsKey;
    @JsonProperty
    private String additionalFilesKey;
    @JsonProperty
    private String druidConfigurationsKey;
    @JsonProperty
    private String coldTierClusterSizeDetailsKey;
    @JsonProperty
    private String projectSizeMapKey;
    @JsonProperty
    private String projectPlanListKey;
    @JsonProperty
    private String dataUnitTypeMapKey;
    @JsonProperty
    private String masterUnitTypeMapKey;
    @JsonProperty
    private String queryUnitTypeMapKey;
    @JsonProperty
    private String keycloakResourceSpecificationsKey;
    @JsonProperty
    private String druidRoleMappings;
    @JsonProperty
    private String licenseEntitlementsKey;
    @JsonProperty
    private PasswordProvider accessKey;
    @JsonProperty
    private PasswordProvider secretKey;
    @JsonProperty
    private String username;
    @JsonProperty
    private String password;

    @JsonCreator
    public RefreshableConstantsConfig(@JsonProperty(value="prefix") String prefix, @JacksonInject ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.prefix = prefix;
        this.implyVersionsKey = this.generateDefaultConfigPath("implyVersions");
        this.amiForRegionKey = this.generateDefaultConfigPath("amiForRegionVersioned");
        this.masterInstanceTypesKey = this.generateDefaultConfigPath("masterInstanceTypes");
        this.queryInstanceTypesKey = this.generateDefaultConfigPath("queryInstanceTypes");
        this.dataInstanceTypesKey = this.generateDefaultConfigPath("dataInstanceTypes");
        this.dbInstanceTypesKey = this.generateDefaultConfigPath("dbInstanceTypes");
        this.ingestInstanceTypesKey = this.generateDefaultConfigPath("ingestInstanceTypes");
        this.druidInstanceTypeConfigurationsKey = this.generateDefaultConfigPath("druidInstanceTypeConfigurationsVersioned");
        this.druidExtensionsKey = this.generateDefaultConfigPath("druidExtensions");
        this.pivotConfigurationsKey = this.generateDefaultConfigPath("pivotConfigurations");
        this.clusterHealthCheckExclusionsKey = this.generateDefaultConfigPath("clusterHealthCheckExclusions");
        this.featureFlagsKey = this.generateDefaultConfigPath("featureFlags");
        this.additionalFilesKey = this.generateDefaultConfigPath("additionalFiles");
        this.druidConfigurationsKey = this.generateDefaultConfigPath("druidConfigurations");
        this.coldTierClusterSizeDetailsKey = this.generateDefaultConfigPath("coldTierClusterSizeDetails");
        this.projectSizeMapKey = this.generateDefaultConfigPath("projectSizeMap");
        this.projectPlanListKey = this.generateDefaultConfigPath("projectPlanList");
        this.keycloakResourceSpecificationsKey = this.generateDefaultConfigPath("keycloakResourceSpecifications");
        this.druidRoleMappings = this.generateDefaultConfigPath("druidRoleMappings");
        this.licenseEntitlementsKey = this.generateDefaultConfigPath("licenseEntitlements");
        this.dataUnitTypeMapKey = this.generateDefaultConfigPath("dataUnitTypeMap");
        this.masterUnitTypeMapKey = this.generateDefaultConfigPath("masterUnitTypeMap");
        this.queryUnitTypeMapKey = this.generateDefaultConfigPath("queryUnitTypeMap");
    }

    public String getHttpRepositoryHost() {
        return this.httpRepositoryHost != null ? this.httpRepositoryHost : (this.applicationConfig.isDevelopmentMode() ? "https://s3.amazonaws.com/static.imply.io/onprem" : "https://static.imply.io/onprem");
    }

    public Map<String, String> getHttpQueryParams() {
        if (this.isSkipRefresh() && this.httpQueryParams != null) {
            HashMap<String, String> myHttpQueryParams = new HashMap<String, String>(this.httpQueryParams);
            myHttpQueryParams.put("refresh", "false");
            return myHttpQueryParams;
        }
        return this.httpQueryParams;
    }

    public Period getPeriod() {
        return this.period != null ? this.period : (this.applicationConfig.isOnPrem() ? new Period((Object)"PT15M") : new Period((Object)"PT5M"));
    }

    public String toString() {
        if (this.applicationConfig == null || this.applicationConfig.isOnPrem()) {
            return super.toString();
        }
        return new ToStringBuilder(this).append("s3Region", this.s3Region).append("s3Bucket", (Object)this.s3Bucket).append("httpRepositoryHost", (Object)this.httpRepositoryHost).append("httpQueryParams", this.httpQueryParams).append("skipRefresh", this.skipRefresh).append("httpTimeout", (Object)this.httpTimeout).append("period", (Object)this.getPeriod()).append("implyVersionsKey", (Object)this.getImplyVersionsKey()).append("amiForRegionKey", (Object)this.getAmiForRegionKey()).append("masterInstanceTypesKey", (Object)this.getMasterInstanceTypesKey()).append("queryInstanceTypesKey", (Object)this.getQueryInstanceTypesKey()).append("dataInstanceTypesKey", (Object)this.getDataInstanceTypesKey()).append("dbInstanceTypesKey", (Object)this.getDbInstanceTypesKey()).append("ingestInstanceTypesKey", (Object)this.getIngestInstanceTypesKey()).append("druidInstanceTypeConfigurationsKey", (Object)this.getDruidInstanceTypeConfigurationsKey()).append("druidExtensionsKey", (Object)this.getDruidExtensionsKey()).append("pivotConfigurationsKey", (Object)this.getPivotConfigurationsKey()).append("clusterHealthCheckExclusionsKey", (Object)this.getClusterHealthCheckExclusionsKey()).append("featureFlagsKey", (Object)this.getFeatureFlagsKey()).append("additionalFilesKey", (Object)this.getAdditionalFilesKey()).append("druidConfigurationsKey", (Object)this.getDruidConfigurationsKey()).append("coldTierClusterSizeDetailsKey", (Object)this.getColdTierClusterSizeDetailsKey()).append("projectSizeMapKey", (Object)this.getProjectSizeMapKey()).append("projectPlanListKey", (Object)this.getProjectPlanListKey()).append("keycloakResourceSpecificationsKey", (Object)this.getKeycloakResourceSpecificationsKey()).append("druidRoleMappings", (Object)this.getDruidRoleMappings()).append("licenseEntitlementsKey", (Object)this.getLicenseEntitlementsKey()).append("dataUnitTypeMapKey", (Object)this.getDataUnitTypeMapKey()).append("masterUnitTypeMapKey", (Object)this.getMasterUnitTypeMapKey()).append("queryUnitTypeMapKey", (Object)this.getQueryUnitTypeMapKey()).append("accessKey", (Object)this.accessKey).append("secretKey", (Object)"*****************").append("username", (Object)this.username).append("password", (Object)"*****************").toString();
    }

    private String generateDefaultConfigPath(String key) {
        return String.format("config/%s-%s.json", StringUtils.defaultIfBlank((CharSequence)this.prefix, (CharSequence)(this.applicationConfig.isDevelopmentMode() ? "local-dev" : "prod")), key);
    }

    @Generated
    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Generated
    public String getS3Region() {
        return this.s3Region;
    }

    @Generated
    public String getS3Bucket() {
        return this.s3Bucket;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public Integer getHttpTimeout() {
        return this.httpTimeout;
    }

    @Generated
    public boolean isSkipRefresh() {
        return this.skipRefresh;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getImplyVersionsKey() {
        return this.implyVersionsKey;
    }

    @Generated
    public String getAmiForRegionKey() {
        return this.amiForRegionKey;
    }

    @Generated
    public String getMasterInstanceTypesKey() {
        return this.masterInstanceTypesKey;
    }

    @Generated
    public String getQueryInstanceTypesKey() {
        return this.queryInstanceTypesKey;
    }

    @Generated
    public String getDataInstanceTypesKey() {
        return this.dataInstanceTypesKey;
    }

    @Generated
    public String getDbInstanceTypesKey() {
        return this.dbInstanceTypesKey;
    }

    @Generated
    public String getIngestInstanceTypesKey() {
        return this.ingestInstanceTypesKey;
    }

    @Generated
    public String getDruidInstanceTypeConfigurationsKey() {
        return this.druidInstanceTypeConfigurationsKey;
    }

    @Generated
    public String getDruidExtensionsKey() {
        return this.druidExtensionsKey;
    }

    @Generated
    public String getPivotConfigurationsKey() {
        return this.pivotConfigurationsKey;
    }

    @Generated
    public String getClusterHealthCheckExclusionsKey() {
        return this.clusterHealthCheckExclusionsKey;
    }

    @Generated
    public String getFeatureFlagsKey() {
        return this.featureFlagsKey;
    }

    @Generated
    public String getAdditionalFilesKey() {
        return this.additionalFilesKey;
    }

    @Generated
    public String getDruidConfigurationsKey() {
        return this.druidConfigurationsKey;
    }

    @Generated
    public String getColdTierClusterSizeDetailsKey() {
        return this.coldTierClusterSizeDetailsKey;
    }

    @Generated
    public String getProjectSizeMapKey() {
        return this.projectSizeMapKey;
    }

    @Generated
    public String getProjectPlanListKey() {
        return this.projectPlanListKey;
    }

    @Generated
    public String getDataUnitTypeMapKey() {
        return this.dataUnitTypeMapKey;
    }

    @Generated
    public String getMasterUnitTypeMapKey() {
        return this.masterUnitTypeMapKey;
    }

    @Generated
    public String getQueryUnitTypeMapKey() {
        return this.queryUnitTypeMapKey;
    }

    @Generated
    public String getKeycloakResourceSpecificationsKey() {
        return this.keycloakResourceSpecificationsKey;
    }

    @Generated
    public String getDruidRoleMappings() {
        return this.druidRoleMappings;
    }

    @Generated
    public String getLicenseEntitlementsKey() {
        return this.licenseEntitlementsKey;
    }

    @Generated
    public PasswordProvider getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public PasswordProvider getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }
}

