/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.config;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;

public class JsonConfigurator {
    @Generated
    private static final Logger log = Logger.from(JsonConfigurator.class);
    private final ObjectMapper jsonMapper;
    private final Validator validator;
    private final StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup((Map)ImmutableMap.of((Object)"sys", (Object)StringLookupFactory.INSTANCE.systemPropertyStringLookup(), (Object)"env", (Object)StringLookupFactory.INSTANCE.environmentVariableStringLookup(), (Object)"file", (Object)StringLookupFactory.INSTANCE.fileStringLookup()), StringLookupFactory.INSTANCE.environmentVariableStringLookup(), false)).setEnableSubstitutionInVariables(true);

    public <T> T configurate(Properties props, String propertyPrefix, Class<T> clazz) throws ProvisionException {
        Object config;
        JsonConfigurator.verifyClazzIsConfigurable(this.jsonMapper, clazz);
        Object propertyBase = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
        HashMap jsonMap = Maps.newHashMap();
        for (String prop : props.stringPropertyNames()) {
            Object value;
            if (!prop.startsWith((String)propertyBase)) continue;
            String propValue = this.stringSubstitutor.replace(props.getProperty(prop));
            try {
                String modifiedPropValue = propValue;
                if (!modifiedPropValue.startsWith("[") && !modifiedPropValue.startsWith("{")) {
                    modifiedPropValue = this.jsonMapper.writeValueAsString((Object)propValue);
                }
                value = this.jsonMapper.readValue(modifiedPropValue, Object.class);
            }
            catch (IOException e) {
                log.info(e, "Unable to parse [%s]=[%s] as a json object, using as is.", prop, propValue);
                value = propValue;
            }
            jsonMap.put(prop.substring(((String)propertyBase).length()), value);
        }
        try {
            config = this.jsonMapper.convertValue((Object)jsonMap, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new ProvisionException(String.format("Problem parsing object at prefix[%s]: %s.", propertyPrefix, e.getMessage()), (Throwable)e);
        }
        Set violations = this.validator.validate(config, new Class[0]);
        if (!violations.isEmpty()) {
            ArrayList messages = Lists.newArrayList();
            for (ConstraintViolation violation : violations) {
                Object path = "";
                try {
                    Class beanClazz = violation.getRootBeanClass();
                    for (Path.Node next : violation.getPropertyPath()) {
                        String pathPart;
                        if (next.getKind() != ElementKind.PROPERTY) continue;
                        String fieldName = next.getName();
                        Field theField = beanClazz.getDeclaredField(fieldName);
                        if (theField.getAnnotation(JacksonInject.class) != null) {
                            path = String.format(" -- Injected field[%s] not bound!?", fieldName);
                            break;
                        }
                        JsonProperty annotation = theField.getAnnotation(JsonProperty.class);
                        boolean noAnnotationValue = annotation == null || Strings.isNullOrEmpty((String)annotation.value());
                        String string = pathPart = noAnnotationValue ? fieldName : annotation.value();
                        if (((String)path).isEmpty()) {
                            path = (String)path + pathPart;
                            continue;
                        }
                        path = (String)path + "." + pathPart;
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                messages.add(String.format("%s - %s", path, violation.getMessage()));
            }
            throw new ProvisionException(Iterables.transform((Iterable)messages, (Function)new Function<String, Message>(){
                final /* synthetic */ String val$propertyBase;
                {
                    this.val$propertyBase = string;
                }

                public Message apply(String input) {
                    return new Message(String.format("%s%s", this.val$propertyBase, input));
                }
            }));
        }
        log.info("Loaded class[%s] from props[%s] as [%s]", clazz, propertyBase, config);
        return (T)config;
    }

    @VisibleForTesting
    public static <T> void verifyClazzIsConfigurable(ObjectMapper mapper, Class<T> clazz) {
        List beanDefs = mapper.getSerializationConfig().introspect(mapper.constructType(clazz)).findProperties();
        for (BeanPropertyDefinition beanDef : beanDefs) {
            AnnotatedField field = beanDef.getField();
            if (field != null && field.hasAnnotation(JsonProperty.class)) continue;
            throw new ProvisionException(String.format("JsonConfigurator requires Jackson-annotated Config objects to have field annotations. %s doesn't", clazz));
        }
    }

    @Inject
    @Generated
    public JsonConfigurator(ObjectMapper jsonMapper, Validator validator) {
        this.jsonMapper = jsonMapper;
        this.validator = validator;
    }
}

