/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.cache;

import com.google.common.base.Preconditions;
import io.imply.cloud.persistence.DeletedVisibility;
import java.util.Objects;

public class CacheKey {
    private static final String GLOBAL_NAMESPACE = "GLOBAL";
    public static final String ALL_RECORDS = "ALL";
    private final String namespace;
    private final Type type;
    private final String key;

    private CacheKey(String namespace, Type type, String key) {
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"namespace must not be null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must not be null"));
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key must not be null");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public CacheKey withNamespace(String namespace) {
        return new CacheKey(namespace, this.type, this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.namespace, cacheKey.namespace) && this.type == cacheKey.type && Objects.equals(this.key, cacheKey.key);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.type, this.key});
    }

    public String toString() {
        return String.format("%s:%s:%s", new Object[]{this.namespace, this.type, this.key});
    }

    public static CacheKey of(String namespace, Type type, String key) {
        return new CacheKey(namespace, type, key);
    }

    public static CacheKey of(Type type, String key) {
        return CacheKey.of(GLOBAL_NAMESPACE, type, key);
    }

    public static CacheKey of(String namespace, String key) {
        return CacheKey.of(namespace, Type.DEFAULT, key);
    }

    public static CacheKey of(String key) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.DEFAULT, key);
    }

    public static CacheKey account(String accountId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.ACCOUNT, accountId);
    }

    public static CacheKey cloudResources(String clusterId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLOUD_RESOURCES, clusterId);
    }

    public static CacheKey cluster(String clusterId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER, clusterId);
    }

    public static CacheKey cluster(String clusterId, DeletedVisibility deletedVisibility) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER, String.format("%s:%s", clusterId, Preconditions.checkNotNull((Object)((Object)deletedVisibility))));
    }

    public static CacheKey cluster(String clusterId, int version) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER, String.format("%s:%d", clusterId, version));
    }

    public static CacheKey clusterList(String accountId, DeletedVisibility deletedVisibility) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER_LIST, String.format("%s:%s", accountId, Preconditions.checkNotNull((Object)((Object)deletedVisibility))));
    }

    public static CacheKey clusterNodes(String clusterId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER_NODES, clusterId);
    }

    public static CacheKey clusterNodesList() {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.CLUSTER_NODES_LIST, ALL_RECORDS);
    }

    public static CacheKey entityState(String entityId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.ENTITY_STATE, entityId);
    }

    public static CacheKey instanceHealth(String key) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.INSTANCE_HEALTH, key);
    }

    public static CacheKey notifications(String entityKey) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.NOTIFICATIONS, entityKey);
    }

    public static CacheKey user(String userId) {
        return CacheKey.of(GLOBAL_NAMESPACE, Type.USER, userId);
    }

    public static enum Type {
        DEFAULT,
        ACCOUNT,
        CLOUD_RESOURCES,
        CLUSTER,
        CLUSTER_LIST,
        CLUSTER_NODES,
        CLUSTER_NODES_LIST,
        ENTITY_STATE,
        INSTANCE_HEALTH,
        NOTIFICATIONS,
        USER;

    }
}

