/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.cache;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.util.StringUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheExecutorFactory {
    COMMON_FJP{

        @Override
        public Executor createExecutor() {
            return ForkJoinPool.commonPool();
        }
    }
    ,
    SINGLE_THREAD{

        @Override
        public Executor createExecutor() {
            return Execs.singleThreaded("CaffeineWorker-%s");
        }
    }
    ,
    SAME_THREAD{

        @Override
        public Executor createExecutor() {
            return Runnable::run;
        }
    };


    public abstract Executor createExecutor();

    @JsonCreator
    public static CacheExecutorFactory from(String str) {
        return Enum.valueOf(CacheExecutorFactory.class, StringUtils.toUpperCase(str));
    }
}

