/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.LogviewEntry;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.druid.SecurityGroupRule;
import io.imply.cloud.tls.SubjectInfo;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class Constants {
    public static final String CLEAR_FIELD = "";
    public static final Integer CLEAR_FIELD_INT = -1;
    public static final DateTime CLEAR_FIELD_DATETIME = new DateTime(9999, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    public static final String SENSITIVE_FIELD_PLACEHOLDER = "{secret}";
    public static final String INFO_STATUS_KEY = "status";
    public static final String INFO_STATUS_REASON_KEY = "statusReason";
    public static final String INFO_STACK_OUTPUTS_KEY = "outputs";
    public static final String INFO_CLOUDWATCH_LOG_GROUP_KEY = "logGroupName";
    public static final String INFO_HOSTS_QUERY_ELB_EXTERNAL_KEY = "queryExternal";
    public static final String INFO_HOSTS_QUERY_ELB_INTERNAL_KEY = "queryInternal";
    public static final String INFO_URLS_UNMANAGED_SECURITY_GROUP_CONSOLE = "unmanagedSecurityGroupConsole";
    public static final String INFO_URLS_ELB_SECURITY_GROUP_CONSOLE = "elbSecurityGroupConsole";
    public static final String INFO_URLS_VPC_CONSOLE = "vpcConsole";
    public static final String INFO_URLS_CLOUD_WATCH_LOGS_CONSOLE = "cloudWatchLogsConsole";
    public static final String INFO_CONTEXT_REQUEST_ID_KEY = "requestId";
    public static final String INFO_CONTEXT_PARENT_SPAN_ID_KEY = "parentSpanId";
    public static final String INFO_CONTEXT_SPAN_ID_KEY = "spanId";
    public static final String INFO_CONTEXT_REQUESTER_ID_KEY = "requesterId";
    public static final String INFO_CONTEXT_IS_MOCK_KEY = "isMock";
    public static final String INFO_CONTEXT_MOCK_BEHAVIOR_KEY = "mockBehavior";
    public static final String INFO_CONTEXT_NAME = "name";
    public static final String UPLOAD_KEY_PREFIX = "uploads";
    public static final int UPLOAD_SIGNED_URL_EXPIRY_IN_MINUTES = 120;
    public static final String INFO_STATUS_MESSAGE_UNEXPECTED_ERROR_VALUE = "Unexpected error";
    public static final String INFO_STATUS_MESSAGE_CONTACT_SUPPORT_VALUE = "Unable to complete operation, please contact support";
    public static final String INFO_STATUS_MESSAGE_UNEXPECTED_AWS_DESCRIBE_STACK_RESPONSE_VALUE = "Could not retrieve stack details from AWS";
    public static final int NUM_STARTING_RESERVED_IP_ADDRESSES_IN_SUBNET = 4;
    public static final int AVAILABLE_IP_ADDRESSES_IN_SUBNET = 251;
    public static final int REFRESH_CF_STATUS_PERIOD_IN_SECONDS = 120;
    public static final int FREQUENT_REFRESH_CF_STATUS_PERIOD_IN_SECONDS = 15;
    public static final int RUNNING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 225;
    public static final int UPDATING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 105;
    public static final int FAILING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 105;
    public static final int NEW_INSTANCE_HEALTH_CHECK_GRACE_PERIOD_IN_SECONDS = 180;
    public static final int MAX_INSTANCE_FAILURES = 5;
    public static final int TERMINATE_INSTANCE_FREQUENT_REFRESH_DURATION_IN_MINUTES = 5;
    public static final int CF_CLUSTER_STACK_CREATION_TIMEOUT_IN_MINUTES = 90;
    public static final int CF_NETWORK_STACK_CREATION_TIMEOUT_IN_MINUTES = 30;
    public static final int FUTURE_TIMEOUT_IN_SECONDS = 60;
    public static final int DEFAULT_RETRY_DELAY_IN_SECONDS = 5;
    public static final int DEFAULT_NUM_RETRIES = 5;
    public static final int NUM_RETRIES_FOR_AUTO_SCALING_GROUP_STAGES = 10;
    public static final int DEFAULT_UPDATE_STAGE_COMPLETION_TIMEOUT_IN_MINUTES = 30;
    public static final int DEFAULT_UPDATE_STAGE_EXECUTION_DELAY_IN_SECONDS = 0;
    public static final int DELETED_ENTITY_RECENT_PERIOD_IN_MINUTES = 720;
    public static final ComparableVersion MIN_IMPLY_VERSION_CONFIGURABLE_PIVOT = new ComparableVersion("3.3.1");
    public static final ComparableVersion MIN_IMPLY_VERSION_CACHE_MONITORING = new ComparableVersion("3.3");
    public static final ComparableVersion MIN_IMPLY_VERSION_TASK_SLOT_COUNT_STATS_MONITOR = new ComparableVersion("4.0");
    public static final ComparableVersion MIN_IMPLY_VERSION_OSHI_MONITOR = new ComparableVersion("2023.07.0");
    public static final ComparableVersion MIN_IMPLY_VERSION_CGROUP_MONITOR = new ComparableVersion("2024.06.0");
    public static final ComparableVersion MIN_IMPLY_VERSION_CGROUP_V2_MONITOR = new ComparableVersion("2024.09.1");
    public static final ComparableVersion MIN_IMPLY_VERSION_SEGMENT_STATS_MONITOR = new ComparableVersion("2022.06.3");
    public static final ComparableVersion MIN_IMPLY_VERSION_BUNDLED_CONTINUOUS_PROFILING = new ComparableVersion("2024.05");
    public static final ComparableVersion MIN_IMPLY_VERSION_VERSIONLESS_CONTINUOUS_PROFILING = new ComparableVersion("2024.09");
    public static final ComparableVersion MIN_IMPLY_VERSION_SERVICE_STATUS_MONITOR_NON_POLARIS = new ComparableVersion("2024.04");
    public static final ComparableVersion MIN_IMPLY_VERSION_SERVICE_STATUS_MONITOR_POLARIS = new ComparableVersion("2023.06.1");
    public static final Period DEFAULT_TRANSITION_STATE_TIMEOUT = new Period((Object)"PT90M");
    public static final String ANONYMOUS_ID = "ANONYMOUS";
    public static final String SUPER_PRINCIPAL_ID = "SUPER_PRINCIPAL";
    public static final String UPDATED_BY_SYSTEM_ROLLBACK = "SYSTEM_ROLLBACK";
    public static final String UPDATED_BY_SYSTEM_SECURITY = "SYSTEM_SECURITY";
    public static final String UPDATED_BY_SYSTEM_DEFAULTS = "SYSTEM_DEFAULTS";
    public static final String UPDATED_BY_SYSTEM_AGENT_UPDATE = "SYSTEM_AGENT";
    public static final String REQUEST_ID_HTTP_RESPONSE_HEADER = "X-Request-ID";
    public static final String PARENT_SPAN_ID_HTTP_RESPONSE_HEADER = "X-B3-ParentSpanId";
    public static final String USER_ID_HTTP_RESPONSE_HEADER = "X-User-ID";
    public static final String FORWARDED_PATH_REQUEST_HEADER = "X-Forwarded-Path";
    public static final String CONTENT_TYPE_REQUEST_HEADER = "Content-Type";
    public static final String MERGE_PATCH_JSON_CONTENT_TYPE = "application/merge-patch+json";
    public static final String DRUID_AUDIT_AUTHOR_REQUEST_HEADER = "X-Druid-Author";
    public static final String DRUID_AUDIT_COMMENT_REQUEST_HEADER = "X-Druid-Comment";
    public static final int DEFAULT_MASTER_INSTANCE_COUNT = 3;
    public static final int DEFAULT_QUERY_INSTANCE_COUNT = 1;
    public static final int DEFAULT_DATA_INSTANCE_COUNT = 1;
    public static final int DEFAULT_LOG_RETENTION_IN_DAYS = 14;
    public static final int DEFAULT_DB_SIZE_GB = 20;
    public static final int DEFAULT_DB_BACKUP_RETENTION_DAYS = 14;
    public static final Pattern S3_LOCATION_PATTERN = Pattern.compile("^s3://([a-z0-9][a-z0-9-.]*)(?:/(.*?)/?)?$", 2);
    public static final Pattern INTERPOLATION_VARIABLE_PATTERN = Pattern.compile("@\\{([A-Z_0-9]+)\\}");
    public static final Pattern S3_LOCATION_PATTERN_KEY_REQUIRED = Pattern.compile("^s3://([a-z0-9][a-z0-9-.]*)/(.+)$", 2);
    public static final Pattern GCS_LOCATION_PATTERN = Pattern.compile("^gs://([a-z0-9][a-z0-9-_.]*)(?:/(.*?)/?)?$", 2);
    public static final Pattern AZURE_LOCATION_PATTERN = Pattern.compile("^azure://([a-z0-9][a-z0-9-.]*)(?:/(.*?)/?)?$");
    public static final Pattern AZURE_DNS_ZONE_PATTERN = Pattern.compile("^z(0[0-9]|[1-9][0-9])$");
    public static final Pattern UPLOAD_KEY_PATTERN = Pattern.compile("^[a-z0-9_!\\-'()*.]+$", 2);
    public static final Pattern IAM_ROLE_ARN_PATTERN = Pattern.compile("^(arn:aws:iam::[0-9]+:role/).*$", 2);
    public static final Pattern CIDR_BLOCK_PATTERN = Pattern.compile("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+/(2[0-8]|1[6-9])$", 2);
    public static final Pattern AWS_ACCOUNT_ID_PATTERN = Pattern.compile("arn:aws:iam::([0-9]*).*", 2);
    public static final Pattern DOMAIN_PATTERN = Pattern.compile("^[a-z0-9][a-z0-9-]*?[a-z0-9]$", 2);
    public static final String IMPERSONATED_USER_ID_DELIMITER = " -> ";
    public static final Pattern IMPERSONATED_USER_ID_PATTERN = Pattern.compile("(.*) -> (.*)");
    public static final String IMPERSONATED_USER_ID_FORMATTER = "%s -> %s";
    public static final String DRUID_AUDIT_AUTHOR_SYSTEM_PREFIX = "[Imply Cloud System]";
    public static final List<String> SUPPORTED_TARBALL_EXTENSIONS = ImmutableList.of((Object)".tar", (Object)".tar.gz", (Object)".tgz", (Object)".tar.bz2", (Object)".tbz2", (Object)".tar.xz", (Object)".txz", (Object)".tar.lzma", (Object)".tlzma");
    public static final int COORDINATOR_PORT = 8081;
    public static final int OVERLORD_PORT = 8090;
    public static final int MIDDLE_MANAGER_PORT = 8091;
    public static final int HISTORICAL_PORT = 8083;
    public static final int BROKER_PORT = 8082;
    public static final int ROUTER_PORT = 8888;
    public static final int COORDINATOR_PORT_TLS = 8281;
    public static final int OVERLORD_PORT_TLS = 8290;
    public static final int MIDDLE_MANAGER_PORT_TLS = 8291;
    public static final int HISTORICAL_PORT_TLS = 8283;
    public static final int BROKER_PORT_TLS = 8282;
    public static final int ROUTER_PORT_TLS = 9088;
    public static final int PIVOT_PORT = 9095;
    public static final int ROLL_TIME_PLACEHOLDER = 999;
    public static final int UNKNOWN_UPDATE_TIME = Integer.MAX_VALUE;
    public static final int CLUSTER_MONITORING_ROLLING_UPDATE_TIME_MINUTES = 5;
    public static final int CLUSTER_MONITORING_UTILIZATION_THRESHOLD_PERCENTAGE = 80;
    public static final String STATUS_ENDPOINT = "/status";
    public static final String DRUID_HEALTH_ENDPOINT = "/status/health";
    public static final String PIVOT_HEALTH_ENDPOINT = "/health";
    public static final String COORDINATOR_DYNAMIC_CONFIG_ENDPOINT = "/druid/coordinator/v1/config";
    public static final String COORDINATOR_SERVER_LIST_ENDPOINT = "/druid/coordinator/v1/servers";
    public static final String COORDINATOR_LOAD_STATUS_ENDPOINT = "/druid/coordinator/v1/loadstatus";
    public static final String COORDINATOR_CLONE_STATUS_ENDPOINT = "/druid/coordinator/v1/config/cloneStatus";
    public static final String COORDINATOR_DATASOURCES_ENDPOINT = "/druid/coordinator/v1/datasources";
    public static final String COORDINATOR_COMPACTION_CONFIG_ENDPOINT = "/druid/coordinator/v1/config/compaction/taskslots";
    public static final String COORDINATOR_LOAD_RULES_ENDPOINT = "/druid/coordinator/v1/rules";
    public static final String COORDINATOR_SYNCED_BROKERS_ENDPOINT = "/druid/coordinator/v1/config/syncedBrokers";
    public static final String COORDINATOR_CATALOG_SCHEMA_LIST_ENDPOINT = "/druid/coordinator/v1/catalog/schemas";
    public static final String COORDINATOR_CATALOG_TABLE_LIST_ENDPOINT = "/druid/coordinator/v1/catalog/schemas/%s/tables";
    public static final String COORDINATOR_CATALOG_TABLES_ENDPOINT = "/druid/coordinator/v1/catalog/schemas/%s/tables/%s";
    public static final String OVERLORD_TASK_LIST_ENDPOINT = "/druid/indexer/v1/tasks";
    public static final String OVERLORD_TASK_PAYLOAD_ENDPOINT = "/druid/indexer/v1/task/%s";
    public static final String OVERLORD_SUPERVISOR = "/druid/indexer/v1/supervisor";
    public static final String OVERLORD_SUPERVISOR_HANDOFF_ENDPOINT = "/druid/indexer/v1/supervisor/%s/taskGroups/handoff";
    public static final String OVERLORD_WORKER_LIST_ENDPOINT = "/druid/indexer/v1/workers";
    public static final String OVERLORD_DYNAMIC_CONFIG_ENDPOINT = "/druid/indexer/v1/worker";
    public static final String MIDDLE_MANAGER_TASK_LIST_ENDPOINT = "/druid/worker/v1/tasks";
    public static final String MIDDLE_MANAGER_DISABLE_ENDPOINT = "/druid/worker/v1/disable";
    public static final String MIDDLE_MANAGER_ENABLE_ENDPOINT = "/druid/worker/v1/enable";
    public static final String DRUID_SQL_QUERY_ENDPOINT = "/druid/v2/sql";
    public static final String COORDINATOR_CONFIG_MAX_SEGMENTS_TO_MOVE_KEY = "maxSegmentsToMove";
    public static final int COORDINATOR_CONFIG_MAX_SEGMENTS_TO_MOVE_DURING_UPDATE = 200;
    public static final String COORDINATOR_CONFIG_REPLICATION_THROTTLE_LIMIT_KEY = "replicationThrottleLimit";
    public static final int COORDINATOR_CONFIG_REPLICATION_THROTTLE_LIMIT_DURING_UPDATE = 2000;
    public static final String COORDINATOR_CONFIG_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE_KEY = "maxSegmentsInNodeLoadingQueue";
    public static final int COORDINATOR_CONFIG_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE_DURING_UPDATE = 500;
    public static final String COORDINATOR_SMART_SEGMENT_LOADING_KEY = "smartSegmentLoading";
    public static final String COORDINATOR_CONFIG_KILL_TASK_SLOT_RATIO = "killTaskSlotRatio";
    public static final String COORDINATOR_CONFIG_MAX_KILL_TASK_SLOTS = "maxKillTaskSlots";
    public static final String DECOMMISSIONING_NODES = "decommissioningNodes";
    public static final String CLONE_SERVERS = "cloneServers";
    public static final String TURBO_LOADING_NODES = "turboLoadingNodes";
    public static final String DRUID_SERVER_TIER_DEFAULT = "_default_tier";
    public static final Integer DRUID_SERVER_TIER_PRIORITY_DEFAULT = 0;
    public static final Integer DRUID_INSTANCE_POOL_DEFAULT = 1;
    public static final Integer HTTP_CLIENT_TIMEOUT_IN_SECONDS = 35;
    public static final long GROVE_CLIENT_DEFAULT_TIMEOUT_IN_SECONDS = 10L;
    public static final Integer GROVE_REPO_DEFAULT_TIMEOUT_IN_SECONDS = 5;
    public static final long METRICS_EXT_CLIENT_TIMEOUT_IN_SECONDS = 30L;
    public static final long IMPLY_TELEMETRY_CLIENT_TIMEOUT_IN_SECONDS = 30L;
    public static final String EC2_TERMINATED_STATE = "terminated";
    public static final String SYSTEM_CONTEXT_EXPECTED_DATA_TIER_1_NODES_KEY = "expectedDataTier1Nodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_DATA_TIER_2_NODES_KEY = "expectedDataTier2Nodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_DATA_TIER_3_NODES_KEY = "expectedDataTier3Nodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_QUERY_NODES_KEY = "expectedQueryNodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_MASTER_NODES_KEY = "expectedMasterNodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_COLD_TIER_SIZE_KEY = "expectedColdTierSize";
    public static final String SYSTEM_CONTEXT_EXPECTED_COLD_QUERY_NODES_KEY = "expectedColdTierQueryNodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_COLD_DATA_NODES_KEY = "expectedColdTierDataNodes";
    public static final String SYSTEM_CONTEXT_EXPECTED_INSTANCE_ID_KEY = "expectedInstanceId";
    public static final String SYSTEM_CONTEXT_MOCK_ROLLBACK_IDS = "mockRollbackIds";
    public static final String MAGIC_REAL_TAG = "imply_real_";
    public static final String MAGIC_MOCK_TAG = "imply_mock_";
    public static final String USER_CONTEXT_FORCE_DELETE_KEY = "forceDelete";
    public static final String USER_CONTEXT_SKIP_CLOUD_FORMATION_STACK_KEY = "skipCloudFormationStack";
    public static final String USER_CONTEXT_IMPERSONATOR = "impersonator";
    public static final String USER_CONTEXT_REQUEST_ID = "requestId";
    public static final String USE_SUPERVISE_LEGACY_SVLOGD_MAX_VERSION = "99.99";
    public static final String MIN_IMPLY_VERSION_LOG_VIEW_SUPPORTED_ON_CLOUD = "3.3.1";
    public static final String SYSTEM_REQUESTER_ID = "SYSTEM";
    public static final String IMPLY_TOKEN_HEADER = "Imply-Token";
    public static final String IMPLY_HMAC_HEADER = "Imply-HMAC";
    public static final String IMPLY_TOKEN_USER = "IMPLY_CLOUD_BACKEND";
    public static final int IMPLY_TOKEN_EXPIRATION_IN_MINUTES = 60;
    public static final int IMPLY_TOKEN_MINUTES_BEFORE_EXPIRY_TO_REFRESH = 20;
    public static final ComparableVersion EARLIEST_VERSION_MONITORS_IN_DRUID_PACKAGE = new ComparableVersion("2.5.0-SNAPSHOT");
    public static final ComparableVersion EARLIEST_VERSION_APACHE_PACKAGING = new ComparableVersion("2.8.0");
    public static final List<SecurityGroupRule> SECURITY_GROUP_RULES = ImmutableList.builder().add((Object)SecurityGroupRule.of(8090, 8091, "tcp")).add((Object)SecurityGroupRule.of(8281, 8283, "tcp")).add((Object)SecurityGroupRule.of(8290, 8291, "tcp")).add((Object)SecurityGroupRule.of(9088, 9088, "tcp")).add((Object)SecurityGroupRule.of(9095, 9095, "tcp")).add((Object)SecurityGroupRule.of(9994, 9994, "tcp")).add((Object)SecurityGroupRule.of(22, 22, "tcp")).build();
    public static final SubjectInfo BASE_SUBJECT_INFO = new SubjectInfo(null, "US", "California", "Burlingame", "Imply Data, Inc.");
    public static final String UPDATE_TEXT_2_9_17_TO_3_0_0 = "NOTE: Although this update can be performed without any disruption to Druid, due to changes in Pivot's update mechanism, Pivot may become unavailable while upgrading from a version earlier than 2.9.18 to 3.0.0+. To perform a rolling update without interruption to Pivot, please upgrade to 2.9.18 first.";
    public static final String FEATURE_FLAG_TAGS_SUPPORTED = "tagsSupported";
    public static final String FEATURE_FLAG_AUTO_TAG = "_implyInternalAutoTag_";
    public static final String FEATURE_FLAG_MONITORING_SUPPORTED = "monitoringSupported";
    public static final String FEATURE_FLAG_USE_LAUNCH_TEMPLATES = "useLaunchTemplates";
    public static final String FEATURE_FLAG_PROCESSOR_HOURS_SUPPORTED = "processorHoursSupported";
    public static final String FEATURE_FLAG_INTERNAL_IMPLY_INSTANCE_DEFAULT = "_implyInternalInstanceDefaults_";
    public static final String FEATURE_FLAG_USE_MARIADB_CONNECTOR = "useMariaDBConnector";
    public static final String FEATURE_FLAG_USE_EARLY_HANDOFF_API = "useEarlyHandoffAPI";
    public static final ComparableVersion MIN_IMPLY_VERSION_WITH_MARIADB_CONNECTOR = new ComparableVersion("2021.09");
    public static final String FEATURE_FLAG_AUTO_GENERATE_IMPLY_LICENSE = "autoGenerateImplyLicense";
    public static final String FEATURE_FLAG_AZURE_MARKETPLACE_ACCOUNT = "azureMarketplaceAccount";
    public static final String FEATURE_FLAG_AWS_MARKETPLACE_ACCOUNT = "awsMarketplaceAccount";
    public static final List<String> DEFAULT_ACCOUNT_FEATURE_FLAGS = ImmutableList.of((Object)"tagsSupported", (Object)"processorHoursSupported", (Object)"useLaunchTemplates");
    public static final String FEATURE_FLAG_DISABLE_GROVE_SERVER = "disableGroveServer";
    public static final int ZK_EBS_SIZE_GB = 16;
    public static final String IMPLY_CLOUD_REPOSITORY = "s3://imply-cloud/public";
    public static final String RDS_MYSQL_ENGINE_VERSION = "8.0";
    public static final int MAX_INSTANCE_PROTECTION_SIZE = 50;
    public static final long NOTICE_AWAITING_ACTION_TIMEOUT_MS = 20000L;
    public static final String ON_PREM_ACCOUNT_ID = "onprem";
    public static final String ON_PREM_INSTANCE_TYPE = "onprem";
    public static final String CONFIG_SERVER_REQUEST_PAYLOAD_PATH = "/opt/imply/onprem/conf/config-server.json";
    public static final String RUN_DRUID_SCRIPT_PATH = "bin/run-druid";
    public static final String RUN_PIVOT_SCRIPT_PATH = "bin/run-pivot";
    public static final String CONFIG_FILE_BASE_PATH = "/opt/imply/conf";
    public static final String IMPLY_NODE_TYPES_DELIMITER = "/";
    public static final String IMPLY_RUNIT_SERVICE_NAME = "imply";
    public static final String GROVE_SERVER_HOST_PLACEHOLDER = "@MANAGER_REPO_HOST";
    public static final String GROVE_SERVER_REPOSITORY_PATH = "repo/";
    public static final String GROVE_SERVER_REMOTE_REPOSITORY_OVERRIDE_PARAM = "repo";
    public static final String GROVE_SERVER_SCHEME = "manager";
    public static final int GROVE_SERVER_NODE_CHUNK_SIZE = 10;
    public static final String GROVE_METADATA_CLUSTER_ID = "clusterId";
    public static final String GROVE_METADATA_NODE_TYPES = "nodeTypes";
    public static final String GROVE_METADATA_NODE_TIER = "nodeTier";
    public static final int GROVE_AGENT_CATTLE_REMOVAL_TIMEOUT_IN_SECONDS = 60;
    public static final int GROVE_AGENT_CATTLE_REAP_FROM_GROVE_TIMEOUT_IN_HOURS = 12;
    public static final String GROVE_DEPLOY_METADATA_IMPLY_BUNDLE_ID = "implyBundleId";
    public static final String GROVE_DEPLOY_METADATA_IMPLY_VERSION = "implyVersion";
    public static final String GROVE_DEPLOY_METADATA_IMPLY_NODE_TYPES = "implyNodeTypes";
    public static final String GROVE_DEPLOY_METADATA_CLUSTER_ID = "clusterId";
    public static final String GROVE_DEPLOY_METADATA_CLUSTER_VERSION = "clusterVersion";
    public static final String IMPLY_MANAGER_HOST_PLACEHOLDER = "@{IMPLY_MANAGER_HOST}";
    public static final String IMPLY_MANAGER_PORT_PLACEHOLDER = "@{IMPLY_MANAGER_BE_PORT}";
    public static final String IMPLY_MANAGER_AUTH_TOKEN_PLACEHOLDER = "@{IMPLY_MANAGER_AUTH_TOKEN}";
    public static final String IMPLY_AGENT_IP_ADDRESS_PLACEHOLDER = "@{IMPLY_AGENT_IP_ADDRESS}";
    public static final String IMPLY_AGENT_HOSTNAME_PLACEHOLDER = "@{IMPLY_AGENT_FQDN}";
    public static final String CONFIG_RESOURCE_BASE_PATH = "/config/v1";
    public static final String CONFIG_RESOURCE_BUNDLE_ENDPOINT = "config-bundle";
    public static final String CONFIG_RESOURCE_PEON_BUNDLE_ENDPOINT = "peon-configs";
    public static final String CONFIG_RESOURCE_GROVE_INIT_ENDPOINT = "grove-init";
    public static final String CONFIG_RESOURCE_LOGVIEW_ENDPOINT = "logview";
    public static final String CONFIG_RESOURCE_EXTENDED_USER_FILES_ENDPOINT = "user-files-x";
    public static final String AUTH_RESOURCE_BASE_PATH = "/auth/v1";
    public static final String AUTH_RESOURCE_KEYSTORE_ENDPOINT = "keystore";
    public static final String AUTH_RESOURCE_TRUSTSTORE_ENDPOINT = "truststore";
    public static final String CONFIG_BUNDLE_BASE_PATH = "/opt/imply/conf";
    public static final String METADATA_STORE_TRUSTSTORE_REL_PATH = "druid/_common/metadata-truststore.jks";
    public static final String METADATA_STORE_TRUSTSTORE_PASSWORD = "implymanager";
    public static final String METADATA_STORE_KEYSTORE_REL_PATH = "druid/_common/metadata-keystore.jks";
    public static final String METADATA_STORE_KEYSTORE_PASSWORD = "implymanager";
    public static final String METADATA_STORE_CA_PEM_REL_PATH = "druid/_common/metadata-store.pem";
    public static final String METADATA_STORE_CLIENT_CERT_PEM_REL_PATH = "druid/_common/metadata-store-client-cert.pem";
    public static final String METADATA_STORE_CLIENT_KEY_PK8_REL_PATH = "druid/_common/metadata-store-client-key.pk8";
    public static final String RDS_METADATA_STORE_TRUSTSTORE_REL_PATH = "druid/_common/rds-truststore.jks";
    public static final String RDS_METADATA_STORE_TRUSTSTORE_PASSWORD = "xGgFiYP5TuCeKAFWbSJ5vA";
    public static final String DRUID_ROLE_MAPPING_PATH = "druid/_common/roles.json";
    public static final String ONPREM_KUBERNETES_BECOME_DRUID_SCRIPT_PATH = "/root/become-druid";
    public static final int ONPREM_RUNNING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 110;
    public static final int ONPREM_UPDATING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 50;
    public static final int ONPREM_FAILING_INSTANCE_HEALTH_CHECK_PERIOD_IN_SECONDS = 50;
    public static final LogviewEntry LOGVIEW_COORDINATOR = LogviewEntry.of("coordinator", "/mnt/var/sv/coordinator/current", ServiceType.COORDINATOR, "The coordinator is responsible for segment management and distribution", (Integer)100);
    public static final LogviewEntry LOGVIEW_OVERLORD = LogviewEntry.of("overlord", "/mnt/var/sv/overlord/current", ServiceType.OVERLORD, "The overlord is responsible for coordination and management of indexing tasks", (Integer)90);
    public static final LogviewEntry LOGVIEW_BROKER = LogviewEntry.of("broker", "/mnt/var/sv/broker/current", ServiceType.BROKER, "The broker accepts queries, issues subqueries to historicals, and merges the results to return a response to the client", (Integer)70);
    public static final LogviewEntry LOGVIEW_ROUTER = LogviewEntry.of("router", "/mnt/var/sv/router/current", ServiceType.ROUTER, "The router intelligently forwards queries and API requests to the appropriate service and serves the Druid Console", (Integer)50);
    public static final LogviewEntry LOGVIEW_PIVOT = LogviewEntry.of("pivot", "/mnt/var/sv/pivot/current", ServiceType.PIVOT, "Imply's Druid-optimized drag and drop UI for intuitive and interactive data exploration", (Integer)40);
    public static final LogviewEntry LOGVIEW_HISTORICAL = LogviewEntry.of("historical", "/mnt/var/sv/historical/current", ServiceType.HISTORICAL, "The historical service manages a subset of segments and is responsible for answering subqueries on its slice of data", (Integer)80);
    public static final LogviewEntry LOGVIEW_MM = LogviewEntry.of("middle-manager", "/mnt/var/sv/middleManager/current", ServiceType.MIDDLE_MANAGER, "The middle manager receives indexing assignments from the overlord and spawns child processes to ingest data into segments", (Integer)60);
    public static final LogviewEntry LOGVIEW_INDEXER = LogviewEntry.of("indexer", "/mnt/var/sv/indexer/current", ServiceType.INDEXER, "The indexer receives indexing assignments from the overlord and runs worker threads to ingest data into segments", (Integer)60);
    public static final LogviewEntry LOGVIEW_COLD_BROKER = LogviewEntry.of("cold-broker", "/mnt/var/sv/coldBroker/current", ServiceType.COLD_BROKER, "The cold broker accepts queries, issues subqueries to cold historicals, and merges the results to return a response to the client", (Integer)60);
    public static final LogviewEntry LOGVIEW_COLD_HISTORICAL = LogviewEntry.of("cold-historical", "/mnt/var/sv/coldHistorical/current", ServiceType.COLD_HISTORICAL, "The cold historical service manages a subset of segments and is responsible for answering subqueries on its slice of data", (Integer)60);
    public static final LogviewEntry LOGVIEW_CFN_INIT = LogviewEntry.of("cfn-init", "/var/log/cfn-init.log", "CloudFormation Init", "Runs when an EC2 instance starts up and mounts volumes, configures networking, fetches configurations, and starts Imply services", (Integer)5);
    public static final LogviewEntry LOGVIEW_IMPLY = LogviewEntry.of("imply", "/etc/service/imply/log/main/current", "Imply Supervise", "A supervision service that manages the lifecycle of Imply services", (Integer)10);
    public static final LogviewEntry LOGVIEW_GROVE = LogviewEntry.of("grove", "/etc/service/grove-agent/log/main/current", "Grove", "An orchestration agent used to receive pushed distributions and configurations, and manage the registration and state of services", (Integer)30);
    public static final LogviewEntry LOGVIEW_ZK = LogviewEntry.of("zk", "/etc/service/zk-server/log/main/current", "ZooKeeper", "A highly-available service for maintaining configuration information and providing distributed synchronization", (Integer)20);
    public static final LogviewEntry LOGVIEW_GROVE_BECOME = LogviewEntry.of("grove-become", "/var/log/grove-become.log", "Imply Init", "An agent used to receive pushed distributions and configurations, and manage the registration and state of services", (Integer)6);
    public static final String DEFAULT_INDEXER_LOGS_PREFIX = "indexing-logs";
    public static final String DEFAULT_SEGMENTS_PREFIX = "segments";
    public static final String DEFAULT_MSQE_DURABLE_STORAGE_PREFIX = "msqe-durable-storage";
    public static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    public static final String MANAGER_SERVICE_CLIENT = "imply-manager-service";
    public static final String DRUID_AUTHENTICATOR_CLIENT = "imply-druid-authenticator";
    public static final String DRUID_SERVICE_CLIENT = "imply-druid-service";
    public static final String PIVOT_AUTHENTICATOR_CLIENT = "imply-pivot-authenticator";
    public static final String PIVOT_SERVICE_CLIENT = "imply-pivot-service";
    public static final String DRUID_DATA_PLANE_AGENT_CLIENT = "imply-data-plane-agent";
    public static final String PIVOT_CONFIG_LINK_HOST_NAME = "linkHostName";
    public static final String PIVOT_CONFIG_USER_MODE = "userMode";
    public static final String MM_INGEST_INSTANCE_TYPE = "ingest";
    public static final String HIGH_MEM_SERVER_TYPE = "ingest-local-disk-high-mem";
    public static final String HIGH_MEM_INGEST_INSTANCE_TYPE = "peon-large";
    public static final String DEFAULT_PEON_TEMPLATE_NAME = "base";
    public static final Integer DEFAULT_PEON_TEMPLATE_TIER = 0;
    public static final String ARCHITECTURE_NODE_SELECTOR = "imply.io/arch";
    public static final String ARM_NODE_LABEL = "arm64";
    public static final String IMPLY_NODE_TYPE_LABEL = "imply.io/imply_node_type";
    public static final String IMPLY_INSTANCE_TYPE_ANNOTATION = "imply.io/imply_instance_type";
    public static final String IMPLY_NODE_SERVICE_TYPE_LABEL = "imply.io/imply_service_type";
    public static final String WORKER_VERSION_LABEL = "imply.io/worker_version";
    public static final String RELEASE_SELECTOR_LABEL = "app.kubernetes.io/instance";
    public static final String NAME_SELECTOR_LABEL = "app.kubernetes.io/name";
    public static final String SAAS_CLUSTER_ROLE_NAME = "imply-cluster-%s";
    public static final String SAAS_CLUSTER_ROLE_DESCRIPTION = "Role for imply cluster %s to access AWS resources.";
    public static final String SAAS_PROJECT_SIZE_CUSTOM = "custom";
    public static final String AGENT_IMAGE = "v40";
    public static final String PD_INSTANCE_TYPE_SUFFIX = "-pd";
    public static final Integer DEFAULT_VOLUME_SIZE_GB = 375;
    public static final long POLARIS_INGEST_OVERHEAD_GB = 10L;
    public static final String AZURE_WORKLOAD_IDENTITY_POD_LABEL = "azure.workload.identity/use";
    public static final String AZURE_WORKLOAD_IDENTITY_SERVICEACCOUNT_ANNOTATION = "azure.workload.identity/client-id";
    public static final String AWS_ROLE_ARN_SERVICEACCOUNT_ANNOTATION = "eks.amazonaws.com/role-arn";
    public static final String VALIDATION_CONTAINER_NAME_FORMAT = "validation-%s-%s";
    public static final String KAFKA_TASK_TYPE = "index_kafka";
    public static final String KINESIS_TASK_TYPE = "index_kinesis";
    public static final String LD_PRELOAD = "LD_PRELOAD";
    public static final String JEMALLOC_LOCATION = "libjemalloc.so.2";
    public static final String MALLOC_CONF = "MALLOC_CONF";
    public static final String NARENAS_FORMAT = "narenas:%d";
    public static final long B_PER_GB = 1000000000L;

    public static boolean hasMagicRealTag(String entityId) {
        return entityId != null && entityId.startsWith(MAGIC_REAL_TAG);
    }

    public static boolean hasMagicMockTag(String entityId) {
        return entityId != null && entityId.startsWith(MAGIC_MOCK_TAG);
    }
}

