/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.jackson.DefaultObjectMapper;
import io.imply.cloud.model.BillingEntry;
import io.imply.cloud.model.BillingState;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.usage.UsageReportClusterEntry;
import io.imply.cloud.model.usage.UsageReportEvent;
import io.imply.cloud.model.usage.UsageReportIntervalEntry;
import io.imply.cloud.model.usage.UsageReportNodeEntry;
import io.imply.cloud.persistence.BillingDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class AccountUsageHelper {
    private static final List<BillingBackfillEntry> BACKFILL_ENTRIES;
    private static final Interval SKIP_VALIDATION_INTERVAL;
    private final BillingDataManager billingDataManager;
    private final ClusterDataManager clusterDataManager;
    private final InstanceTypeHelper instanceTypeHelper;

    @Inject
    public AccountUsageHelper(BillingDataManager billingDataManager, ClusterDataManager clusterDataManager, InstanceTypeHelper instanceTypeHelper) {
        this.billingDataManager = billingDataManager;
        this.clusterDataManager = clusterDataManager;
        this.instanceTypeHelper = instanceTypeHelper;
    }

    private static List<BillingEntry> validateBillingEntries(List<BillingEntry> entries) {
        if (entries == null) {
            return null;
        }
        DateTime prevTimestamp = null;
        for (int i = 0; i < entries.size(); ++i) {
            BillingEntry entry = entries.get(i);
            if (prevTimestamp != null && prevTimestamp.isAfter((ReadableInstant)entry.getTimestamp())) {
                throw new ISE("Billing entry list is not sorted in ascending order; cannot generating billing report.", new Object[0]);
            }
            if (prevTimestamp != null && SKIP_VALIDATION_INTERVAL.contains(prevTimestamp) || SKIP_VALIDATION_INTERVAL.contains((ReadableInstant)entry.getTimestamp())) continue;
            prevTimestamp = entry.getTimestamp();
            if (BillingState.CLUSTER_STARTED.equals((Object)entry.getState())) {
                Preconditions.checkState((i > 0 ? 1 : 0) != 0, (Object)"[CLUSTER_STARTED] can not be the first billing entry");
                Preconditions.checkState((boolean)BillingState.CLUSTER_START_REQUESTED.equals((Object)entries.get(i - 1).getState()), (String)"[CLUSTER_STARTED] must be preceded by [CLUSTER_START_REQUESTED]: %s", (Object)entry);
            }
            if (BillingState.CLUSTER_UPDATED.equals((Object)entry.getState())) {
                Preconditions.checkState((i > 0 ? 1 : 0) != 0, (Object)"[CLUSTER_UPDATED] can not be the first billing entry");
                Preconditions.checkState((boolean)BillingState.CLUSTER_UPDATE_REQUESTED.equals((Object)entries.get(i - 1).getState()), (String)"[CLUSTER_UPDATED] must be preceded by [CLUSTER_UPDATE_REQUESTED]: %s", (Object)entry);
            }
            if (BillingState.CLUSTER_STOP_REQUESTED.equals((Object)entry.getState()) && i < entries.size() - 1) {
                Preconditions.checkState((boolean)ImmutableList.of((Object)BillingState.CLUSTER_STOP_REQUESTED, (Object)BillingState.CLUSTER_STOPPED, (Object)BillingState.OPERATION_ROLLED_BACK, (Object)BillingState.OPERATION_FAILED).contains((Object)entries.get(i + 1).getState()), (String)"[CLUSTER_STOP_REQUESTED] must be followed by [CLUSTER_STOPPED, OPERATION_ROLLED_BACK, OPERATION_FAILED]: %s", (Object)entry);
            }
            if (!BillingState.CLUSTER_UPDATE_REQUESTED.equals((Object)entry.getState()) || i >= entries.size() - 1) continue;
            Preconditions.checkState((boolean)ImmutableList.of((Object)BillingState.CLUSTER_STOP_REQUESTED, (Object)BillingState.CLUSTER_UPDATE_REQUESTED, (Object)BillingState.CLUSTER_UPDATED, (Object)BillingState.OPERATION_ROLLED_BACK, (Object)BillingState.OPERATION_FAILED).contains((Object)entries.get(i + 1).getState()), (String)"[CLUSTER_UPDATE_REQUESTED] must be followed by [CLUSTER_STOP_REQUESTED, CLUSTER_UPDATED, OPERATION_ROLLED_BACK, OPERATION_FAILED]: %s", (Object)entry);
        }
        return entries;
    }

    private static Map<String, List<BillingEntry>> splitEntriesByCluster(List<BillingEntry> entries) {
        HashMap<String, List<BillingEntry>> entriesMap = new HashMap<String, List<BillingEntry>>();
        for (BillingEntry entry : entries) {
            String clusterId = entry.getCluster().getClusterId();
            if (!entriesMap.containsKey(clusterId)) {
                entriesMap.put(clusterId, new ArrayList());
            }
            ((List)entriesMap.get(clusterId)).add(entry);
        }
        return entriesMap;
    }

    private static List<BillingEntry> filterEntriesInInterval(List<BillingEntry> entries, Interval interval) {
        BillingEntry entry;
        ArrayList<BillingEntry> retVal = new ArrayList<BillingEntry>();
        for (int i = 0; i < entries.size() && !(entry = entries.get(i)).getTimestamp().isAfter((ReadableInstant)interval.getEnd()); ++i) {
            if (!entry.getTimestamp().isAfter((ReadableInstant)interval.getStart()) && (i >= entries.size() - 1 || !entries.get(i + 1).getTimestamp().isAfter((ReadableInstant)interval.getStart())) && i != entries.size() - 1) continue;
            retVal.add(entry);
        }
        return retVal;
    }

    private static List<BillingEntry> filterUsageChangeEntries(List<BillingEntry> entries) {
        return entries.stream().filter(x -> ImmutableList.of((Object)BillingState.CLUSTER_STARTED, (Object)BillingState.CLUSTER_STOP_REQUESTED, (Object)BillingState.CLUSTER_UPDATED).contains((Object)x.getState())).collect(Collectors.toList());
    }

    private static List<Pair<Interval, BillingEntry>> getBillingIntervals(List<BillingEntry> billingEntries, Interval reportInterval) {
        ArrayList<Pair<Interval, BillingEntry>> billingIntervals = new ArrayList<Pair<Interval, BillingEntry>>();
        for (int i = 0; i < billingEntries.size(); ++i) {
            BillingEntry entry = billingEntries.get(i);
            if (i == 0 && entry.getTimestamp().isAfter((ReadableInstant)reportInterval.getStart())) {
                billingIntervals.add((Pair<Interval, BillingEntry>)Pair.of((Object)new Interval((ReadableInstant)reportInterval.getStart(), (ReadableInstant)entry.getTimestamp()), null));
            }
            DateTime intervalStart = reportInterval.getStart().isAfter((ReadableInstant)entry.getTimestamp()) ? reportInterval.getStart() : entry.getTimestamp();
            billingIntervals.add((Pair<Interval, BillingEntry>)Pair.of((Object)new Interval((ReadableInstant)intervalStart, (ReadableInstant)(i < billingEntries.size() - 1 ? billingEntries.get(i + 1).getTimestamp() : reportInterval.getEnd())), (Object)entry));
        }
        return billingIntervals;
    }

    public Map<ImplyNodeType, UsageReportNodeEntry> generateUsageReportNodeMap(Cluster cluster) {
        HashMap<ImplyNodeType, UsageReportNodeEntry> clusterNodes = new HashMap<ImplyNodeType, UsageReportNodeEntry>();
        clusterNodes.put(ImplyNodeType.MASTER, new UsageReportNodeEntry(cluster.getMasterInstanceType(), cluster.getMasterInstanceCount(), Long.valueOf(this.getMICUForInstanceType(ImplyNodeType.MASTER, cluster.getMasterInstanceType()))));
        clusterNodes.put(ImplyNodeType.QUERY, new UsageReportNodeEntry(cluster.getQueryInstanceType(), cluster.getQueryInstanceCount(), Long.valueOf(this.getMICUForInstanceType(ImplyNodeType.QUERY, cluster.getQueryInstanceType()))));
        for (Map.Entry entry : cluster.getDataInstanceTiers().entrySet()) {
            clusterNodes.put(ImplyNodeType.dataFromTierInteger((int)((Integer)entry.getKey())), new UsageReportNodeEntry(((InstanceTier)entry.getValue()).getInstanceType(), ((InstanceTier)entry.getValue()).getInstanceCount(), Long.valueOf(this.getMICUForInstanceType(ImplyNodeType.DATA, ((InstanceTier)entry.getValue()).getInstanceType()))));
        }
        return clusterNodes;
    }

    private long getMICUForInstanceType(ImplyNodeType nodeType, String instanceType) {
        InstanceType lookupVal = this.instanceTypeHelper.lookupInstanceType(nodeType, instanceType);
        if (lookupVal.getMICU() == null) {
            throw new ISE("No MICU value found for instance type [%s]", new Object[]{instanceType});
        }
        return lookupVal.getMICU().intValue();
    }

    public Map<String, List<BillingEntry>> getValidatedEntriesByCluster(String accountId) {
        Map<String, List<BillingEntry>> entriesByCluster = AccountUsageHelper.splitEntriesByCluster(this.billingDataManager.getAllWithAccountId(accountId));
        HashMap<String, List<BillingEntry>> toReturn = new HashMap<String, List<BillingEntry>>();
        for (Map.Entry<String, List<BillingEntry>> clusterEntries : entriesByCluster.entrySet()) {
            String clusterId = clusterEntries.getKey();
            if (clusterEntries.getValue() == null) continue;
            List<BillingEntry> enrichedClusterEntries = new ArrayList<BillingEntry>((Collection)clusterEntries.getValue());
            enrichedClusterEntries.addAll(this.getBackfilledEntriesForCluster(clusterId));
            enrichedClusterEntries = this.dedupeBackfills(enrichedClusterEntries);
            enrichedClusterEntries.sort(Comparator.comparing(BillingEntry::getTimestamp));
            toReturn.put(clusterId, AccountUsageHelper.validateBillingEntries(enrichedClusterEntries));
        }
        return toReturn;
    }

    public List<UsageReportClusterEntry> getIntervalClusterUsage(String accountId, Interval interval, List<String> clusterFilter) {
        return this.getIntervalClusterUsage(accountId, interval, clusterFilter, null);
    }

    public List<UsageReportClusterEntry> getIntervalClusterUsage(String accountId, Interval interval, List<String> clusterFilter, Map<String, List<BillingEntry>> validatedEntriesByCluster) {
        if (interval == null) {
            return null;
        }
        Preconditions.checkArgument((interval.getStart().isBeforeNow() && interval.getEnd().isBeforeNow() ? 1 : 0) != 0, (String)"[interval] start and end must be before now (%s)", (Object)DateTime.now());
        ArrayList<UsageReportClusterEntry> intervalClusterUsage = new ArrayList<UsageReportClusterEntry>();
        Map<String, List<BillingEntry>> entriesByCluster = validatedEntriesByCluster != null ? validatedEntriesByCluster : this.getValidatedEntriesByCluster(accountId);
        for (Map.Entry<String, List<BillingEntry>> clusterEntries : entriesByCluster.entrySet()) {
            String clusterName;
            String clusterId = clusterEntries.getKey();
            String string = clusterName = clusterEntries.getValue() == null || clusterEntries.getValue().isEmpty() ? null : clusterEntries.getValue().get(0).getCluster().getName();
            if (clusterFilter != null && !clusterFilter.contains(clusterId) || clusterEntries.getValue() == null) continue;
            List<BillingEntry> billingEntries = AccountUsageHelper.filterEntriesInInterval(AccountUsageHelper.filterUsageChangeEntries(clusterEntries.getValue()), interval);
            ArrayList<UsageReportIntervalEntry> intervalEntries = new ArrayList<UsageReportIntervalEntry>();
            List<Pair<Interval, BillingEntry>> billingIntervals = AccountUsageHelper.getBillingIntervals(billingEntries, interval);
            for (Pair<Interval, BillingEntry> billingInterval : billingIntervals) {
                if (billingInterval.rhs == null || !ImmutableList.of((Object)BillingState.CLUSTER_STARTED, (Object)BillingState.CLUSTER_UPDATED).contains((Object)((BillingEntry)billingInterval.rhs).getState())) continue;
                try {
                    intervalEntries.add(new UsageReportIntervalEntry((Interval)billingInterval.lhs, this.generateUsageReportNodeMap(((BillingEntry)billingInterval.rhs).getCluster())));
                }
                catch (IllegalStateException e) {
                    throw new ISE((Throwable)e, "Failed to add interval entry for: %s", new Object[]{billingInterval.rhs});
                }
            }
            if (intervalEntries.isEmpty()) continue;
            intervalClusterUsage.add(new UsageReportClusterEntry(clusterId, clusterName, intervalEntries, AccountUsageHelper.filterEntriesInInterval(clusterEntries.getValue(), interval).stream().map(UsageReportEvent::fromBillingEntry).collect(Collectors.toList())));
        }
        return intervalClusterUsage;
    }

    private List<BillingEntry> dedupeBackfills(List<BillingEntry> values) {
        return values.stream().collect(Collectors.groupingBy(BillingEntry::getRequestId)).entrySet().stream().flatMap(x -> {
            ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
            return ((Stream)((List)x.getValue()).stream().sorted(Comparator.comparing(BillingEntry::getTimestamp)).sequential()).filter(e -> seen.add(e.getState()));
        }).collect(Collectors.toList());
    }

    private List<BillingEntry> getBackfilledEntriesForCluster(String clusterId) {
        return BACKFILL_ENTRIES.stream().filter(entry -> entry.getClusterId().equals(clusterId)).map(this::convertToBillingEntry).collect(Collectors.toList());
    }

    private BillingEntry convertToBillingEntry(BillingBackfillEntry backfillEntry) {
        Cluster cluster = this.clusterDataManager.getAllVersions(backfillEntry.getClusterId(), DeletedVisibility.SHOW_ALL).stream().filter(entry -> entry.getLastModified() != null && entry.getLastModified().isBefore((ReadableInstant)backfillEntry.getTimestamp())).sorted((first, second) -> second.getVersion().compareTo(first.getVersion())).findFirst().get();
        return BillingEntry.of((String)backfillEntry.getUser(), (String)cluster.getAccountId(), (String)backfillEntry.getRequestId(), (BillingState)(backfillEntry.getState() == BillingState.CLUSTER_STOPPED ? BillingState.CLUSTER_STOP_REQUESTED : backfillEntry.getState()), (Cluster)cluster, (DateTime)backfillEntry.getTimestamp());
    }

    static {
        SKIP_VALIDATION_INTERVAL = new Interval((Object)"2019-09-01/2020-01-15", (Chronology)ISOChronology.getInstanceUTC());
        try (InputStream in = AccountUsageHelper.class.getClassLoader().getResourceAsStream("billing-backfill.json");){
            BACKFILL_ENTRIES = (List)new DefaultObjectMapper().readValue(in, (TypeReference)new TypeReference<List<BillingBackfillEntry>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BillingBackfillEntry {
        @JsonProperty
        private final DateTime timestamp = null;
        @JsonProperty
        private final String user;
        @JsonProperty
        private final String requestId;
        @JsonProperty
        private final String clusterId;
        @JsonProperty(value="event")
        private final BillingState state = null;

        @Generated
        public DateTime getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getClusterId() {
            return this.clusterId;
        }

        @Generated
        public BillingState getState() {
            return this.state;
        }

        @Generated
        private BillingBackfillEntry() {
            this.user = null;
            this.requestId = null;
            this.clusterId = null;
        }
    }
}

