/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.stage.AwaitDataInstancesAvailableStage;
import io.imply.cloud.manager.stage.AwaitInstanceTerminationStage;
import io.imply.cloud.manager.stage.AwaitMasterInstancesAvailableStage;
import io.imply.cloud.manager.stage.AwaitMiddleManagerIdleStage;
import io.imply.cloud.manager.stage.AwaitMiddleManagerTaskStatusStage;
import io.imply.cloud.manager.stage.AwaitQueryInstancesAvailableStage;
import io.imply.cloud.manager.stage.AwaitSegmentsAvailableStage;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.manager.stage.DisableMiddleManagerStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.manager.stage.SetAutoscalingDesiredCapacityStage;
import io.imply.cloud.manager.stage.SetAutoscalingInstanceProtectionStage;
import io.imply.cloud.manager.stage.SetConfigServerClusterVersionStage;
import io.imply.cloud.manager.stage.TerminateInstanceStage;
import io.imply.cloud.model.Stage;
import io.imply.cloud.util.Logger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class StageHelper {
    private static final Logger log = new Logger(StageHelper.class);

    public Deque<Stage> convertRollingToHardUpdate(Deque<Stage> stages) {
        ArrayDeque<Stage> plan = new ArrayDeque<Stage>();
        Stage finalAwaitMasterInstancesAvailableStage = null;
        Stage finalAwaitQueryInstancesAvailableStage = null;
        Stage finalAwaitDataInstancesAvailableStage = null;
        if (stages == null) {
            return plan;
        }
        Integer lowestStageNumber = null;
        for (Stage stage : stages) {
            if (stage.getStageNumber() != null && (lowestStageNumber == null || stage.getStageNumber() < lowestStageNumber)) {
                lowestStageNumber = stage.getStageNumber();
            }
            if (AwaitMasterInstancesAvailableStage.class.isAssignableFrom(stage.getClass())) {
                finalAwaitMasterInstancesAvailableStage = stage;
                continue;
            }
            if (AwaitDataInstancesAvailableStage.class.isAssignableFrom(stage.getClass())) {
                finalAwaitDataInstancesAvailableStage = stage;
                continue;
            }
            if (AwaitQueryInstancesAvailableStage.class.isAssignableFrom(stage.getClass())) {
                finalAwaitQueryInstancesAvailableStage = stage;
                continue;
            }
            if (this.getIncludedStages().stream().anyMatch(c -> c.isAssignableFrom(stage.getClass()))) {
                plan.add(stage);
                continue;
            }
            if (this.getExcludedStages().stream().anyMatch(c -> c.isAssignableFrom(stage.getClass()))) continue;
            log.error("Found unknown stage [%s] while converting from ROLLING to HARD update plan", new Object[]{stage.getClass().getSimpleName()});
        }
        if (finalAwaitMasterInstancesAvailableStage != null) {
            plan.add(finalAwaitMasterInstancesAvailableStage);
        }
        if (finalAwaitDataInstancesAvailableStage != null) {
            plan.add(finalAwaitDataInstancesAvailableStage);
        }
        if (finalAwaitQueryInstancesAvailableStage != null) {
            plan.add(finalAwaitQueryInstancesAvailableStage);
        }
        if (lowestStageNumber != null) {
            this.tagWithStageNumbers(plan, lowestStageNumber);
        }
        log.info("Converted ROLLING update plan to HARD: %s -> %s", new Object[]{stages, plan});
        return plan;
    }

    protected List<Class<? extends Stage>> getExcludedStages() {
        return ImmutableList.of(AwaitInstanceTerminationStage.class, AwaitMiddleManagerIdleStage.class, AwaitMiddleManagerTaskStatusStage.class, AwaitSegmentsAvailableStage.class, DisableMiddleManagerStage.class);
    }

    protected List<Class<? extends Stage>> getIncludedStages() {
        return ImmutableList.of(ModifyCoordinatorDynamicConfigurationStage.class, SetAutoscalingDesiredCapacityStage.class, SetAutoscalingInstanceProtectionStage.class, SetConfigServerClusterVersionStage.class, TerminateInstanceStage.class);
    }

    public Deque<Stage> tagWithStageNumbers(Deque<Stage> stages, int startingNumber) {
        int i = startingNumber;
        for (Stage stage : stages) {
            if (stage instanceof BaseStage) {
                ((BaseStage)stage).setStageNumber(i);
            }
            ++i;
        }
        return stages;
    }
}

