/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Stage;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import org.joda.time.DateTime;

public abstract class BaseStage
implements Stage {
    private static final Logger log = new Logger(BaseStage.class);
    private final String clusterId;
    private final ImplyNodeType nodeType;
    protected final ManagerToolbox toolbox;
    private DateTime completionTime;
    private Integer stageNumber;
    private Integer executionCount;
    private Stage.State state;

    public BaseStage(ManagerToolbox toolbox, String clusterId) {
        this(toolbox, clusterId, null);
    }

    public BaseStage(ManagerToolbox toolbox, String clusterId, ImplyNodeType nodeType) {
        this.toolbox = toolbox;
        this.clusterId = clusterId;
        this.nodeType = nodeType;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public ImplyNodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeTypeAsString() {
        return this.nodeType == null ? "" : this.nodeType.camelCasedName();
    }

    @JsonProperty
    public DateTime getCompletionTime() {
        return this.completionTime;
    }

    @JsonProperty
    public Integer getStageNumber() {
        return this.stageNumber;
    }

    public boolean run(Stage.State state) throws Exception {
        ThreadLocalContext.setStageClass(this.getClass());
        this.state = state;
        log.debug("Processing stage [%s] for cluster [%s], executionCount [%d]", new Object[]{this.getClass().getSimpleName(), this.getClusterId(), this.getExecutionCount()});
        return this.innerRun();
    }

    public Integer getMaxConsecutiveExceptions() {
        return 5;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 30;
    }

    public Integer getExecutionDelayInSeconds() {
        return 0;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void setExecutionCount(Integer executionCount) {
        this.executionCount = executionCount;
    }

    public void setCompletionTime(DateTime completionTime) {
        this.completionTime = completionTime;
    }

    public void setStageNumber(Integer stageNumber) {
        this.stageNumber = stageNumber;
    }

    public abstract boolean innerRun() throws Exception;

    protected Info getInfo() {
        return this.toolbox.getEntityStateDataManager().get(this.toolbox.getClusterDataManager().get(this.clusterId));
    }

    protected Account getAccount() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.clusterId);
        return this.toolbox.getAccountDataManager().get(cluster.getAccountId());
    }

    protected Integer getExecutionCount() {
        return this.executionCount;
    }

    protected Stage.State getState() {
        return this.state;
    }

    public String toString() {
        return this.getName();
    }
}

