/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.druid.SimpleComputeServer;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Range;

public class AwaitSegmentsAvailableStage
extends MasterHostsStage {
    private static final Logger log = new Logger(AwaitSegmentsAvailableStage.class);
    private static final int NUM_EXECUTIONS_BEFORE_ALLOWING_SEGMENTS_WAITING_TO_LOAD = 30;
    private static final int MAX_SEGMENTS_ALLOWED_TO_BE_LOADING_PER_DATASOURCE = 20;
    private static final double MIN_HISTORICAL_UTILIZATION_PERCENTAGE = 0.95;
    private final Set<String> masterHosts;
    private final String tierName;
    private Boolean computeUsingClusterView;

    @JsonCreator
    public AwaitSegmentsAvailableStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="masterHosts") Set<String> masterHosts, @JsonProperty(value="tierName") String tierName) {
        super(toolbox, clusterId, nodeType);
        this.masterHosts = masterHosts;
        this.tierName = tierName;
        this.computeUsingClusterView = true;
    }

    @Override
    public boolean innerRun() {
        DruidApiClient druidApiClient = this.toolbox.getDruidApiClient();
        List historicalHosts = druidApiClient.getHistoricalHosts(this.findMasterHosts(), this.getClusterId()).stream().filter(host -> this.getTierName() == null || this.getTierName().equals(host.getTier())).collect(Collectors.toList());
        double historicalUtilizationPercent = this.getMinHistoricalUtilizationPercent();
        Map fullLoadStatus = druidApiClient.getFullLoadStatus(this.findMasterHosts(), this.getClusterId(), this.getComputeUsingClusterView());
        int segmentLoadThreshold = this.getSegmentLoadThreshold();
        log.info("Full load status for cluster [%s], execution [%d], loaded threshold [%d]: %s", new Object[]{this.getClusterId(), this.getExecutionCount(), segmentLoadThreshold, fullLoadStatus});
        if (fullLoadStatus.isEmpty()) {
            return this.toolbox.getDruidApiClient().getDatasources(this.findMasterHosts(), this.getClusterId()).isEmpty();
        }
        Stream<String> filteredLoadStatusKeys = fullLoadStatus.keySet().stream().filter(tier -> this.tierName == null || tier.equals(this.tierName));
        return filteredLoadStatusKeys.allMatch(tier -> this.isTierLoadQueueSizeBelowThreshold((Map)fullLoadStatus.get(tier), segmentLoadThreshold) || this.areHostsMatchingThisTierAboveCapacity((String)tier, historicalHosts, historicalUtilizationPercent));
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @JsonProperty
    public String getTierName() {
        return this.tierName;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 600;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for all segments to become available%s", this.tierName == null ? "" : String.format(" for tier [%s]", this.tierName));
    }

    private double getMinHistoricalUtilizationPercent() {
        if (this.getExecutionCount() == null) {
            return 1.0;
        }
        double scaledUtilizationPercent = 1.0 - (double)(this.getExecutionCount() - 30) * 0.001;
        return (Double)Range.between((Comparable)Double.valueOf(0.95), (Comparable)Double.valueOf(1.0)).fit((Object)scaledUtilizationPercent);
    }

    private int getSegmentLoadThreshold() {
        if (this.getExecutionCount() == null) {
            return 0;
        }
        return (Integer)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)).fit((Object)(this.getExecutionCount() - 30));
    }

    private boolean isTierLoadQueueSizeBelowThreshold(Map<String, Long> tierLoadStatus, int segmentLoadThreshold) {
        return tierLoadStatus.values().stream().allMatch(x -> x <= (long)segmentLoadThreshold);
    }

    private boolean isHostAboveCapacity(SimpleComputeServer host, double capacityThreshold) {
        return (double)host.getCurrSize().longValue() / (double)host.getMaxSize().longValue() >= capacityThreshold;
    }

    private boolean areHostsMatchingThisTierAboveCapacity(String tier, List<SimpleComputeServer> historicalHosts, double capacityThreshold) {
        boolean isOverCapacity;
        List matchingHosts = historicalHosts.stream().filter(host -> host != null && host.getTier() != null && host.getTier().equals(tier)).collect(Collectors.toList());
        boolean bl = isOverCapacity = !matchingHosts.isEmpty() && matchingHosts.stream().allMatch(host -> this.isHostAboveCapacity((SimpleComputeServer)host, capacityThreshold));
        if (isOverCapacity) {
            log.info("Historical tier [%s] for cluster [%s] has a segment cache utilization of at least [%5.3f%%].  Assuming it is fully utilized.", new Object[]{tier, this.getClusterId(), capacityThreshold * 100.0});
        }
        return isOverCapacity;
    }

    @Generated
    public void setComputeUsingClusterView(Boolean computeUsingClusterView) {
        this.computeUsingClusterView = computeUsingClusterView;
    }

    @Generated
    public Boolean getComputeUsingClusterView() {
        return this.computeUsingClusterView;
    }
}

