/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class AwaitMiddleManagerIdleStage
extends MasterHostsStage {
    private static final Logger log = new Logger(AwaitMiddleManagerIdleStage.class);
    private final String host;
    private final Set<String> masterHosts;

    @JsonCreator
    public AwaitMiddleManagerIdleStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="host") String host, @JsonProperty(value="masterHosts") Set<String> masterHosts) {
        super(toolbox, clusterId, nodeType);
        this.host = host;
        this.masterHosts = masterHosts;
    }

    @Override
    public boolean innerRun() {
        try {
            List tasks = this.toolbox.getDruidApiClient().getMiddleManagerTasks(this.host, this.getClusterId());
            if (tasks == null) {
                throw new ISE("Middle manager [%s] returned empty response", new Object[]{this.host});
            }
            log.info("Middle manager [%s] reports running [%d] tasks", new Object[]{this.host, tasks.size()});
            return tasks.isEmpty();
        }
        catch (Exception e) {
            if (e.getCause() != null && (e.getCause() instanceof TimeoutException || e.getCause() instanceof ExecutionException)) {
                log.info("No response from middle manager [%s], checking if node is still registered with overlord", new Object[]{this.host});
                if (this.toolbox.getDruidApiClient().isWorkerOnline(this.host, this.findMasterHosts(), this.getClusterId())) {
                    log.info("Overlord still reports [%s] as available, waiting for a status change", new Object[]{this.host});
                    return false;
                }
                log.info("Overlord no longer reports [%s] as available, continuing assuming middle manager is down", new Object[]{this.host});
                return true;
            }
            throw e;
        }
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 1450;
    }

    @Override
    public Integer getExecutionDelayInSeconds() {
        return this.toolbox.getApplicationConfig().getAwaitMiddleManagerIdleDelay();
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for indexing tasks on middle manager [%s] to complete", this.host);
    }
}

