/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Range;

public class AwaitCloneSegmentsAvailableStage
extends MasterHostsStage {
    @Generated
    private static final Logger log = Logger.from(AwaitCloneSegmentsAvailableStage.class);
    private static final int NUM_EXECUTIONS_BEFORE_ALLOWING_SEGMENTS_WAITING_TO_LOAD = 30;
    private static final int MAX_SEGMENTS_ALLOWED_TO_BE_LOADING = 20;
    private final Set<String> masterHosts;

    @JsonCreator
    public AwaitCloneSegmentsAvailableStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="masterHosts") Set<String> masterHosts) {
        super(toolbox, clusterId, nodeType);
        this.masterHosts = masterHosts;
    }

    @Override
    public boolean innerRun() {
        DruidApiClient druidApiClient = this.toolbox.getDruidApiClient();
        Set<String> masterHosts = this.findMasterHosts();
        List cloneStatus = druidApiClient.getCloneStatus(masterHosts, this.getClusterId());
        int segmentLoadThreshold = this.getSegmentLoadThreshold();
        log.info("Clone status for cluster [%s], execution [%d], loaded threshold [%d]: %s", new Object[]{this.getClusterId(), this.getExecutionCount(), segmentLoadThreshold, cloneStatus});
        if (CollectionUtils.isEmpty((Collection)cloneStatus)) {
            return this.toolbox.getDruidApiClient().getDatasources(masterHosts, this.getClusterId()).isEmpty();
        }
        if (cloneStatus.stream().anyMatch(clone -> !"IN_PROGRESS".equals(clone.getState()) || clone.getSegmentLoadsRemaining() > (long)segmentLoadThreshold)) {
            return false;
        }
        List syncedBrokers = druidApiClient.getSyncedBrokers(masterHosts, this.getClusterId());
        if (CollectionUtils.isEmpty((Collection)syncedBrokers)) {
            log.warn("No synced brokers found for cluster [%s] with master hosts [%s].", new Object[]{this.getClusterId(), masterHosts});
            return false;
        }
        log.info("Synced brokers for cluster [%s]: %s", new Object[]{this.getClusterId(), syncedBrokers});
        return true;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 600;
    }

    @JsonProperty
    public String getDescription() {
        return "Waiting for all clones to become available";
    }

    private int getSegmentLoadThreshold() {
        if (this.getExecutionCount() == null) {
            return 0;
        }
        return (Integer)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)).fit((Object)(this.getExecutionCount() - 30));
    }
}

