/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.ISE;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AwaitAgentReplacementStage
extends BaseStage {
    private final String host;
    private String replacement;

    @JsonCreator
    public AwaitAgentReplacementStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="host") String host, @JsonProperty(value="replacement") String replacement) {
        super(toolbox, clusterId, ImplyNodeType.DATA);
        this.host = host;
        this.replacement = replacement;
    }

    @Override
    public boolean innerRun() {
        throw new ISE("Agent updates not supported on platform [%s]", new Object[]{this.toolbox.getApplicationConfig().getPlatform()});
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 30;
    }

    @JsonProperty
    public String getDescription() {
        if (this.replacement == null) {
            return String.format("Waiting for host [%s] to be replaced or removed", this.host);
        }
        return String.format("Waiting for host [%s] to come online", this.replacement);
    }
}

