/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.operations;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.StateActionTable;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.List;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class ProcessEntitiesNotice
extends OperationsNotice {
    private static final Logger log = new Logger(ProcessEntitiesNotice.class);
    private final Injector injector;
    private boolean addToQueueHead = false;

    @Inject
    public ProcessEntitiesNotice(ManagerToolbox toolbox, Injector injector) {
        super(toolbox);
        this.injector = injector;
    }

    @Override
    public void innerHandle() {
        List infos = this.info != null && this.info.getKey() != null ? ImmutableList.of((Object)this.toolbox.getEntityStateDataManager().get(this.info)) : this.toolbox.getEntityStateDataManager().getAllInTransitionStates();
        for (Info info : infos) {
            ThreadLocalContext.setSystemContext((String)"isMock", (Object)info.isMockEntity());
            long secondsSinceLastStateChange = info.getLastStateChange() == null ? -1L : (DateTime.now().getMillis() - info.getLastStateChange().getMillis()) / 1000L;
            log.debug("entityId [%s] actualState [%s] desiredState [%s] secondsSinceLastStateChange [%d]", new Object[]{info.getEntityId(), info.getState(), info.getDesiredState(), secondsSinceLastStateChange});
            Class<? extends Notice> clazz = switch (info.getEntityType()) {
                case EntityType.ACCOUNT -> StateActionTable.getAccountNoticeClass(info.getState(), info.getDesiredState());
                case EntityType.CLUSTER -> StateActionTable.getClusterNoticeClass(info.getState(), info.getDesiredState());
                default -> throw new ISE("Don't know how to handle entityType [%s]", new Object[]{info.getEntityType()});
            };
            if (clazz == null) continue;
            if (info.getAnnotatedType() != null) {
                this.toolbox.getNoticeManager().queueNotice(((Notice)this.injector.getInstance(Key.get(clazz, (Class)info.getAnnotatedType()))).withInfo(info), this.addToQueueHead);
                continue;
            }
            this.toolbox.getNoticeManager().queueNotice(((Notice)this.injector.getInstance(clazz)).withInfo(info), this.addToQueueHead);
        }
    }

    @Override
    protected State getTimeoutState() {
        throw new ISE("getTimeoutState() should not be getting called for ProcessEntitiesNotice", new Object[0]);
    }

    public ProcessEntitiesNotice withAddToQueueHead(boolean addToQueueHead) {
        this.addToQueueHead = addToQueueHead;
        return this;
    }
}

