/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;

public abstract class SetClusterRolledBackOrRevertRollingUpdateNotice
extends Notice {
    public SetClusterRolledBackOrRevertRollingUpdateNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    protected void innerHandle() {
        State currentState = this.info.getUpdateState().getCurrentState();
        if (currentState != null && State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS.equals((Object)currentState)) {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STACK_UPDATED).build());
            this.setQueueNextNotice();
        } else {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_UPDATE_ROLLED_BACK).withProposedClusterVersion(Constants.CLEAR_FIELD_INT).clearExistingUpdateState().build());
            this.addInfoNotification("Cluster rollback completed", new Object[0]);
            this.markNotificationsAsPrevious();
        }
        this.toolbox.getClusterStackHelper().refreshClusterDetails(this.info.getEntityId());
    }

    @Override
    protected State getTimeoutState() {
        return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
    }
}

