/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.util.Logger;
import java.util.Map;

public interface RevertClusterBaseNotice {
    public static final Logger log = new Logger(RevertClusterBaseNotice.class);

    default public Notification revertClusterWithState(ManagerToolbox toolbox, Info info, State state, boolean clearProposedClusterVersion, boolean clearUpdateState) {
        int deployedClusterVersion = info.getDeployedClusterVersion() == null ? 0 : info.getDeployedClusterVersion();
        Cluster deployedCluster = toolbox.getClusterDataManager().getVersionOrNull(info.getEntityId(), deployedClusterVersion);
        if (deployedCluster == null) {
            String warningMessage = String.format("Failed to revert cluster spec for cluster [%s]", info.getEntityId());
            log.warn(warningMessage);
            Info.Builder infoBuilder = Info.builder().withState(State.CLUSTER_UPDATE_FAILED).withProposedClusterVersion(Constants.CLEAR_FIELD_INT);
            if (clearUpdateState) {
                infoBuilder.clearExistingUpdateState();
            }
            toolbox.getEntityStateDataManager().insert(info, infoBuilder.build());
            return Notification.of((String)warningMessage, null, (Notification.Level)Notification.Level.WARNING, (Notification.Source)Notification.Source.MANAGER, (String)info.getKey());
        }
        Info.Builder infoBuilder = Info.builder().withState(state);
        if (clearProposedClusterVersion) {
            infoBuilder.withProposedClusterVersion(Constants.CLEAR_FIELD_INT);
        }
        if (clearUpdateState) {
            Cluster revertedCluster = toolbox.getClusterDataManager().update(deployedCluster, "SYSTEM_ROLLBACK", true, false);
            infoBuilder.clearExistingUpdateState().withDeployedClusterVersion(revertedCluster.getVersion());
        } else if (info.getProposedClusterVersion() != null) {
            Cluster revertedCluster = toolbox.getClusterDataManager().update(deployedCluster, "SYSTEM_ROLLBACK", true, false);
            Cluster botchedCluster = toolbox.getClusterDataManager().getVersionOrNull(info.getEntityId(), info.getProposedClusterVersion().intValue());
            Cluster diffCluster = revertedCluster.mergeDiff(botchedCluster, true);
            Cluster modifiedParameters = diffCluster.cloner().withoutNonUpdatableFields().withVersion(null).withImplyVersionFull(null).build();
            Cluster originalParameters = botchedCluster.filterNonNullFields(modifiedParameters);
            infoBuilder.withUpdateState(UpdateState.builder((UpdateState)info.getUpdateState()).modifiedParameters(Cluster.clusterToMapWithoutType((ObjectMapper)toolbox.getObjectMapper(), (Cluster)modifiedParameters)).originalParameters(Cluster.clusterToMapWithoutType((ObjectMapper)toolbox.getObjectMapper(), (Cluster)originalParameters)).build());
            infoBuilder.withDeployedClusterVersion(revertedCluster.getVersion());
        } else {
            ClusterNodes deployedClusterNodes = toolbox.getClusterNodesDataManager().getVersionOrNull(info.getEntityId(), info.getDeployedClusterNodesVersion().intValue());
            ClusterNodes botchedClusterNodes = toolbox.getClusterNodesDataManager().getVersionOrNull(info.getEntityId(), info.getProposedClusterNodesVersion().intValue());
            ClusterNodes revertedClusterNodes = toolbox.getClusterNodesDataManager().insert(deployedClusterNodes, "SYSTEM_ROLLBACK", true, false);
            ClusterNodes diffClusterNodes = revertedClusterNodes.mergeDiff(botchedClusterNodes);
            ClusterNodes modifiedParameters = diffClusterNodes.cloner().withoutNonUpdatableFields().withVersion(null).build();
            ClusterNodes originalParameters = botchedClusterNodes.filterNonNullFields(modifiedParameters);
            infoBuilder.withUpdateState(UpdateState.builder((UpdateState)info.getUpdateState()).modifiedParameters((Map)toolbox.getObjectMapper().convertValue((Object)modifiedParameters, (TypeReference)new TypeReference<Map<String, Object>>(){})).originalParameters((Map)toolbox.getObjectMapper().convertValue((Object)originalParameters, (TypeReference)new TypeReference<Map<String, Object>>(){})).build());
            infoBuilder.withDeployedClusterNodesVersion(revertedClusterNodes.getVersion());
        }
        toolbox.getEntityStateDataManager().insert(info, infoBuilder.build());
        return Notification.of((String)"Rolled back to previous cluster specification", null, (Notification.Level)Notification.Level.INFO, (Notification.Source)Notification.Source.MANAGER, (String)info.getKey());
    }
}

