/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.Logger;
import org.joda.time.DateTime;

public abstract class PostDeleteNotice
extends Notice {
    private static final Logger log = new Logger(PostDeleteNotice.class);

    public PostDeleteNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    public void innerHandle() {
        log.info("Deleting cluster [%s]", new Object[]{this.info.getEntityId()});
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_DELETED).withNotificationCutoff(DateTime.now()).build());
        this.toolbox.getClusterDataManager().delete(this.info.getEntityId(), this.info.getRequesterId(), true);
        this.toolbox.getNotificationDataManager().deleteNotificationsWithEntityKey(this.info.getKey());
        log.info(true, "Cluster [%s] deleted", new Object[]{this.info.getEntityId()});
        this.addInfoNotification("Cluster deleted", new Object[0]);
        this.markNotificationsAsPrevious();
    }

    @Override
    protected State getTimeoutState() {
        return State.CLUSTER_DELETE_FAILED;
    }
}

