/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.ExceptionHandlingNotice;
import io.imply.cloud.manager.stage.EnableMiddleManagerStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.manager.stage.SetConfigServerClusterVersionStage;
import io.imply.cloud.manager.stage.TryAwaitSegmentsAvailableStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.DataTierInfo;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.PlanUpdateState;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateSubtype;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.model.User;
import io.imply.cloud.model.zookeeper.ManagedZooKeeper;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.DiffResultHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;

public abstract class PlanRollingUpdateNotice
extends ExceptionHandlingNotice {
    private static final Logger log = new Logger(PlanRollingUpdateNotice.class);
    private final ClusterDataManager clusterDataManager;

    public PlanRollingUpdateNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
        this.clusterDataManager = toolbox.getClusterDataManager();
    }

    @Override
    public void innerHandle() {
        boolean hasChanges;
        PlanUpdateState planState = this.buildInitialPlanUpdateState();
        if (planState.isSpecUpdate()) {
            log.info("Cluster diff (performing rollback [%s]): %s", new Object[]{planState.isPerformingRollback(), planState.getClusterDiffs()});
            hasChanges = planState.getClusterDiffs().getNumberOfDiffs() != 0;
        } else if (planState.isNodeListUpdate()) {
            log.info("Cluster node list diff (performing rollback [%s]): %s", new Object[]{planState.isPerformingRollback(), planState.getDiffClusterNodes()});
            hasChanges = !planState.getDiffClusterNodes().isEmpty();
        } else {
            throw new ISE("Unhandled update sub-type [%s], cannot continue", new Object[]{planState.getUpdateSubtype()});
        }
        if (!hasChanges) {
            log.error("No changes to apply while updating cluster [%s] - I shouldn't have been called!", new Object[]{this.info.getEntityId()});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_ROLLING_UPDATE_COMPLETE).build());
            this.addInfoNotification("No changes to apply, cluster update complete", new Object[0]);
            return;
        }
        this.addInfoNotification("Fetching initial cluster state", new Object[0]);
        if (!this.populateInitialClusterState(planState)) {
            return;
        }
        if (planState.isPerformingRollback() && this.info.getUpdateState() != null) {
            planState.setCoordinatorDynamicConfiguration(this.info.getUpdateState().getCoordinatorDynamicConfiguration());
        } else if (this.isRollingUpdate() && planState.getMasterHostAddresses() != null && !planState.getMasterHostAddresses().isEmpty()) {
            try {
                String coordinatorDynamicConfiguration = (String)Retryable.of(() -> this.toolbox.getDruidApiClient().getCoordinatorDynamicConfiguration((Collection)planState.getMasterHostAddresses(), planState.getClusterId()), (int)3, (int)2, null, (boolean)true);
                planState.setCoordinatorDynamicConfiguration(coordinatorDynamicConfiguration);
            }
            catch (Exception e) {
                log.info((Throwable)e, "Failed to fetch coordinator dynamic configuration for cluster [%s], continuing without adjusting maxSegmentsToMove", new Object[]{planState.getClusterId()});
            }
        }
        if (planState.isSpecUpdate()) {
            this.determineAffectedNodeTypes(planState);
        }
        if (planState.isPerformingRollback() && planState.getHosts() != null) {
            log.info("Rollback host list pre-filter: %s", new Object[]{planState.getHosts()});
            ImmutableList instanceIds = this.info.getUpdateState().getPreUpdateHosts() == null ? ImmutableList.of() : this.info.getUpdateState().getPreUpdateHosts().stream().map(Host::getId).collect(Collectors.toList());
            ArrayList middleManagersToEnable = new ArrayList();
            for (int i = 1; i <= 3; ++i) {
                List dataInstances = (List)planState.getHosts().get(ImplyNodeType.dataFromTierInteger((int)i));
                if (dataInstances == null) continue;
                middleManagersToEnable.addAll(dataInstances.stream().filter(arg_0 -> PlanRollingUpdateNotice.lambda$innerHandle$1((List)instanceIds, arg_0)).collect(Collectors.toList()));
            }
            planState.setMiddleManagersToEnable(middleManagersToEnable);
            planState.setHosts(planState.getHosts().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, arg_0 -> PlanRollingUpdateNotice.lambda$innerHandle$3((List)instanceIds, arg_0))));
            log.info("Rollback host list post-filter: %s", new Object[]{planState.getHosts()});
        }
        this.addInfoNotification("Generating update plan%s", planState.isPerformingRollback() ? " (rollback)" : "");
        this.generateUpdatePlan(planState);
        planState.validateComplete();
        UpdateState.Builder updateStateBuilder = UpdateState.builder((UpdateState)this.info.getUpdateState()).type(this.info.getUpdateType()).pendingRollingStages(this.toolbox.getStageHelper().tagWithStageNumbers(planState.getPendingRollingStages(), 1)).completedRollingStages(new ArrayDeque()).currentState(State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS).clearTimerAndCounters();
        if (!planState.isPerformingRollback() && planState.getHosts() != null) {
            updateStateBuilder = updateStateBuilder.preUpdateHosts(planState.getHosts().values().stream().flatMap(Collection::stream).collect(Collectors.toList())).coordinatorDynamicConfiguration(planState.getCoordinatorDynamicConfiguration());
        }
        UpdateState updateState = updateStateBuilder.build();
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS).withUpdateState(updateState).withConfigServerClusterVersion(planState.getStartingCluster().getVersion()).build());
        log.info("Update plan: [%s]", new Object[]{updateState});
        this.addInfoNotification("Submitting plan for execution%s", planState.isPerformingRollback() ? " (rollback)" : "");
        this.setQueueNextNotice();
    }

    @Override
    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    @Override
    protected State getExceptionState() {
        return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
    }

    @Override
    protected Status getFailureStatus() {
        return Status.WARNING;
    }

    protected List<UpdateType> getSupportedUpdateTypes() {
        return ImmutableList.of((Object)UpdateType.ROLLING, (Object)UpdateType.HARD);
    }

    private PlanUpdateState buildInitialPlanUpdateState() {
        ClusterNodes deployedClusterNodes;
        if (!this.getSupportedUpdateTypes().contains(this.info.getUpdateType())) {
            throw new ISE("Only update types [ROLLING] and [HARD] are supported, cannot continue.", new Object[0]);
        }
        if (!(this.info.getDeployedClusterVersion() != null && this.info.getProposedClusterVersion() != null || this.info.getDeployedClusterNodesVersion() != null && this.info.getProposedClusterNodesVersion() != null)) {
            throw new ISE("Could not get either set of (deployedClusterVersion, proposedClusterVersion) or (deployedClusterNodesVersion, proposedClusterNodesVersion); cannot continue.", new Object[0]);
        }
        Cluster deployedCluster = this.clusterDataManager.getVersionOrNull(this.info.getEntityId(), this.info.getDeployedClusterVersion().intValue());
        if (deployedCluster == null) {
            throw new ISE("Could not get deployedCluster [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getDeployedClusterVersion(), this.info.getEntityId()});
        }
        Account account = this.toolbox.getAccountDataManager().get(deployedCluster.getAccountId());
        boolean performingRollback = State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)this.info.getDesiredState());
        ClusterNodes clusterNodes = deployedClusterNodes = this.toolbox.getApplicationConfig().isGroveBased() ? this.toolbox.getClusterNodesDataManager().getVersionOrNull(deployedCluster.getClusterId(), this.info.getDeployedClusterNodesVersion().intValue()) : null;
        if (this.info.getProposedClusterVersion() != null && (this.info.getProposedClusterNodesVersion() == null || this.toolbox.getApplicationConfig().isKubernetesMode())) {
            Cluster proposedCluster = this.clusterDataManager.getVersionOrNull(this.info.getEntityId(), this.info.getProposedClusterVersion().intValue());
            if (proposedCluster == null) {
                throw new ISE("Could not get proposedCluster [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getProposedClusterVersion(), this.info.getEntityId()});
            }
            Cluster startingCluster = performingRollback ? proposedCluster : deployedCluster;
            Cluster endingCluster = performingRollback ? deployedCluster : proposedCluster;
            ClusterNodes clusterNodes2 = deployedClusterNodes == null ? ClusterNodes.empty() : deployedClusterNodes;
            return new PlanUpdateState(UpdateSubtype.CLUSTER_SPEC, startingCluster, endingCluster, clusterNodes2, clusterNodes2, this.constructDataTierInfoMap(startingCluster, endingCluster, clusterNodes2, clusterNodes2), account, performingRollback);
        }
        if (this.info.getProposedClusterVersion() == null && this.info.getProposedClusterNodesVersion() != null) {
            ClusterNodes proposedClusterNodes = this.toolbox.getClusterNodesDataManager().getVersionOrNull(deployedCluster.getClusterId(), this.info.getProposedClusterNodesVersion().intValue());
            if (deployedClusterNodes == null || proposedClusterNodes == null) {
                throw new ISE("Could not get deployedClusterNodes [%s] or proposedClusterNodes [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getDeployedClusterNodesVersion(), this.info.getProposedClusterNodesVersion(), this.info.getEntityId()});
            }
            ClusterNodes startingClusterNodes = performingRollback ? proposedClusterNodes : deployedClusterNodes;
            ClusterNodes endingClusterNodes = performingRollback ? deployedClusterNodes : proposedClusterNodes;
            return new PlanUpdateState(UpdateSubtype.CLUSTER_NODE_LIST, deployedCluster, deployedCluster, startingClusterNodes, endingClusterNodes, this.constructDataTierInfoMap(deployedCluster, deployedCluster, startingClusterNodes, endingClusterNodes), account, performingRollback);
        }
        throw new ISE("Only one of [proposedClusterVersion] or [proposedClusterNodesVersion] is expected to be provided", new Object[0]);
    }

    private void generateUpdatePlan(PlanUpdateState planState) {
        ArrayDeque<Stage> updatePlan = new ArrayDeque<Stage>();
        this.addPreUpdateStages(planState, updatePlan);
        Map<ImplyNodeType.ImplyNodeServiceType, List<ImplyNodeType>> updateOrder = this.getUpdateOrder(planState);
        if (UpdateType.HARD.equals((Object)this.info.getUpdateType())) {
            updateOrder.keySet().stream().forEach(serviceType -> this.addServiceTypePreUpdateStages((ImplyNodeType.ImplyNodeServiceType)serviceType, planState, (Deque<Stage>)updatePlan));
        }
        for (Map.Entry<ImplyNodeType.ImplyNodeServiceType, List<ImplyNodeType>> entry : updateOrder.entrySet()) {
            ImplyNodeType.ImplyNodeServiceType serviceType2 = entry.getKey();
            if (this.isRollingUpdate()) {
                this.addServiceTypePreUpdateStages(serviceType2, planState, updatePlan);
            }
            block17: for (ImplyNodeType nodeType : entry.getValue()) {
                if (this.isRollingUpdate()) {
                    switch (nodeType.getNodeServiceType()) {
                        case MASTER: {
                            this.addRollingMasterReplacementStages(planState, updatePlan);
                            continue block17;
                        }
                        case DATA: {
                            this.addRollingDataReplacementStages(planState, nodeType, updatePlan);
                            continue block17;
                        }
                        case QUERY: {
                            this.addRollingQueryReplacementStages(planState, updatePlan);
                            continue block17;
                        }
                        case PEON: {
                            this.addRollingPeonReplacementStages(planState, updatePlan);
                            continue block17;
                        }
                        case COLD_TIER_DATA: {
                            this.addNonRollingColdTierDataReplacementStages(planState, updatePlan);
                            continue block17;
                        }
                        case COLD_TIER_QUERY: {
                            this.addNonRollingColdTierQueryReplacementStages(planState, updatePlan);
                            continue block17;
                        }
                    }
                    continue;
                }
                if (!UpdateType.HARD.equals((Object)this.info.getUpdateType())) continue;
                switch (nodeType.getNodeServiceType()) {
                    case MASTER: {
                        this.addNonRollingMasterReplacementStages(planState, updatePlan);
                        break;
                    }
                    case DATA: {
                        this.addNonRollingDataReplacementStages(planState, nodeType, updatePlan);
                        break;
                    }
                    case QUERY: {
                        this.addNonRollingQueryReplacementStages(planState, updatePlan);
                        break;
                    }
                    case PEON: {
                        this.addNonRollingPeonReplacementStages(planState, updatePlan);
                        break;
                    }
                    case COLD_TIER_DATA: {
                        this.addNonRollingColdTierDataReplacementStages(planState, updatePlan);
                        break;
                    }
                    case COLD_TIER_QUERY: {
                        this.addNonRollingColdTierQueryReplacementStages(planState, updatePlan);
                        break;
                    }
                }
            }
            if (!this.isRollingUpdate()) continue;
            this.addServiceTypePostUpdateStages(serviceType2, planState, updatePlan);
        }
        if (UpdateType.HARD.equals((Object)this.info.getUpdateType())) {
            updateOrder.keySet().stream().forEach(serviceType -> this.addServiceTypePostUpdateStages((ImplyNodeType.ImplyNodeServiceType)serviceType, planState, (Deque<Stage>)updatePlan));
        }
        this.addPostUpdateStages(planState, updatePlan);
        planState.setPendingRollingStages(updatePlan);
    }

    protected Map<ImplyNodeType.ImplyNodeServiceType, List<ImplyNodeType>> getUpdateOrder(PlanUpdateState planUpdateState) {
        List serviceTypeUpdateOrder = new ArrayList();
        Object dataNodeTypeOrder = planUpdateState.getDataTierInfoMap().keySet().stream().sorted(Comparator.comparingInt(ImplyNodeType::getTierNumber)).collect(Collectors.toList());
        serviceTypeUpdateOrder.addAll(ImmutableList.of((Object)ImplyNodeType.ImplyNodeServiceType.DATA, (Object)ImplyNodeType.ImplyNodeServiceType.PEON, (Object)ImplyNodeType.ImplyNodeServiceType.COLD_TIER_DATA, (Object)ImplyNodeType.ImplyNodeServiceType.QUERY, (Object)ImplyNodeType.ImplyNodeServiceType.COLD_TIER_QUERY, (Object)ImplyNodeType.ImplyNodeServiceType.MASTER));
        if (planUpdateState.isSpecUpdate() && (DiffResultHelper.contains((DiffResult)planUpdateState.getClusterDiffs(), (String)"implyVersionFull") || DiffResultHelper.contains((DiffResult)planUpdateState.getClusterDiffs(), (String)"customDruidBundleIds"))) {
            if (planUpdateState.getStartingCluster().lookupComparableImplyVersion(this.toolbox.getRefreshableConstants()) == null || planUpdateState.getEndingCluster().lookupComparableImplyVersion(this.toolbox.getRefreshableConstants()) == null) {
                throw new ISE("Could not get starting and ending Imply versions for comparison, cannot continue.", new Object[0]);
            }
            if (planUpdateState.getEndingCluster().lookupComparableImplyVersion(this.toolbox.getRefreshableConstants()).compareTo(planUpdateState.getStartingCluster().lookupComparableImplyVersion(this.toolbox.getRefreshableConstants())) < 0) {
                serviceTypeUpdateOrder.remove(ImplyNodeType.ImplyNodeServiceType.PEON);
                serviceTypeUpdateOrder = Lists.reverse(serviceTypeUpdateOrder);
                dataNodeTypeOrder = Lists.reverse((List)dataNodeTypeOrder);
            }
        }
        log.info("Service type update order: %s", new Object[]{serviceTypeUpdateOrder});
        LinkedHashMap<ImplyNodeType.ImplyNodeServiceType, List<ImplyNodeType>> updateOrder = new LinkedHashMap<ImplyNodeType.ImplyNodeServiceType, List<ImplyNodeType>>();
        for (ImplyNodeType.ImplyNodeServiceType serviceType : serviceTypeUpdateOrder) {
            ImmutableList nodeTypes = ImplyNodeType.ImplyNodeServiceType.DATA.equals((Object)serviceType) ? dataNodeTypeOrder : ImmutableList.of((Object)new ImplyNodeType(serviceType));
            updateOrder.put(serviceType, (List<ImplyNodeType>)nodeTypes);
        }
        return updateOrder;
    }

    protected void addPreUpdateStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        updatePlan.add(new SetConfigServerClusterVersionStage(this.toolbox, this.info.getEntityId(), planState.getEndingCluster().getVersion()));
        if (planState.getMiddleManagersToEnable() != null) {
            planState.getMiddleManagersToEnable().forEach(x -> updatePlan.add(new EnableMiddleManagerStage(this.toolbox, this.info.getEntityId(), x.getAddress())));
        }
    }

    protected void addPostUpdateStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        String clusterId = this.info.getEntityId();
        if (UpdateType.HARD.equals((Object)this.info.getUpdateType()) && !this.toolbox.getManagerConfig().isSkipClusterReadyValidation().booleanValue()) {
            this.addAwaitMasterInstancesAvailableStage(planState, updatePlan);
            this.addAwaitQueryInstancesAvailableStage(planState, updatePlan);
            this.addAwaitDataInstancesAvailableStage(planState, updatePlan);
        }
        if (!this.toolbox.getManagerConfig().isSkipClusterReadyValidation().booleanValue()) {
            this.addAwaitColdTierQueryInstancesAvailableStage(planState, updatePlan);
            this.addAwaitColdTierDataInstancesAvailableStage(planState, updatePlan);
        }
        if (planState.isCoordinatorDynamicConfigurationModified() || UpdateType.HARD.equals((Object)this.info.getUpdateType()) && planState.isPerformingRollback() && planState.getCoordinatorDynamicConfiguration() != null) {
            updatePlan.add(new TryAwaitSegmentsAvailableStage(this.toolbox, clusterId, ImplyNodeType.DATA, planState.getMasterHostAddresses(), null));
            User principal = ThreadLocalContext.getPrincipal();
            updatePlan.add(new ModifyCoordinatorDynamicConfigurationStage(this.toolbox, clusterId, ImplyNodeType.MASTER, planState.getMasterHostAddresses(), planState.getCoordinatorDynamicConfiguration(), true, DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), "Restoring [maxSegmentsToMove] and [replicationThrottleLimit] to original values after rolling update"));
        }
    }

    protected List<Host> getHostsToModify(List<Host> allHosts, boolean fullReplacement, int finalNumInstances) {
        return fullReplacement ? allHosts : allHosts.subList(0, Math.max(0, allHosts.size() - finalNumInstances));
    }

    protected void determineAffectedNodeTypes(PlanUpdateState planState) {
        DiffResult diffs;
        if (ListUtils.emptyIfNull((List)this.info.getTransitionStateChain()).contains(State.CLUSTER_RESTART_REQUEST_RECEIVED)) {
            planState.setAllNonPeonNodeTypesReplacement(true);
        }
        if (DiffResultHelper.contains((DiffResult)(diffs = planState.getClusterDiffs()), (String)"implyVersionFull") || DiffResultHelper.contains((DiffResult)diffs, (String)"deepStorage") || DiffResultHelper.contains((DiffResult)diffs, (String)"configServerKey") || DiffResultHelper.contains((DiffResult)diffs, (String)"userExtensions") || DiffResultHelper.contains((DiffResult)diffs, (String)"extensionLoadList") || DiffResultHelper.contains((DiffResult)diffs, (String)"customFiles") || DiffResultHelper.contains((DiffResult)diffs, (String)"encryptDataVolumes") || DiffResultHelper.contains((DiffResult)diffs, (String)"securityConfiguration") || DiffResultHelper.contains((DiffResult)diffs, (String)"userTags") || DiffResultHelper.contains((DiffResult)diffs, (String)"useTls") || DiffResultHelper.contains((DiffResult)diffs, (String)"useAuthentication") || DiffResultHelper.contains((DiffResult)diffs, (String)"otelCollector")) {
            planState.setAllNodeTypesReplacement(true);
        }
        if ((planState.getStartingCluster().getZooKeeper() instanceof ManagedZooKeeper || planState.getEndingCluster().getZooKeeper() instanceof ManagedZooKeeper) && DiffResultHelper.contains((DiffResult)diffs, (String)"masterInstanceCount")) {
            planState.setAllNodeTypesReplacement(true);
        }
        if (!planState.getStartingCluster().getMetadataStorage().getClass().equals(planState.getEndingCluster().getMetadataStorage().getClass())) {
            planState.setFullMasterReplacement(true);
            planState.setFullQueryReplacement(true);
            planState.setFullColdTierQueryReplacement(true);
        }
        if (!planState.getStartingCluster().getDeepStorage().getClass().equals(planState.getEndingCluster().getDeepStorage().getClass())) {
            planState.setFullMasterReplacement(true);
            planState.setFullQueryReplacement(true);
            planState.setFullColdTierQueryReplacement(true);
        }
        ZooKeeper startingZk = planState.getStartingCluster().getZooKeeper();
        ZooKeeper endingZk = planState.getEndingCluster().getZooKeeper();
        if (startingZk == null && !(endingZk instanceof ManagedZooKeeper) || endingZk == null && !(startingZk instanceof ManagedZooKeeper) || startingZk != null && endingZk != null && !startingZk.getClass().equals(endingZk.getClass()) || DiffResultHelper.contains((DiffResult)diffs, (String)"zooKeeper")) {
            planState.setAllNodeTypesReplacement(true);
        }
        if (DiffResultHelper.contains((DiffResult)diffs, (String)"masterInstanceType")) {
            planState.setFullMasterReplacement(true);
        }
        if (DiffResultHelper.contains((DiffResult)diffs, (String)"queryInstanceType")) {
            planState.setFullQueryReplacement(true);
        }
        HashSet<String> touchedServiceTypes = new HashSet<String>();
        Diff customDruidPropertiesDiff = DiffResultHelper.get((DiffResult)diffs, (String)"customDruidProperties");
        if (customDruidPropertiesDiff != null) {
            touchedServiceTypes.addAll(this.determineAffectedNodeTypesFromCustomProperties((Diff<Map<String, String>>)customDruidPropertiesDiff));
        }
        if (DiffResultHelper.contains((DiffResult)diffs, (String)"featureFlags")) {
            HashSet unmodifiedFeatureFlagIds = planState.getStartingCluster().getFeatureFlags() == null ? new HashSet() : new HashSet(planState.getStartingCluster().getFeatureFlags());
            unmodifiedFeatureFlagIds.retainAll((Collection<?>)(planState.getEndingCluster().getFeatureFlags() == null ? ImmutableList.of() : planState.getEndingCluster().getFeatureFlags()));
            HashSet touchedFeatureFlagIds = new HashSet();
            if (planState.getStartingCluster().getFeatureFlags() != null) {
                touchedFeatureFlagIds.addAll(planState.getStartingCluster().getFeatureFlags());
            }
            if (planState.getEndingCluster().getFeatureFlags() != null) {
                touchedFeatureFlagIds.addAll(planState.getEndingCluster().getFeatureFlags());
            }
            touchedFeatureFlagIds.removeAll(unmodifiedFeatureFlagIds);
            touchedServiceTypes.addAll(FeatureFlag.getForIds(touchedFeatureFlagIds, (RefreshableConstants)this.toolbox.getRefreshableConstants()).stream().filter(x -> x.getDruidProperties() != null).flatMap(x -> x.getDruidProperties().keySet().stream()).collect(Collectors.toSet()));
            if (touchedFeatureFlagIds.contains(FeatureFlags.S3_SIGNATURE_V2.toString())) {
                touchedServiceTypes.addAll((Collection<String>)ImmutableSet.of((Object)DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL), (Object)DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER), (Object)DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.COLD_HISTORICAL)));
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.USE_INDEXERS.toString())) {
                touchedServiceTypes.addAll((Collection<String>)ImmutableSet.of((Object)DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER)));
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.SINGLE_AZ.toString())) {
                planState.setFullQueryReplacement(true);
                planState.setFullColdTierQueryReplacement(true);
                planState.getDataTierInfoMap().values().forEach(dataTier -> dataTier.setFullReplacement(true));
                planState.setFullColdTierDataReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.KEYCLOAK_AUTH.toString())) {
                planState.setAllNodeTypesReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.USE_JAVA17.toString())) {
                planState.setAllNodeTypesReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.CONTINUOUS_PROFILING.toString())) {
                planState.setAllNodeTypesReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.IMMUTABLE_CONTAINERS.toString())) {
                planState.setAllNonPeonNodeTypesReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.RESERVE_THREADS_FOR_NON_QUERY_REQUESTS.toString())) {
                planState.setFullQueryReplacement(true);
            }
            if (touchedFeatureFlagIds.contains(FeatureFlags.DISABLE_EXTERNAL_ELB.toString())) {
                planState.setFullQueryReplacement(true);
            }
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.COMMON))) {
            planState.setAllNodeTypesReplacement(true);
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL)) || touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER))) {
            planState.getDataTierInfoMap().values().forEach(dataTier -> dataTier.setFullReplacement(true));
        }
        planState.getDataTierInfoMap().forEach((nodeType, dataTier) -> {
            InstanceTier startingDataTier;
            int dataTierNumber = nodeType.getTierNumber();
            if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL, (ServiceTier)ServiceTier.fromInteger((int)dataTierNumber))) || touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER, (ServiceTier)ServiceTier.fromInteger((int)dataTierNumber)))) {
                dataTier.setFullReplacement(true);
            }
            InstanceTier endingDataTier = planState.getEndingCluster().getDataInstanceTiers() == null ? null : (InstanceTier)planState.getEndingCluster().getDataInstanceTiers().get(dataTierNumber);
            InstanceTier instanceTier = startingDataTier = planState.getStartingCluster().getDataInstanceTiers() == null ? null : (InstanceTier)planState.getStartingCluster().getDataInstanceTiers().get(dataTierNumber);
            if (!(endingDataTier == null || startingDataTier == null || endingDataTier.getName().equals(startingDataTier.getName()) && endingDataTier.getInstanceType().equals(startingDataTier.getInstanceType()) && endingDataTier.getPriority().equals(startingDataTier.getPriority()))) {
                dataTier.setFullReplacement(true);
            }
            dataTier.setInstanceCountDelta((endingDataTier != null ? endingDataTier.getInstanceCount() : 0) - (startingDataTier != null ? startingDataTier.getInstanceCount() : 0));
            dataTier.setDesiredInstanceCount(endingDataTier != null ? endingDataTier.getInstanceCount() : 0);
            dataTier.setOriginalInstanceCount(startingDataTier != null ? startingDataTier.getInstanceCount() : 0);
            dataTier.setTierName(endingDataTier != null ? endingDataTier.getName() : (startingDataTier != null ? startingDataTier.getName() : null));
        });
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.BROKER)) || touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.ROUTER)) || touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.PIVOT))) {
            planState.setFullQueryReplacement(true);
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.COORDINATOR)) || touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.OVERLORD))) {
            planState.setFullMasterReplacement(true);
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.COLD_BROKER))) {
            planState.setFullColdTierQueryReplacement(true);
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.COLD_HISTORICAL))) {
            planState.setFullColdTierDataReplacement(true);
        }
        if (touchedServiceTypes.contains(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.PEON))) {
            planState.setFullPeonReplacement(true);
        }
        if (DiffResultHelper.contains((DiffResult)diffs, (String)"pivot")) {
            planState.setFullQueryReplacement(true);
        }
        if (DiffResultHelper.contains((DiffResult)diffs, (String)"mapbox")) {
            planState.setFullQueryReplacement(true);
        }
    }

    protected boolean isRollingUpdate() {
        return UpdateType.ROLLING.equals((Object)this.info.getUpdateType());
    }

    private Set<String> determineAffectedNodeTypesFromCustomProperties(Diff<Map<String, String>> customPropertiesDiff) {
        Map prev = MapUtils.emptyIfNull((Map)((Map)customPropertiesDiff.getLeft()));
        Map next = MapUtils.emptyIfNull((Map)((Map)customPropertiesDiff.getRight()));
        Sets.SetView symDiff = Sets.symmetricDifference(prev.entrySet(), next.entrySet());
        return symDiff.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected Map<ImplyNodeType, DataTierInfo> constructDataTierInfoMap(Cluster startingCluster, Cluster endingCluster, ClusterNodes startingClusterNodes, ClusterNodes endingClusterNodes) {
        return ImmutableMap.of((Object)ImplyNodeType.DATA_TIER_1, (Object)new DataTierInfo(ImplyNodeType.DATA_TIER_1), (Object)ImplyNodeType.DATA_TIER_2, (Object)new DataTierInfo(ImplyNodeType.DATA_TIER_2), (Object)ImplyNodeType.DATA_TIER_3, (Object)new DataTierInfo(ImplyNodeType.DATA_TIER_3));
    }

    protected abstract boolean populateInitialClusterState(PlanUpdateState var1);

    protected abstract void addRollingMasterReplacementStages(PlanUpdateState var1, Deque<Stage> var2);

    protected abstract void addNonRollingMasterReplacementStages(PlanUpdateState var1, Deque<Stage> var2);

    protected void addPreDataUpdateStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected void addPostDataUpdateStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected abstract void addRollingDataReplacementStages(PlanUpdateState var1, ImplyNodeType var2, Deque<Stage> var3);

    protected abstract void addNonRollingDataReplacementStages(PlanUpdateState var1, ImplyNodeType var2, Deque<Stage> var3);

    protected abstract void addRollingQueryReplacementStages(PlanUpdateState var1, Deque<Stage> var2);

    protected abstract void addNonRollingQueryReplacementStages(PlanUpdateState var1, Deque<Stage> var2);

    protected void addRollingPeonReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected void addNonRollingPeonReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected abstract void addAwaitMasterInstancesAvailableStage(PlanUpdateState var1, Deque<Stage> var2);

    protected abstract void addAwaitQueryInstancesAvailableStage(PlanUpdateState var1, Deque<Stage> var2);

    protected abstract void addAwaitDataInstancesAvailableStage(PlanUpdateState var1, Deque<Stage> var2);

    protected void addAwaitColdTierQueryInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected void addAwaitColdTierDataInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected void addNonRollingColdTierDataReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    protected void addNonRollingColdTierQueryReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
    }

    private void addServiceTypePreUpdateStages(ImplyNodeType.ImplyNodeServiceType serviceType, PlanUpdateState planState, Deque<Stage> updatePlan) {
        switch (serviceType) {
            case DATA: {
                this.addPreDataUpdateStages(planState, updatePlan);
                break;
            }
        }
    }

    private void addServiceTypePostUpdateStages(ImplyNodeType.ImplyNodeServiceType serviceType, PlanUpdateState planState, Deque<Stage> updatePlan) {
        switch (serviceType) {
            case DATA: {
                this.addPostDataUpdateStages(planState, updatePlan);
                break;
            }
        }
    }

    private static /* synthetic */ List lambda$innerHandle$3(List instanceIds, Map.Entry v) {
        return ((List)v.getValue()).stream().filter(x -> !instanceIds.contains(x.getId())).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$innerHandle$1(List instanceIds, Host x) {
        return instanceIds.contains(x.getId());
    }
}

