/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.ExceptionHandlingNotice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;

public abstract class HandleRollbackUpdateRequestNotice
extends ExceptionHandlingNotice {
    public HandleRollbackUpdateRequestNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    public void innerHandle() {
        UpdateState updateState = this.info.getUpdateState();
        State currentState = updateState.getCurrentState();
        State initialRollbackState = currentState != null && ImmutableList.of((Object)State.UPDATING_CLUSTER_STACK, (Object)State.CLUSTER_STACK_UPDATED, (Object)State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS).contains((Object)currentState) ? State.CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK : State.CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK;
        this.entityStateDataManager.insert(this.info, Info.builder().withState(initialRollbackState).withDesiredState(State.CLUSTER_UPDATE_ROLLED_BACK).build());
        this.setQueueNextNotice();
    }

    @Override
    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    @Override
    protected State getExceptionState() {
        return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
    }

    @Override
    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}

