/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.ExceptionHandlingNotice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;

public abstract class HandleRetryUpdateRequestNotice
extends ExceptionHandlingNotice {
    public HandleRetryUpdateRequestNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    public void innerHandle() {
        UpdateState updateState = this.info.getUpdateState();
        State currentState = updateState.getCurrentState();
        State initialRetryState = switch (currentState) {
            case State.UPDATING_CLUSTER_STACK -> State.CLUSTER_UPDATE_REQUEST_INTERNAL;
            case State.CLUSTER_UPDATE_ROLLING_BACK_STACK -> State.CLUSTER_UPDATE_ROLLBACK_STACK;
            default -> currentState;
        };
        UpdateState.Builder updateStateBuilder = UpdateState.builder((UpdateState)updateState).clearTimerAndCounters();
        if (UpdateType.HARD.equals((Object)this.info.getUpdateType()) && UpdateType.ROLLING.equals((Object)updateState.getType())) {
            updateStateBuilder.type(this.info.getUpdateType()).pendingRollingStages(this.toolbox.getStageHelper().convertRollingToHardUpdate(updateState.getPendingRollingStages()));
        }
        this.entityStateDataManager.insert(this.info, Info.builder().withState(initialRetryState).withUpdateState(updateStateBuilder.build()).build());
        this.setQueueNextNotice();
    }

    @Override
    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    @Override
    protected State getExceptionState() {
        return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
    }

    @Override
    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}

