/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.account;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.State;
import io.imply.cloud.util.Logger;

public abstract class DeleteAccountRecordNotice
extends Notice {
    private static final Logger log = new Logger(DeleteAccountRecordNotice.class);

    public DeleteAccountRecordNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.ACCOUNT);
    }

    @Override
    public void innerHandle() {
        this.toolbox.getAccountDataManager().delete(this.info.getEntityId(), this.info.getRequesterId());
        this.toolbox.getNotificationDataManager().deleteNotificationsWithEntityKey(this.info.getKey());
        this.entityStateDataManager.delete(this.info);
        log.info(true, "Account [%s] deleted", new Object[]{this.info.getEntityId()});
        this.addInfoNotification("Account deleted", new Object[0]);
        this.markNotificationsAsPrevious();
    }

    @Override
    protected State getTimeoutState() {
        return State.ACCOUNT_DELETION_FAILED;
    }
}

