/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.StateActionTable;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.ImpersonatedUser;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.telemetry.CloudEvent;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.StringUtils;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public abstract class Notice {
    private static final Logger log = new Logger(Notice.class);
    private final EntityType expectedEntityType;
    protected Info info;
    protected Map<String, Object> customData;
    protected CompletableFuture<Void> future;
    protected final ManagerToolbox toolbox;
    protected final EntityStateDataManager entityStateDataManager;
    private boolean queueNextNotice = false;

    public Notice(ManagerToolbox toolbox, EntityType expectedEntityType) {
        this.toolbox = toolbox;
        this.expectedEntityType = expectedEntityType;
        this.entityStateDataManager = toolbox.getEntityStateDataManager();
    }

    protected Notice(ManagerToolbox toolbox, Info info) {
        this.toolbox = toolbox;
        this.info = info;
        this.expectedEntityType = info.getEntityType();
        this.entityStateDataManager = toolbox.getEntityStateDataManager();
    }

    public Notice withInfo(Info info) {
        if (this.expectedEntityType != null && info != null) {
            Preconditions.checkArgument((boolean)this.expectedEntityType.equals((Object)info.getEntityType()), (String)"Cannot be called with entityType [%s]", (Object)info.getEntityType());
        }
        this.info = info;
        return this;
    }

    public Notice withCustomData(Map<String, Object> customData) {
        this.customData = customData;
        return this;
    }

    public Notice withFuture(CompletableFuture<Void> future) {
        this.future = future;
        return this;
    }

    public String getRequestId() {
        return this.info == null ? null : this.info.getRequestId();
    }

    public String getParentSpanId() {
        return this.info == null ? null : this.info.getParentSpanId();
    }

    public String getSpanId() {
        return this.info == null ? null : this.info.getSpanId();
    }

    public String getRequesterId() {
        return this.info == null ? null : this.info.getRequesterId();
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean isQueueNextNotice() {
        return this.queueNextNotice;
    }

    protected void setQueueNextNotice() {
        this.queueNextNotice = true;
    }

    @VisibleForTesting
    public void setQueueNextNoticeInTest() {
        this.queueNextNotice = true;
    }

    protected void refreshInfo() {
        if (this.info != null) {
            this.info = this.entityStateDataManager.get(this.info);
            ThreadLocalContext.setUserContext((Map)this.info.getContext());
            ThreadLocalContext.setSystemContext((String)"isMock", (Object)this.info.isMockEntity());
        }
        ThreadLocalContext.setRequestId((String)this.getRequestId());
        ThreadLocalContext.setSpanId((String)this.getSpanId());
        ThreadLocalContext.setParentSpanId((String)this.getParentSpanId());
        if (this.getRequesterId() != null) {
            User principal;
            if ("SUPER_PRINCIPAL".equals(this.getRequesterId())) {
                principal = new User("SUPER_PRINCIPAL", "SUPER_PRINCIPAL", null, null, null, null);
            } else if ("SYSTEM".equals(this.getRequesterId())) {
                principal = new User("SYSTEM", "SYSTEM", null, null, null, null);
            } else {
                Matcher matcher = Constants.IMPERSONATED_USER_ID_PATTERN.matcher(this.info.getRequesterId());
                if (matcher.matches()) {
                    User user = new User(matcher.group(2), null, null, null, null, null);
                    principal = new ImpersonatedUser(user, matcher.group(1));
                } else {
                    principal = new User(this.info.getRequesterId(), null, null, null, null, null);
                }
            }
            ThreadLocalContext.setPrincipal((User)principal);
        }
    }

    public void handle() {
        this.handle(false);
    }

    protected void handle(boolean skipClearingThreadLocalContext) {
        this.validate();
        long startTimeNanoSeconds = System.nanoTime();
        try {
            ThreadLocalContext.setNoticeOrActionClass(this.getClass());
            ThreadLocalContext.setCacheId((String)UUID.randomUUID().toString().substring(0, 8));
            this.refreshInfo();
            if (this.info != null && !(this instanceof OperationsNotice)) {
                switch (this.info.getEntityType()) {
                    case ACCOUNT: {
                        Class<? extends Notice> accountClazz = StateActionTable.getAccountNoticeClass(this.info.getState(), this.info.getDesiredState());
                        if (accountClazz != null && accountClazz.isAssignableFrom(this.getClass())) break;
                        log.warn("Cancelling notice [%s] for account [%s] that does not correspond to state [%s]", new Object[]{this.getClass().getSimpleName(), this.info.getEntityId(), this.info.getState()});
                        return;
                    }
                    case CLUSTER: {
                        Class<? extends Notice> clusterClazz = StateActionTable.getClusterNoticeClass(this.info.getState(), this.info.getDesiredState());
                        if (clusterClazz != null && clusterClazz.isAssignableFrom(this.getClass())) break;
                        log.warn("Cancelling notice [%s] for cluster [%s] that does not correspond to state [%s]", new Object[]{this.getClass().getSimpleName(), this.info.getEntityId(), this.info.getState()});
                        return;
                    }
                    case TEST: {
                        log.warn("Handling notice [%s] marked as with entity type [TEST]", new Object[]{this.getClass().getSimpleName()});
                        break;
                    }
                    default: {
                        throw new ISE("Trying to run notice for unsupported entityType [%s]", new Object[]{this.info.getEntityType()});
                    }
                }
                if (this.info.getLastStateChange() != null && this.info.getState() != null && this.info.getLastStateChange().plus((ReadablePeriod)this.info.getState().getTimeoutPeriod(this.toolbox.getApplicationConfig())).isBeforeNow()) {
                    String errorMessage = String.format("Entity [%s] has timed out after [%d] seconds while in state [%s]", this.info.getEntityId(), this.info.getState().getTimeoutPeriod(this.toolbox.getApplicationConfig()).toStandardDuration().getStandardSeconds(), this.info.getState());
                    log.warn(errorMessage);
                    if (this.getTimeoutState() != null) {
                        this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getTimeoutState()).build());
                    }
                    this.addNotification(Notification.Source.MANAGER, Status.WARNING.equals((Object)this.getFailureStatus()) ? Notification.Level.WARNING : Notification.Level.CRITICAL, "Operation timed out after [%d] seconds [state: %s]", this.info.getState().getTimeoutPeriod(this.toolbox.getApplicationConfig()).toStandardDuration().getStandardSeconds(), this.info.getState());
                    return;
                }
            }
            this.innerHandle();
            if (this.future != null) {
                this.future.complete(null);
            }
        }
        catch (RuntimeException e) {
            if (this.future != null) {
                this.future.completeExceptionally(e);
            }
            throw e;
        }
        finally {
            this.maybeEmitClusterOperationMetric();
            this.emitNoticeRuntimeMetric(System.nanoTime() - startTimeNanoSeconds);
            if (!skipClearingThreadLocalContext) {
                ThreadLocalContext.clear();
            }
        }
    }

    private void maybeEmitClusterOperationMetric() {
        if (!this.shouldEmitClusterOperationMetric()) {
            return;
        }
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId(), DeletedVisibility.SHOW_RECENT);
        long duration = new Duration((ReadableInstant)(this.info.getLastStateChange() == null ? this.info.getLastModified() : this.info.getLastStateChange()), (ReadableInstant)DateTime.now()).getStandardSeconds();
        State nextState = this.entityStateDataManager.get(this.info).getState();
        this.toolbox.getEmitter().emit(this.buildDurationEvent(CloudEvent.metricBuilder((String)"state_duration", (Number)duration, (Cluster)cluster).addAttribute((Object)"state", (Object)this.info.getState()).addAttribute((Object)"next_state", (Object)nextState).addAttribute((Object)"desired_state", (Object)this.info.getDesiredState()).addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"is_final_state", (Object)nextState.isFinalState())));
    }

    protected void emitNoticeRuntimeMetric(long durationNanoSeconds) {
        MetricEvent.Builder builder = MetricEvent.builder((String)MetricRegistry.name(Notice.class, (String[])new String[]{"runtime_duration"})).addAttribute((Object)"notice", (Object)this.getClass().getName()).addAttribute((Object)"platform", (Object)this.toolbox.getApplicationConfig().getPlatform()).value((Number)durationNanoSeconds);
        if (this.info != null) {
            builder.addAttribute((Object)"entity_id", (Object)this.info.getEntityId()).addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"entity_type", (Object)this.info.getEntityType());
        }
        this.toolbox.getEmitter().emit(this.buildDurationEvent(builder));
    }

    private boolean shouldEmitClusterOperationMetric() {
        if (this.info == null) {
            return false;
        }
        if (this.info.getEntityType() == null || this.info.getEntityType() != EntityType.CLUSTER) {
            return false;
        }
        return !this.info.getState().equals((Object)this.entityStateDataManager.get(this.info).getState());
    }

    protected Event buildDurationEvent(MetricEvent.Builder eventBuilder) {
        return eventBuilder.build();
    }

    protected void validate() {
        if (!(this instanceof OperationsNotice)) {
            Preconditions.checkNotNull((Object)this.info, (Object)"withInfo() must be set before calling handle()");
        }
    }

    protected abstract void innerHandle();

    protected State getTimeoutState() {
        return null;
    }

    protected Status getFailureStatus() {
        return Status.CRITICAL;
    }

    private void addNotification(Notification.Source source, Notification.Level level, String message, Object ... formatArgs) {
        if (this.info == null || this.info.getKey() == null) {
            return;
        }
        Notification notification = Notification.of((String)StringUtils.safeFormat((String)message, (Object[])formatArgs), null, (Notification.Level)level, (Notification.Source)source, (String)this.info.getKey());
        this.addNotification(notification);
    }

    protected void addNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        log.info(Notification.Level.CRITICAL.equals((Object)notification.getLevel()), "[Notification | %s]: %s", new Object[]{notification.getLevel(), notification.getMessage()});
        this.toolbox.getNotificationDataManager().insert(notification);
    }

    protected void addNotifications(Notifications notifications) {
        if (notifications == null) {
            return;
        }
        List notificationList = notifications.getNotificationList();
        if (notificationList == null) {
            return;
        }
        ArrayList myNotificationList = new ArrayList(notificationList);
        List existingNotifications = this.toolbox.getNotificationDataManager().getAllWithEntityKey(this.info.getKey()).getNotificationList();
        myNotificationList.removeAll(existingNotifications);
        myNotificationList.stream().forEach(x -> this.toolbox.getNotificationDataManager().insert(x));
    }

    protected void addInfoNotification(String message, Object ... formatArgs) {
        this.addInfoNotification(Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addInfoNotification(Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(source, Notification.Level.INFO, message, formatArgs);
    }

    protected void addWarningNotification(String message, Object ... formatArgs) {
        this.addWarningNotification(Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addWarningNotification(Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(source, Notification.Level.WARNING, message, formatArgs);
    }

    protected void addCriticalNotification(String message, Object ... formatArgs) {
        this.addCriticalNotification(Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addCriticalNotification(Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(source, Notification.Level.CRITICAL, message, formatArgs);
    }

    protected void addFailureNotification(String message, Object ... formatArgs) {
        this.addFailureNotification(Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addFailureNotification(Notification.Source source, String message, Object ... formatArgs) {
        if (Status.WARNING.equals((Object)this.getFailureStatus())) {
            this.addWarningNotification(source, message, formatArgs);
        } else {
            this.addCriticalNotification(source, message, formatArgs);
        }
    }

    protected void markNotificationsAsPrevious() {
        if (this.info == null || this.info.getKey() == null) {
            return;
        }
        this.toolbox.getNotificationDataManager().markNotificationsAsPrevious(this.info.getKey());
    }

    protected boolean executeStagesImmediately(Collection<Stage> stages) {
        if (stages == null) {
            return true;
        }
        for (Stage stage : stages) {
            try {
                log.info("Executing stage [%s]: %s", new Object[]{stage.getName(), stage.getDescription()});
                if (stage.run(new Stage.State(DateTime.now()))) {
                    log.info("Stage [%s] returned [SUCCESS]", new Object[]{stage.getName()});
                    continue;
                }
                log.warn("Stage [%s] returned [FAIL]", new Object[]{stage.getName()});
                return false;
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Caught exception while running stage [%s]: %s", new Object[]{stage.getName(), stage.getDescription()});
                return false;
            }
        }
        return true;
    }

    protected <T> T getCustomData(String key, Class<T> clazz) {
        if (this.customData == null || clazz == null || this.customData.get(key) == null) {
            return null;
        }
        Object data = this.customData.get(key);
        return (T)(clazz.isInstance(data) ? data : null);
    }
}

