/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.filters;

import io.imply.cloud.exception.AccessDeniedException;
import io.imply.cloud.manager.ClusterAuthorization;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ISE;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import lombok.Generated;

@ClusterAuthorization
@Provider
public class ClusterAuthorizationFilter
implements ContainerRequestFilter {
    private final ClusterDataManager clusterDataManager;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext context) throws IOException {
        User user = (User)context.getSecurityContext().getUserPrincipal();
        String pathParam = this.getPathParam();
        MultivaluedMap pathParams = context.getUriInfo().getPathParameters();
        if (pathParams.containsKey((Object)pathParam)) {
            Cluster cluster = this.clusterDataManager.get((String)pathParams.getFirst((Object)pathParam));
            if (!user.getAccountIds().contains(cluster.getAccountId())) {
                throw new AccessDeniedException(String.format("Authorization failed: principal [%s] is not allowed to perform this action", user.getUserId()), new Object[0]);
            }
        }
    }

    private String getPathParam() {
        Method method = this.resourceInfo.getResourceMethod();
        ClusterAuthorization annotation = method.getAnnotation(ClusterAuthorization.class);
        if (annotation != null) {
            return annotation.value();
        }
        Class clazz = this.resourceInfo.getResourceClass();
        annotation = clazz.getAnnotation(ClusterAuthorization.class);
        if (annotation != null) {
            return annotation.value();
        }
        throw new ISE("An unexpected error occurred during authentication", new Object[0]);
    }

    @Inject
    @Generated
    public ClusterAuthorizationFilter(ClusterDataManager clusterDataManager) {
        this.clusterDataManager = clusterDataManager;
    }

    @Generated
    public ClusterAuthorizationFilter(ClusterDataManager clusterDataManager, ResourceInfo resourceInfo) {
        this.clusterDataManager = clusterDataManager;
        this.resourceInfo = resourceInfo;
    }
}

