/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.user;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;

public class DescribeUsersAction
extends AccountAuthenticatedAction {
    private final String accountId;

    @JsonCreator
    public DescribeUsersAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        if (!this.getToolbox().getAccountDataManager().exists(this.accountId)) {
            throw new IAE("Failed to describe users: account [%s] does not exist", new Object[]{this.accountId});
        }
        List users = this.getToolbox().getUserDataManager().getAllWithAccountId(this.accountId);
        return ImmutableMap.of((Object)"users", (Object)users);
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }
}

