/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.user;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DescribeUserAction
extends AuthenticatedAction {
    private final String userId;

    @JsonCreator
    public DescribeUserAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="userId") String userId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
        this.userId = userId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"[userId] required");
        return this.getToolbox().getUserDataManager().get(this.userId);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"[userId] required");
        User user = this.getToolbox().getUserDataManager().get(this.userId);
        for (String accountId : user.getAccountIds()) {
            if (!principal.getAccountIds().contains(accountId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", (Object)this.userId).append("context", this.getContext()).toString();
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS, (Object)Platform.ONPREM);
    }
}

