/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.user;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CreateUserAction
extends AuthenticatedAction {
    private final User user;

    @JsonCreator
    public CreateUserAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="user") User user, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
        this.user = user;
    }

    @Override
    public Object innerPerform() {
        this.validateInput();
        for (String accountId : this.user.getAccountIds()) {
            if (this.getToolbox().getAccountDataManager().exists(accountId)) continue;
            throw new IAE("Failed to create user: account [%s] does not exist", new Object[]{accountId});
        }
        String userId = this.getToolbox().getUserDataManager().create(this.user, ThreadLocalContext.getPrincipal().getDetailedUserId()).getUserId();
        return ImmutableMap.of((Object)"userId", (Object)userId);
    }

    @Override
    public boolean isAuthorized(User principal) {
        this.validateInput();
        return principal.getAccountIds().containsAll(this.user.getAccountIds());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("user", (Object)this.user).append("context", this.getContext()).toString();
    }

    @Override
    public Collection<String> getAccountIds() {
        this.validateInput();
        return this.user.getAccountIds();
    }

    private void validateInput() {
        Preconditions.checkArgument((this.user != null ? 1 : 0) != 0, (Object)"[user] required");
        Preconditions.checkArgument((!this.user.getAccountIds().isEmpty() ? 1 : 0) != 0, (Object)"[user.accountId or user.accountIds] required");
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS, (Object)Platform.ONPREM);
    }
}

