/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Constants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateClusterAction
extends ClusterAuthenticatedAction {
    private static final Logger log = new Logger(UpdateClusterAction.class);
    @JsonProperty
    private final UpdateType updateType;
    @JsonProperty
    private final Cluster cluster;
    @JsonProperty
    private final boolean autoIncrementVersion;
    @JsonProperty
    private final Integer maxSurgeCount;

    @JsonCreator
    public UpdateClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="updateType") UpdateType updateType, @JsonProperty(value="cluster") Cluster cluster, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal, @JsonProperty(value="maxSurgeCount") Integer maxSurgeCount) {
        this(toolbox, updateType, context, principal, cluster, false, maxSurgeCount);
    }

    public UpdateClusterAction(ManagerToolbox toolbox, UpdateType updateType, Map<String, String> context, String principal, Cluster cluster, boolean autoIncrementVersion, Integer maxSurgeCount) {
        super(toolbox, context, principal, cluster != null ? cluster.getClusterId() : null);
        this.updateType = updateType;
        this.cluster = cluster != null ? cluster.cloner().withSensitiveFieldPlaceholdersRemoved().build() : null;
        this.autoIncrementVersion = autoIncrementVersion;
        this.maxSurgeCount = maxSurgeCount;
    }

    @Override
    public Object innerPerform() {
        boolean onlyUpdateSpec;
        ImplyVersion implyVersion;
        Preconditions.checkArgument((this.updateType != null ? 1 : 0) != 0, (Object)"[updateType] required");
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Preconditions.checkArgument((this.cluster.getClusterId() != null ? 1 : 0) != 0, (Object)"[cluster.clusterId] required");
        Preconditions.checkArgument((this.cluster.getVersion() != null ? 1 : 0) != 0, (Object)"[cluster.version] required");
        Cluster originalCluster = this.getToolbox().getClusterDataManager().get(this.cluster.getClusterId());
        Info info = this.getToolbox().getEntityStateDataManager().get(this.cluster);
        if (this.cluster.getAccountId() != null && !this.cluster.getAccountId().equals(originalCluster.getAccountId())) {
            throw new IAE("Update failed for cluster [%s]: accountId cannot be modified", new Object[]{this.cluster.getClusterId()});
        }
        Account account = this.getToolbox().getAccountDataManager().get(originalCluster.getAccountId());
        Cluster clusterWithUpdatableFields = this.cluster.cloner().withoutNonUpdatableFields().build();
        Cluster mergedCluster = originalCluster.cloner().withCluster(clusterWithUpdatableFields, true).withDefaultsForUnset(this.getToolbox().getApplicationConfig(), false, this.getToolbox().getInstanceTypeHelper()).build();
        ImplyVersion implyVersion2 = implyVersion = this.cluster.getImplyVersionFull() != null ? this.cluster.getImplyVersionFull() : this.getToolbox().getImplyVersionHelper().lookupImplyVersionIncludingAccountVersions(mergedCluster.getImplyVersion(), account.getAccountId(), this.getToolbox().getClusterDataManager());
        if (implyVersion == null) {
            throw new IAE("Failed to update cluster: implyVersion [%s] is not supported", new Object[]{mergedCluster.getImplyVersion()});
        }
        mergedCluster = mergedCluster.cloner().withImplyVersionFull(implyVersion).withImplyVersion(implyVersion.getVersion()).withImplyBundleId(implyVersion.getBundleId()).build();
        Cluster diffCluster = clusterWithUpdatableFields.mergeDiff(originalCluster);
        if (diffCluster.getImplyVersion() != null || diffCluster.getImplyVersionFull() != null) {
            diffCluster = diffCluster.cloner().withImplyVersionFull(implyVersion).withImplyVersion(implyVersion.getVersion()).build();
        }
        if (diffCluster.isEmpty()) {
            throw new IAE("Unable to apply update for cluster [%s] - nothing has changed", new Object[]{this.cluster.getClusterId()});
        }
        boolean onlyInformationalFieldsChanged = diffCluster.cloner().withInfoOnlyFieldsRemoved().build().isEmpty();
        if (!onlyInformationalFieldsChanged) {
            mergedCluster.validate(account, (Toolbox)this.getToolbox(), false);
        }
        this.handleMagicTags(mergedCluster, this.getContext());
        int proposedTotalMICU = this.getToolbox().getClusterUpdateHelper().getTotalMICU(account.getAccountId(), info.getState() != null && info.getState().isRunning() ? mergedCluster : null);
        if (account.isValueExceedingIcuLimit(proposedTotalMICU)) {
            throw new IAE("Failed to update cluster: ICU limit of [%d] would be exceeded", new Object[]{account.getIcuLimit()});
        }
        List<UpdateDetails> possibleUpdateTypes = this.getToolbox().getClusterUpdateHelper().getUpdateDetailsForClusterDiff(diffCluster, originalCluster);
        if (possibleUpdateTypes.stream().anyMatch(x -> UpdateType.UNSUPPORTED.equals((Object)x.getType()))) {
            List displayText = possibleUpdateTypes.stream().filter(x -> UpdateType.UNSUPPORTED.equals((Object)x.getType())).findFirst().get().getDisplayText();
            throw new IAE("Changeset contains unsupported update parameters: %s", new Object[]{displayText});
        }
        boolean bl = onlyUpdateSpec = info.getState().isStoppedTerminatedOrFailed() || onlyInformationalFieldsChanged;
        if (onlyUpdateSpec) {
            log.info("Only updating spec for cluster [%s]", new Object[]{mergedCluster.getClusterId()});
            ClusterWithExtendedInfo updatedClusterWithInfo = this.getToolbox().getClusterDataManager().updateWithInfo(mergedCluster, this.getDefaultInfoBuilder(mergedCluster).build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), this.autoIncrementVersion, true, true, true, false);
            return ImmutableMap.of((Object)"clusterId", (Object)updatedClusterWithInfo.getCluster().getClusterId());
        }
        if (!State.CLUSTER_UPDATE_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{mergedCluster.getClusterId(), info.getState(), State.CLUSTER_UPDATE_REQUEST_RECEIVED, State.CLUSTER_UPDATE_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        if (possibleUpdateTypes.stream().noneMatch(x -> x.getType().equals((Object)this.updateType))) {
            throw new IAE("updateType [%s] is not valid for this changeset", new Object[]{this.updateType});
        }
        mergedCluster.validateClusterInUpdatableState((Toolbox)this.getToolbox());
        Cluster modifiedParameters = diffCluster.cloner().withoutNonUpdatableFields().withVersion(null).withImplyVersionFull(null).build();
        Cluster originalParameters = originalCluster.filterNonNullFields(modifiedParameters);
        ImmutableList supportedTypes = UpdateType.HARD.equals((Object)this.updateType) ? ImmutableList.of((Object)UpdateType.HARD) : possibleUpdateTypes.stream().map(UpdateDetails::getType).collect(Collectors.toList());
        Info.Builder updateInfoBuilder = this.getDefaultInfoBuilder(mergedCluster).withState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(this.updateType).withMaxSurgeCount((Integer)ObjectUtils.defaultIfNull((Object)this.maxSurgeCount, (Object)1)).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).modifiedParameters(Cluster.clusterToMapWithoutType((ObjectMapper)this.getToolbox().getObjectMapper(), (Cluster)modifiedParameters)).originalParameters(Cluster.clusterToMapWithoutType((ObjectMapper)this.getToolbox().getObjectMapper(), (Cluster)originalParameters)).supportedTypes((List)supportedTypes).build()).clearExistingUpdateState();
        ClusterWithExtendedInfo updatedClusterWithInfo = this.getToolbox().getClusterDataManager().updateWithInfo(mergedCluster, updateInfoBuilder.build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), this.autoIncrementVersion, true, false, false, true);
        this.clearAllNotifications(updatedClusterWithInfo.getCluster().key());
        this.addInfoNotification(updatedClusterWithInfo.getCluster().key(), "Cluster update requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(updatedClusterWithInfo.getExtendedInfo().getInfo());
        return ClusterWithExtendedInfo.build((Cluster)updatedClusterWithInfo.getCluster().cloner().withSensitiveFieldsMasked().build(), (ExtendedInfo)updatedClusterWithInfo.getExtendedInfo(), (boolean)true);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Preconditions.checkArgument((this.cluster.getClusterId() != null ? 1 : 0) != 0, (Object)"[cluster.clusterId] required");
        return super.isAuthorized(principal);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("updateType", (Object)this.updateType).append("cluster", (Object)this.cluster).append("context", this.getContext()).toString();
    }
}

